/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Christopher Blizzard.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Christopher Blizzard <blizzard@mozilla.org>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include <nsCOMPtr.h>
#include <nsIDOMMouseEvent.h>

#include "nsIDOMNSEvent.h"
#include "nsIContent.h"
#include "nsIDocument.h"
#include "nsIPresShell.h"
#include "nsIDOMNodeList.h"

#include "nsIDOM3Node.h"
#include "nsIDOMDocument.h"
#include "nsILocalFile.h"
#include "nsIWebBrowserPersist.h"
#include "nsNetCID.h"
#include "nsIDOMElement.h"
#include "nsCWebBrowserPersist.h"
#include "nsIDOMWindow.h"
#include "nsIDOMMouseEvent.h"
#include "nsIIOService.h"
#include "nsISelectionController.h"
#include "nsIDOMPopupBlockedEvent.h"
#include "nsIPrefService.h"
#include "EmbedGtkTools.h"

#include "nsIDOMKeyEvent.h"
#include "nsIDOMUIEvent.h"

#include "EmbedEventListener.h"
#include "EmbedPrivate.h"
#include "gtkmozembed_internal.h"

#include "nsIDOMEventTarget.h"

static PRInt32 sScrollStep = 2;
static PRBool  sForcePan = PR_FALSE;
#define START_PANNING_STEP 8

static PRBool sDirectPan = PR_TRUE;

static float sMultiplier = 50.0;
static PRInt32 sTimerStep = 25;
static PRInt32 sKineticType = 0;
static PRBool sScrollAlways = PR_FALSE;

EmbedEventListener::EmbedEventListener(void)
{
  mOwner = nsnull;
  mXSLTransformed = PR_FALSE;
  mClickCount = 1;
  mFocusInternalFrame = PR_FALSE;
}

EmbedEventListener::~EmbedEventListener()
{
  Shutdown();
}

NS_IMPL_ADDREF(EmbedEventListener)
NS_IMPL_RELEASE(EmbedEventListener)
NS_INTERFACE_MAP_BEGIN(EmbedEventListener)
  NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsISupports, nsIDOMKeyListener)
  NS_INTERFACE_MAP_ENTRY_AMBIGUOUS(nsIDOMEventListener, nsIDOMKeyListener)
  NS_INTERFACE_MAP_ENTRY(nsIDOMKeyListener)
  NS_INTERFACE_MAP_ENTRY(nsIDOMMouseListener)
  NS_INTERFACE_MAP_ENTRY(nsIDOMUIListener)
  NS_INTERFACE_MAP_ENTRY(nsIDOMFocusListener)
NS_INTERFACE_MAP_END

nsresult
EmbedEventListener::Shutdown()
{
  mOwner = nsnull;
  mXSLTransformed = PR_FALSE;
  return NS_OK;
}

nsresult
EmbedEventListener::Init(EmbedPrivate *aOwner)
{
  nsresult rv;
  mOwner = aOwner;
  mClickCount = 1;
  nsCOMPtr<nsIPrefBranch> prefs = do_GetService(NS_PREFSERVICE_CONTRACTID);
  if (!prefs)
    return NS_OK;

  PRInt32 scrollStep = 0;
  PRBool forcePan = PR_FALSE;
  PRBool directPan = PR_TRUE;
  PRInt32 multiplier = 0;
  PRInt32 timerStep = 0;
  PRInt32 kineticType = 0;
  PRBool scrollAlways = PR_FALSE;
  rv = prefs->GetIntPref("gtkmozembed.mscroll.step", &scrollStep);
  if (scrollStep && NS_SUCCEEDED(rv))
    sScrollStep = scrollStep;

  rv = prefs->GetBoolPref("gtkmozembed.mscroll.force", &forcePan);
  if (scrollStep && NS_SUCCEEDED(rv))
    sForcePan = forcePan;

  rv = prefs->GetBoolPref("gtkmozembed.mscroll.direct", &directPan);
  if (NS_SUCCEEDED(prefs->GetBoolPref("gtkmozembed.mscroll.direct", &directPan)) && !directPan)
    sDirectPan = directPan;

  rv = prefs->GetIntPref("gtkmozembed.kinetic.multiplier", &multiplier);
  if (NS_SUCCEEDED(rv))
    sMultiplier = (float)multiplier;

  rv = prefs->GetIntPref("gtkmozembed.kinetic.timer_step", &timerStep);
  if (NS_SUCCEEDED(rv))
    sTimerStep = timerStep;

  rv = prefs->GetIntPref("gtkmozembed.kinetic.type", &kineticType);
  if (NS_SUCCEEDED(rv))
    sKineticType = kineticType;

  rv = prefs->GetBoolPref("gtkmozembed.mscroll.always", &scrollAlways);
  if (NS_SUCCEEDED(rv))
    sScrollAlways = scrollAlways;

  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::HandleLink(nsIDOMNode* node)
{
  nsresult rv;

  nsCOMPtr<nsIDOMElement> linkElement;
  linkElement = do_QueryInterface(node);
  if (!linkElement) return NS_ERROR_FAILURE;

  nsString name;
  rv = linkElement->GetAttribute(NS_LITERAL_STRING("rel"), name);
  if (NS_FAILED(rv)) return NS_ERROR_FAILURE;

  nsString link;
  rv = linkElement->GetAttribute(NS_LITERAL_STRING("href"), link);
  if (NS_FAILED(rv) || link.IsEmpty()) return NS_ERROR_FAILURE;

  nsCOMPtr<nsIDOMDocument> domDoc;
  rv = node->GetOwnerDocument(getter_AddRefs(domDoc));
  if (NS_FAILED(rv) || !domDoc) return NS_ERROR_FAILURE;

  nsCOMPtr<nsIDOM3Node> domnode = do_QueryInterface(domDoc);
  if (!domnode) return NS_ERROR_FAILURE;

  nsString spec;
  domnode->GetBaseURI(spec);

  nsCOMPtr<nsIURI> baseURI;
  rv = NewURI(getter_AddRefs(baseURI), NS_ConvertUTF16toUTF8(spec).get());
  if (NS_FAILED(rv) || !baseURI) return NS_ERROR_FAILURE;

  nsCString url;
  rv = baseURI->Resolve(NS_ConvertUTF16toUTF8(link), url);
  if (NS_FAILED(rv)) return NS_ERROR_FAILURE;

  nsString type;
  rv = linkElement->GetAttribute(NS_LITERAL_STRING("type"), type);
  if (NS_FAILED(rv)) return NS_ERROR_FAILURE;

  nsString title;
  rv = linkElement->GetAttribute(NS_LITERAL_STRING("title"), title);
  if (NS_FAILED(rv)) return NS_ERROR_FAILURE;

  // XXX This does not handle |BLAH ICON POWER"
  if (name.LowerCaseEqualsLiteral("alternate") &&
      type.LowerCaseEqualsLiteral("application/rss+xml")) {

    NS_ConvertUTF16toUTF8 narrowTitle(title);

    g_signal_emit(GTK_OBJECT(mOwner->mOwningWidget),
                  moz_embed_signals[RSS_REQUEST], 0,
                  (gchar *)url.get(),
                  narrowTitle.get());
    mXSLTransformed = PR_FALSE;
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::HandleEvent(nsIDOMEvent* aDOMEvent)
{
  nsString eventType;
  aDOMEvent->GetType(eventType);

  if (mOwner->mWindow && eventType.EqualsLiteral("DOMLinkXSLParsed")) {
    mXSLTransformed = PR_TRUE;
    return NS_OK;
  }

  if (eventType.EqualsLiteral("focus"))
    printf("FIXME >>>>>>Func:%s::%d\n", __PRETTY_FUNCTION__, __LINE__);
/*
    if (mCtxInfo->GetFormControlType(aDOMEvent)) {
      if (mCtxInfo->mEmbedCtxType & GTK_MOZ_EMBED_CTX_INPUT_TEXT) {
        gint return_val = FALSE;
        g_signal_emit(GTK_OBJECT(mOwner->mOwningWidget),
                      moz_embed_signals[DOM_FOCUS], 0,
                      (void *)aDOMEvent, &return_val);
        if (return_val) {
          aDOMEvent->StopPropagation();
          aDOMEvent->PreventDefault();
        }
      }
    }
*/

  if (eventType.EqualsLiteral("DOMPopupBlocked")) {
    nsCOMPtr<nsIDOMPopupBlockedEvent> popupEvent =
      do_QueryInterface (aDOMEvent);
    NS_ENSURE_TRUE (popupEvent, NS_ERROR_FAILURE);

    nsCOMPtr<nsIURI> popupWindowURI;
    popupEvent->GetPopupWindowURI (getter_AddRefs (popupWindowURI));

    nsCString popupWindowURIString;
    nsCString Host;
    nsresult rv;

    if (popupWindowURI) {
      rv = popupWindowURI->GetSpec (popupWindowURIString);
      NS_ENSURE_SUCCESS (rv, NS_ERROR_FAILURE);
      rv = popupWindowURI->GetHost (Host);
      NS_ENSURE_SUCCESS (rv, NS_ERROR_FAILURE);
    }

    nsString popupWindowFeatures;
    rv = popupEvent->GetPopupWindowFeatures (popupWindowFeatures);
    NS_ENSURE_SUCCESS (rv, NS_ERROR_FAILURE);

    nsCString popupWindowFeaturesString;
    popupWindowFeaturesString.Assign(NS_ConvertUTF16toUTF8(popupWindowFeatures).get());

    nsCString popupWindowNameString;
#ifdef HAVE_GECKO_1_9
    nsString popupWindowName;
    rv = popupEvent->GetPopupWindowName (popupWindowName);
    NS_ENSURE_SUCCESS (rv, NS_ERROR_FAILURE);

    NS_UTF16ToCString (popupWindowName,
                       NS_CSTRING_ENCODING_UTF8,
                       popupWindowNameString);
#endif
    g_signal_emit(GTK_OBJECT(mOwner->mOwningWidget),
                  moz_embed_signals[DOM_CONTENT_BLOCKED], 0,
                  (void *)popupWindowURIString.get(),(void*)Host.get());
    return NS_OK;
  }

  if (eventType.EqualsLiteral("DOMLinkAdded")) {

    nsresult rv;
    nsCOMPtr<nsIDOMEventTarget> eventTarget;

    aDOMEvent->GetTarget(getter_AddRefs(eventTarget));
    nsCOMPtr<nsIDOMNode> node = do_QueryInterface(eventTarget, &rv);
    if (NS_FAILED(rv) || !node)
      return NS_ERROR_FAILURE;
    HandleLink(node);
  } else if (eventType.EqualsLiteral("load")) {

    nsCOMPtr <nsIWebBrowser> webBrowser;
    gtk_moz_embed_get_nsIWebBrowser(mOwner->mOwningWidget, getter_AddRefs(webBrowser));
    if (!webBrowser) return NS_ERROR_FAILURE;

    nsCOMPtr<nsIDOMWindow> DOMWindow;
    webBrowser->GetContentDOMWindow(getter_AddRefs(DOMWindow));
    if (!DOMWindow) return NS_ERROR_FAILURE;

    nsCOMPtr<nsIDOMDocument> doc;
    DOMWindow->GetDocument(getter_AddRefs(doc));
    if (!doc) return NS_ERROR_FAILURE;

    nsCOMPtr<nsIDOMNodeList> nodelist = nsnull;

    PRUint32 length = 0;
    doc->GetElementsByTagName( NS_LITERAL_STRING( "rss" ), getter_AddRefs( nodelist ));
    if (nodelist)
      nodelist->GetLength(&length);
    if (!nodelist || length == 0) {
      doc->GetElementsByTagName( NS_LITERAL_STRING( "feed" ), getter_AddRefs( nodelist ));
      if (nodelist)
        nodelist->GetLength(&length);
    }
    if (!nodelist || length == 0) {
      doc->GetElementsByTagName( NS_LITERAL_STRING( "rdf:RDF" ), getter_AddRefs( nodelist ));
      if (nodelist)
        nodelist->GetLength(&length);
    }
    if (nodelist && length >= 1 || mXSLTransformed) {
        char *url = gtk_moz_embed_get_location(mOwner->mOwningWidget);
        char *title = gtk_moz_embed_get_title(mOwner->mOwningWidget);
        g_signal_emit(GTK_OBJECT(mOwner->mOwningWidget),
                      moz_embed_signals[RSS_REQUEST], 0,
                      (gchar*)url,
                      (gchar*)title);
        if (url)
          NS_Free(url);
        if (title)
          NS_Free(title);
        mXSLTransformed = PR_FALSE;
    }
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::KeyDown(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMKeyEvent> keyEvent;
  keyEvent = do_QueryInterface(aDOMEvent);
  if (!keyEvent)
    return NS_OK;
  // Return FALSE to this function to mark the event as not
  // consumed...
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                moz_embed_signals[DOM_KEY_DOWN], 0,
                (void *)keyEvent, &return_val);
  if (return_val) {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::KeyUp(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMKeyEvent> keyEvent;
  keyEvent = do_QueryInterface(aDOMEvent);
  if (!keyEvent)
    return NS_OK;
  // return FALSE to this function to mark this event as not
  // consumed...
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                moz_embed_signals[DOM_KEY_UP], 0,
                (void *)keyEvent, &return_val);
  if (return_val) {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::KeyPress(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMKeyEvent> keyEvent;
  keyEvent = do_QueryInterface(aDOMEvent);
  if (!keyEvent)
    return NS_OK;
  // Return TRUE from your signal handler to mark the event as consumed.
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                moz_embed_signals[DOM_KEY_PRESS], 0,
                (void *)keyEvent, &return_val);
  if (return_val) {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::MouseDown(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMMouseEvent> mouseEvent;
  mouseEvent = do_QueryInterface(aDOMEvent);
  if (!mouseEvent)
    return NS_OK;
  // Return TRUE from your signal handler to mark the event as consumed.
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                 moz_embed_signals[DOM_MOUSE_DOWN], 0,
                 (void *)mouseEvent, &return_val);

  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::MouseUp(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMMouseEvent> mouseEvent;
  mouseEvent = do_QueryInterface(aDOMEvent);
  if (!mouseEvent)
    return NS_OK;
  // Return TRUE from your signal handler to mark the event as consumed.
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                 moz_embed_signals[DOM_MOUSE_UP], 0,
                 (void *)mouseEvent, &return_val);
  if (return_val)
  {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::MouseClick(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMMouseEvent> mouseEvent;
  mouseEvent = do_QueryInterface(aDOMEvent);
  if (!mouseEvent)
    return NS_OK;
  // Return TRUE from your signal handler to mark the event as consumed.
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                moz_embed_signals[DOM_MOUSE_CLICK], 0,
                (void *)mouseEvent, &return_val);
  if (return_val) {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::MouseDblClick(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMMouseEvent> mouseEvent;
  mouseEvent = do_QueryInterface(aDOMEvent);
  if (!mouseEvent)
    return NS_OK;
  // Return TRUE from your signal handler to mark the event as consumed.
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                moz_embed_signals[DOM_MOUSE_DBL_CLICK], 0,
                (void *)mouseEvent, &return_val);
  if (return_val) {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::MouseOver(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMMouseEvent> mouseEvent;
  mouseEvent = do_QueryInterface(aDOMEvent);
  if (!mouseEvent)
    return NS_OK;

  // Return TRUE from your signal handler to mark the event as consumed.
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                moz_embed_signals[DOM_MOUSE_OVER], 0,
                (void *)mouseEvent, &return_val);
  if (return_val) {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::MouseOut(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMMouseEvent> mouseEvent;
  mouseEvent = do_QueryInterface(aDOMEvent);
  if (!mouseEvent)
    return NS_OK;
  // Return TRUE from your signal handler to mark the event as consumed.
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                moz_embed_signals[DOM_MOUSE_OUT], 0,
                (void *)mouseEvent, &return_val);
  if (return_val) {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::Activate(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMUIEvent> uiEvent = do_QueryInterface(aDOMEvent);
  if (!uiEvent)
    return NS_OK;
  // Return TRUE from your signal handler to mark the event as consumed.
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                moz_embed_signals[DOM_ACTIVATE], 0,
                (void *)uiEvent, &return_val);
  if (return_val) {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::FocusIn(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMUIEvent> uiEvent = do_QueryInterface(aDOMEvent);
  if (!uiEvent)
    return NS_OK;
  // Return TRUE from your signal handler to mark the event as consumed.
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                moz_embed_signals[DOM_FOCUS_IN], 0,
                (void *)uiEvent, &return_val);
  if (return_val) {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::FocusOut(nsIDOMEvent* aDOMEvent)
{
  nsCOMPtr <nsIDOMUIEvent> uiEvent = do_QueryInterface(aDOMEvent);
  if (!uiEvent)
    return NS_OK;
  // Return TRUE from your signal handler to mark the event as consumed.
  gint return_val = FALSE;
  g_signal_emit(G_OBJECT(mOwner->mOwningWidget),
                moz_embed_signals[DOM_FOCUS_OUT], 0,
                (void *)uiEvent, &return_val);
  if (return_val) {
    aDOMEvent->StopPropagation();
    aDOMEvent->PreventDefault();
  }
  return NS_OK;
}

NS_IMETHODIMP
EmbedEventListener::Focus(nsIDOMEvent* aEvent)
{
  nsString eventType;
  aEvent->GetType(eventType);

  if (eventType.EqualsLiteral("focus")) {
      gint return_val = FALSE;
      g_signal_emit(GTK_OBJECT(mOwner->mOwningWidget),
                    moz_embed_signals[DOM_FOCUS], 0, (void *)aEvent, &return_val);
      if (return_val) {
          aEvent->StopPropagation();
          aEvent->PreventDefault();
      }
  }

  return NS_OK;
}


NS_IMETHODIMP
EmbedEventListener::Blur(nsIDOMEvent* aEvent)
{
  mFocusInternalFrame = PR_FALSE;

  return NS_OK;
}

nsresult
EmbedEventListener::NewURI(nsIURI **result,
                            const char *spec)
{
  nsresult rv;
  nsCString cSpec(spec);
  nsCOMPtr<nsIIOService> ioService;
  rv = GetIOService(getter_AddRefs(ioService));
  if (NS_FAILED(rv))
    return rv;

  rv = ioService->NewURI(cSpec, nsnull, nsnull, result);
  return rv;
}

nsresult
EmbedEventListener::GetIOService(nsIIOService **ioService)
{
  nsresult rv;

  nsCOMPtr<nsIServiceManager> mgr;
  NS_GetServiceManager(getter_AddRefs(mgr));
  if (!mgr) return NS_ERROR_FAILURE;

  rv = mgr->GetServiceByContractID("@mozilla.org/network/io-service;1",
                                   NS_GET_IID(nsIIOService),
                                   (void **)ioService);
  return rv;
}
