/*
 * This file is part of functracer-postproc.
 *
 * Copyright (C) 2008 by Nokia Corporation
 * Copyright (C) 2008 Free Software Foundation, Inc.
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 * Based on backtrace code from BFD.
 */

#ifndef FTPRO_RESOLVE_H
#define FTPRO_RESOLVE_H

#include "maps.h"
#include "list.h"

#define TARGET "default"

extern char *cplus_demangle(const char *mangled, int options);

/* Copied from binutils/include/demangle.h */
#define DMGL_PARAMS  (1 << 0) /* Include function args */
#define DMGL_ANSI  (1 << 1)   /* Include const, volatile, etc */

typedef struct t_address_info {
	char filename[LINE_MAX];
	char function[LINE_MAX];
	int line;
} t_address_info;

t_map *find_map_entry_from_address(t_maplist *maplist,
	t_address address);

int resolve_address (t_map *map,
	t_address address,
	t_address_info *addr_info);

int is_absolute (char *pathname);

#endif /* FTPRO_RESOLVE_H */
