/*
 * This file is part of functracer-postproc.
 *
 * Copyright (C) 2008 by Nokia Corporation
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef FTPRO_LIST_H
#define FTPRO_LIST_H

#include "maps.h"

struct t_trace_file;

/* function type enumerator */
typedef enum {
	TYPE_FREE,
	TYPE_ALLOC,
	TYPE_INVALID
} t_function;

/* trace list node structure */
typedef struct t_line {
	char header[LINE_MAX];
	t_function type;
	t_address address;
	int size;
	int another_stack;
	int total_size;
	int blocks;

	long offset;

	struct t_line *next;
	struct t_line *prev;
} t_line;

/* trace list structure */
typedef struct t_list {
	struct t_line *first;
	struct t_line *last;
} t_list;

int list_add (t_list *list, t_line *line_info);
int list_remove_last (t_list *list);
void list_sort(struct t_trace_file *trace_data, int (*cmp)(struct t_trace_file *trace_data,
               struct t_line* item1, struct t_line* item2));
int list_init (t_list *list);
int list_print (struct t_trace_file *trace_data);
int list_free (t_list *list);
int list_filter (struct t_trace_file *trace_data) ;
int list_is_empty (t_list *list);

#endif /* FTPRO_LIST_H */
