/*
 * This file is part of control-plugin-example
 *
 * Copyright (C) 2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */  


#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

GtkWidget* init(GdkNativeWindow socket);
void shutdown(void);

GtkWidget* main_socket;
GtkWidget* label;

FILE *tmp;

GtkWidget* init(GdkNativeWindow socket)
{
    main_socket = gtk_plug_new(socket);
    label = gtk_label_new("Hello world!");
    printf("HELLO WORLD!\n");
    gtk_container_add(GTK_CONTAINER(main_socket), label);
    gtk_widget_show_all(main_socket);
    return main_socket;
}
void shutdown(void)
{
}

int main(int argc, char **argv)
{
    unsigned int socket;

    gtk_init (&argc, &argv);

    if (argc<2) {
        printf("Missing socket!\n");
        return 1;
    }

    socket = atoi(argv[1]);

    init((GdkNativeWindow)socket);

    gtk_main();

    return 0;
}
