#include <check.h>
#include "testing.h"
#include <glib-object.h>

#include "gwebtransferitem.h"
#include "stub_gwebtransferitem.h"

static GWebTransferItem* self;
static gboolean destroyed_flag;


static void destroy_notify(gpointer user_data, GObject* where_object_was)
{
	destroyed_flag = TRUE;
}

void setup_gwebtransferitem(void)
{
	g_type_init();
	self = G_WEB_TRANSFER_ITEM(stub_g_web_transfer_item_new());
	fail_if(self == NULL, "failed to create object");
	destroyed_flag = FALSE;
}

void teardown_gwebtransferitem(void)
{
	g_object_weak_ref(G_OBJECT(self), destroy_notify, NULL);

	g_object_unref(G_OBJECT(self));
	//run_main_loop(DEFAULT_MAIN_LOOP_RUN_TIME);

	//fail_unless(destroyed_flag, "failed to destroy object");

	self = NULL;
	destroyed_flag = FALSE;
}

START_TEST(test_g_web_transfer_item_destroy)
{
	g_web_transfer_item_destroy(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_start)
{
	g_web_transfer_item_start(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_stop)
{
	g_web_transfer_item_stop(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_continue)
{
	GWebStatus ret;

	ret = g_web_transfer_item_continue(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_cancel)
{
	g_web_transfer_item_cancel(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_reload)
{
	g_web_transfer_item_reload(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_get_web_item)
{
	GObject* ret;

	ret = g_web_transfer_item_get_web_item(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_get_url)
{
	gchar* ret;

	ret = g_web_transfer_item_get_url(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_get_filename)
{
	gchar* ret;

	ret = g_web_transfer_item_get_filename(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_get_total_size)
{
	glong ret;

	ret = g_web_transfer_item_get_total_size(self);
}
END_TEST

START_TEST(test_g_web_transfer_item_get_progress)
{
	glong ret;

	ret = g_web_transfer_item_get_progress(self);
}
END_TEST

Suite* create_gwebtransferitem_suite(void)
{
	Suite* s = suite_create("gwebtransferitem");

	TCase* tc = tcase_create("tests");
	tcase_add_checked_fixture(tc, setup_gwebtransferitem, teardown_gwebtransferitem);
	tcase_add_test(tc, test_g_web_transfer_item_destroy);
	tcase_add_test(tc, test_g_web_transfer_item_start);
	tcase_add_test(tc, test_g_web_transfer_item_stop);
	tcase_add_test(tc, test_g_web_transfer_item_continue);
	tcase_add_test(tc, test_g_web_transfer_item_cancel);
	tcase_add_test(tc, test_g_web_transfer_item_reload);
	tcase_add_test(tc, test_g_web_transfer_item_get_web_item);
	tcase_add_test(tc, test_g_web_transfer_item_get_url);
	tcase_add_test(tc, test_g_web_transfer_item_get_filename);
	tcase_add_test(tc, test_g_web_transfer_item_get_total_size);
	tcase_add_test(tc, test_g_web_transfer_item_get_progress);
	suite_add_tcase(s, tc);

	return s;
}
