#include <check.h>
#include "testing.h"
#include <glib-object.h>

#include "gwebengine.h"
#include "stub_gwebengine.h"

static GWebEngine* self;
static gboolean destroyed_flag;


static void destroy_notify(gpointer user_data, GObject* where_object_was)
{
	destroyed_flag = TRUE;
}

void setup_gwebengine(void)
{
	g_type_init();
	self = G_WEB_ENGINE(stub_g_web_engine_new());
	fail_if(self == NULL, "failed to create object");
	destroyed_flag = FALSE;
}

void teardown_gwebengine(void)
{
	g_object_weak_ref(G_OBJECT(self), destroy_notify, NULL);

	g_object_unref(G_OBJECT(self));
	//run_main_loop(DEFAULT_MAIN_LOOP_RUN_TIME);

	//fail_unless(destroyed_flag, "failed to destroy object");

	self = NULL;
	destroyed_flag = FALSE;
}

START_TEST(test_g_web_engine_destroy)
{
	g_web_engine_destroy(self);
}
END_TEST

START_TEST(test_g_web_engine_load_url)
{
	const char* url = NULL;

	g_web_engine_load_url(self, url);
}
END_TEST

START_TEST(test_g_web_engine_load_follow_link)
{
	GWebStatus ret;
	const char* url = NULL;

	ret = g_web_engine_load_follow_link(self, url);
}
END_TEST

START_TEST(test_g_web_engine_load_url_with_css)
{
	GWebStatus ret;
	const gchar* url = NULL;
	const gchar* cssfile = NULL;

	ret = g_web_engine_load_url_with_css(self, url, cssfile);
}
END_TEST

START_TEST(test_g_web_engine_load_url_with_js)
{
	gboolean enable = FALSE;

	g_web_engine_load_url_with_js(self, enable);
}
END_TEST

START_TEST(test_g_web_engine_load_home_page)
{
	g_web_engine_load_home_page(self);
}
END_TEST

START_TEST(test_g_web_engine_stop_load)
{
	g_web_engine_stop_load(self);
}
END_TEST

START_TEST(test_g_web_engine_reload)
{
	g_web_engine_reload(self);
}
END_TEST

START_TEST(test_g_web_engine_go_back)
{
	guint nsteps = 0;

	g_web_engine_go_back(self, nsteps);
}
END_TEST

START_TEST(test_g_web_engine_go_forward)
{
	guint nsteps = 0;

	g_web_engine_go_forward(self, nsteps);
}
END_TEST

START_TEST(test_g_web_engine_can_go_back)
{
	gboolean ret;

	ret = g_web_engine_can_go_back(self);
}
END_TEST

START_TEST(test_g_web_engine_can_go_forward)
{
	gboolean ret;

	ret = g_web_engine_can_go_forward(self);
}
END_TEST

START_TEST(test_g_web_engine_zoom_by_steps)
{
	guint relative_zoom, legal_zoom_value;

	relative_zoom = 0;
	legal_zoom_value = 0;

	g_web_engine_zoom_by_steps(self, relative_zoom, &legal_zoom_value);
}
END_TEST

START_TEST(test_g_web_engine_new_zoom_by_steps)
{
	gboolean up = FALSE;
	guint legal_zoom_value;

	g_web_engine_new_zoom_by_steps(self, up, &legal_zoom_value);
}
END_TEST

START_TEST(test_g_web_engine_set_zoom_level)
{
	gint level = 0;

	g_web_engine_set_zoom_level(self, level);
}
END_TEST

START_TEST(test_g_web_engine_set_zoom_level_around_point)
{
	GWebStatus ret;
	guint x, y;
	gint level;

	x = 0;
	y = 0;
	level = 0;

	ret = g_web_engine_set_zoom_level_around_point(self, x, y, level);
}
END_TEST

START_TEST(test_g_web_engine_compare_frames_zoom_level)
{
	GWebStatus ret;
	gboolean result;

	ret = g_web_engine_compare_frames_zoom_level(self, &result);
}
END_TEST

START_TEST(test_g_web_engine_get_image_properties)
{
	GWebStatus ret;
	const gchar* url = NULL;
	gchar* file_type;
	guint file_size, width, height;

	ret = g_web_engine_get_image_properties(self, url, &file_type, &file_size, &width, &height);
}
END_TEST

START_TEST(test_g_web_engine_get_frame_properties)
{
	GWebStatus ret;
	gchar* file_type;
	guint file_size;
	GWebEngineEncoding file_encoding;
	guint security;
	gboolean automatic_encoding;

	ret = g_web_engine_get_frame_properties(
			self,
			&file_type,
			&file_size,
			&file_encoding,
			&security,
			&automatic_encoding);
}
END_TEST

START_TEST(test_g_web_engine_load_image)
{
	GWebStatus ret;
	const gchar* url = NULL;

	ret = g_web_engine_load_image(self, url);
}
END_TEST

START_TEST(test_g_web_engine_get_back_window_history_list)
{
	gint ret;
	GWebHistoryList* result;

	ret = g_web_engine_get_back_window_history_list(self, &result);
}
END_TEST

START_TEST(test_g_web_engine_get_forward_window_history_list)
{
	gint ret;
	GWebHistoryList* result;

	ret = g_web_engine_get_forward_window_history_list(self, &result);
}
END_TEST

START_TEST(test_g_web_engine_get_zoom_level)
{
	guint ret;

	ret = g_web_engine_get_zoom_level(self);
}
END_TEST

START_TEST(test_g_web_engine_set_frame_zoom_level)
{
	guint level = 0;

	g_web_engine_set_frame_zoom_level(self, level);
}
END_TEST

START_TEST(test_g_web_engine_get_frame_zoom_level)
{
	guint ret;

	ret = g_web_engine_get_frame_zoom_level(self);
}
END_TEST

START_TEST(test_g_web_engine_set_layout_mode)
{
	GWebEngineLayoutMode mode = G_WEBENGINE_LAYOUT_NORMAL;

	g_web_engine_set_layout_mode(self, mode);
}
END_TEST

START_TEST(test_g_web_engine_get_layout_mode)
{
	GWebEngineLayoutMode ret;

	ret = g_web_engine_get_layout_mode(self);
}
END_TEST

START_TEST(test_g_web_engine_set_load_images)
{
	GWebEngineImagePolicy level = G_WEBENGINE_POLICY_ALL_IMAGES;

	g_web_engine_set_load_images(self, level);
}
END_TEST

START_TEST(test_g_web_engine_get_load_images)
{
	GWebEngineImagePolicy ret;

	ret = g_web_engine_get_load_images(self);
}
END_TEST

START_TEST(test_g_web_engine_set_frame_stacking)
{
	gboolean enabled = FALSE;

	g_web_engine_set_frame_stacking(self, enabled);
}
END_TEST

START_TEST(test_g_web_engine_get_frame_stacking)
{
	gboolean ret;

	ret = g_web_engine_get_frame_stacking(self);
}
END_TEST

START_TEST(test_g_web_engine_save_web_page)
{
	GWebStatus ret;
	GWebEngineSaveAction setting = G_WEBENGINE_SAVE_NO_INLINES;
	const gchar* path = NULL;

	ret = g_web_engine_save_web_page(self, setting, path);
}
END_TEST

START_TEST(test_g_web_engine_save_current_frame)
{
	GWebStatus ret;
	GWebEngineSaveAction setting = G_WEBENGINE_SAVE_NO_INLINES;
	const char* path = NULL;

	ret = g_web_engine_save_current_frame(self, setting, path);
}
END_TEST

START_TEST(test_g_web_engine_get_frame_title)
{
	gchar* ret;
	gint num = 0;

	ret = g_web_engine_get_frame_title(self, num);
}
END_TEST

START_TEST(test_g_web_engine_get_element_details)
{
	gchar* ret;
	gint type = 0;

	ret = g_web_engine_get_element_details(self, type);
}
END_TEST

START_TEST(test_g_web_engine_get_frame_number)
{
	gint ret;

	ret = g_web_engine_get_frame_number(self);
}
END_TEST

START_TEST(test_g_web_engine_save_web_page_image)
{
	GWebStatus ret;
	const gchar* url = NULL;
	const gchar* dir = NULL;

	ret = g_web_engine_save_web_page_image(self, url, dir);
}
END_TEST

START_TEST(test_g_web_engine_select_all_text)
{
	g_web_engine_select_all_text(self);
}
END_TEST

START_TEST(test_g_web_engine_set_language_encoding)
{
	GWebEngineEncoding enc = G_WEBENGINE_ENCODING_AUTOMATIC;

	g_web_engine_set_language_encoding(self, enc);
}
END_TEST

START_TEST(test_g_web_engine_set_frame_encoding)
{
	GWebEngineEncoding enc = G_WEBENGINE_ENCODING_AUTOMATIC;

	g_web_engine_set_frame_encoding(self, enc);
}
END_TEST

START_TEST(test_g_web_engine_find_text)
{
	gboolean ret, reverse, whole_word, case_sensitive, restart;
	const gchar* string = NULL;

	reverse = FALSE;
	whole_word = FALSE;
	case_sensitive = FALSE;
	restart = FALSE;

	ret = g_web_engine_find_text(
			self,
			string,
			reverse,
			whole_word,
			case_sensitive,
			restart);
}
END_TEST

START_TEST(test_g_web_engine_authenticate)
{
	gboolean ok = FALSE;
	const gchar* username = NULL;
	const gchar* password = NULL;

	g_web_engine_authenticate(self, ok, username, password);
}
END_TEST

START_TEST(test_g_web_engine_cut)
{
	GWebStatus ret;

	ret = g_web_engine_cut(self);
}
END_TEST

START_TEST(test_g_web_engine_copy)
{
	GWebStatus ret;

	ret = g_web_engine_copy(self);
}
END_TEST

START_TEST(test_g_web_engine_paste)
{
	GWebStatus ret;

	ret = g_web_engine_paste(self);
}
END_TEST

START_TEST(test_g_web_engine_can_cut)
{
	gboolean ret;

	ret = g_web_engine_can_cut(self);
}
END_TEST

START_TEST(test_g_web_engine_can_paste)
{
	gboolean ret;

	ret = g_web_engine_can_paste(self);
}
END_TEST

START_TEST(test_g_web_engine_can_copy)
{
	gboolean ret;

	ret = g_web_engine_can_copy(self);
}
END_TEST

START_TEST(test_g_web_engine_can_selecttext)
{
	gboolean ret;

	ret = g_web_engine_can_selecttext(self);
}
END_TEST

START_TEST(test_g_web_engine_get_favicon_name)
{
	gchar* ret;
	const gchar* folder = NULL;

	ret = g_web_engine_get_favicon_name(self, folder);
}
END_TEST

START_TEST(test_g_web_engine_get_engine_widget)
{
	GObject* ret;

	ret = g_web_engine_get_engine_widget(self);
}
END_TEST

START_TEST(test_g_web_engine_get_engine_notifier)
{
	GObject* ret;

	ret = g_web_engine_get_engine_notifier(self);
}
END_TEST

START_TEST(test_g_web_engine_set_open_link_mode)
{
	gboolean in_new_window = FALSE;

	g_web_engine_set_open_link_mode(self, in_new_window);
}
END_TEST

START_TEST(test_g_web_engine_set_true_zoom_mode)
{
	GWebStatus ret;
	gboolean status = FALSE;

	ret = g_web_engine_set_true_zoom_mode(self, status);
}
END_TEST

START_TEST(test_g_web_engine_notify_plugins)
{
	gint event = 0;

	g_web_engine_notify_plugins(self, event);
}
END_TEST

START_TEST(test_g_web_engine_preload_current_skin)
{
	g_web_engine_preload_current_skin(self);
}
END_TEST

START_TEST(test_g_web_engine_invoke_selectmatch)
{
	g_web_engine_invoke_selectmatch(self);
}
END_TEST

START_TEST(test_g_web_engine_get_server_certificate)
{
	GArray* ret;
	gpointer context = NULL;

	ret = g_web_engine_get_server_certificate(self, context);
}
END_TEST

START_TEST(test_g_web_engine_get_page_verifier_name)
{
	gchar* ret;

	ret = g_web_engine_get_page_verifier_name(self);
}
END_TEST

START_TEST(test_g_web_engine_permit_page_unload)
{
	gboolean ret;
	glong time_sec, time_usec, timeout_usec;
	guint id;

	time_sec = 0;
	time_usec = 0;
	timeout_usec = 0;

	ret = g_web_engine_permit_page_unload(self, time_sec, time_usec, timeout_usec, &id);
}
END_TEST

START_TEST(test_g_web_engine_get_thumbnail)
{
	gboolean ret;
	const gchar* fname = NULL;
	gint width = 0;
	gint height = 0;

	ret = g_web_engine_get_thumbnail(self, fname, width, height);
}
END_TEST

START_TEST(test_g_web_engine_get_text_zoom_level)
{
	gint ret;

	ret = g_web_engine_get_text_zoom_level(self);
}
END_TEST

START_TEST(test_g_web_engine_set_text_zoom_level)
{
	gint level = 0;

	g_web_engine_set_text_zoom_level(self, level);
}
END_TEST

START_TEST(test_g_web_engine_enable_shistory_thumbnails)
{
	gboolean enable = FALSE;
	gint width, height;

	width = 0;
	height = 0;

	g_web_engine_enable_shistory_thumbnails(self, enable, width, height);
}
END_TEST

START_TEST(test_g_web_engine_update_area)
{
	int id, top, left, width, height, zoom;

	id = 0;
	top = 0;
	left = 0;
	width = 0;
	height = 0;
	zoom = 0;

	g_web_engine_update_area(self, id, top, left, width, height, zoom);
}
END_TEST

START_TEST(test_g_web_engine_send_mouse_event)
{
	int type, x, y, mod, button, clicks, time;

	type = 0;
	x = 0;
	y = 0;
	mod = 0;
	button = 0;
	clicks = 0;
	time = 0;

	g_web_engine_send_mouse_event(self, type, x, y, mod, button, clicks, time);
}
END_TEST

Suite* create_gwebengine_suite(void)
{
	Suite* s = suite_create("gwebengine");

	TCase* tc = tcase_create("tests");
	tcase_add_checked_fixture(tc, setup_gwebengine, teardown_gwebengine);
	tcase_add_test(tc, test_g_web_engine_destroy);
	tcase_add_test(tc, test_g_web_engine_load_url);
	tcase_add_test(tc, test_g_web_engine_load_follow_link);
	tcase_add_test(tc, test_g_web_engine_load_url_with_css);
	tcase_add_test(tc, test_g_web_engine_load_url_with_js);
	tcase_add_test(tc, test_g_web_engine_load_home_page);
	tcase_add_test(tc, test_g_web_engine_stop_load);
	tcase_add_test(tc, test_g_web_engine_reload);
	tcase_add_test(tc, test_g_web_engine_go_back);
	tcase_add_test(tc, test_g_web_engine_go_forward);
	tcase_add_test(tc, test_g_web_engine_can_go_back);
	tcase_add_test(tc, test_g_web_engine_can_go_forward);
	tcase_add_test(tc, test_g_web_engine_zoom_by_steps);
	tcase_add_test(tc, test_g_web_engine_new_zoom_by_steps);
	tcase_add_test(tc, test_g_web_engine_set_zoom_level);
	tcase_add_test(tc, test_g_web_engine_set_zoom_level_around_point);
	tcase_add_test(tc, test_g_web_engine_compare_frames_zoom_level);
	tcase_add_test(tc, test_g_web_engine_get_image_properties);
	tcase_add_test(tc, test_g_web_engine_get_frame_properties);
	tcase_add_test(tc, test_g_web_engine_load_image);
	tcase_add_test(tc, test_g_web_engine_get_back_window_history_list);
	tcase_add_test(tc, test_g_web_engine_get_forward_window_history_list);
	tcase_add_test(tc, test_g_web_engine_get_zoom_level);
	tcase_add_test(tc, test_g_web_engine_set_frame_zoom_level);
	tcase_add_test(tc, test_g_web_engine_get_frame_zoom_level);
	tcase_add_test(tc, test_g_web_engine_set_layout_mode);
	tcase_add_test(tc, test_g_web_engine_get_layout_mode);
	tcase_add_test(tc, test_g_web_engine_set_load_images);
	tcase_add_test(tc, test_g_web_engine_get_load_images);
	tcase_add_test(tc, test_g_web_engine_set_frame_stacking);
	tcase_add_test(tc, test_g_web_engine_get_frame_stacking);
	tcase_add_test(tc, test_g_web_engine_save_web_page);
	tcase_add_test(tc, test_g_web_engine_save_current_frame);
	tcase_add_test(tc, test_g_web_engine_get_frame_title);
	tcase_add_test(tc, test_g_web_engine_get_element_details);
	tcase_add_test(tc, test_g_web_engine_get_frame_number);
	tcase_add_test(tc, test_g_web_engine_save_web_page_image);
	tcase_add_test(tc, test_g_web_engine_select_all_text);
	tcase_add_test(tc, test_g_web_engine_set_language_encoding);
	tcase_add_test(tc, test_g_web_engine_set_frame_encoding);
	tcase_add_test(tc, test_g_web_engine_find_text);
	tcase_add_test(tc, test_g_web_engine_authenticate);
	tcase_add_test(tc, test_g_web_engine_cut);
	tcase_add_test(tc, test_g_web_engine_copy);
	tcase_add_test(tc, test_g_web_engine_paste);
	tcase_add_test(tc, test_g_web_engine_can_cut);
	tcase_add_test(tc, test_g_web_engine_can_paste);
	tcase_add_test(tc, test_g_web_engine_can_copy);
	tcase_add_test(tc, test_g_web_engine_can_selecttext);
	tcase_add_test(tc, test_g_web_engine_get_favicon_name);
	tcase_add_test(tc, test_g_web_engine_get_engine_widget);
	tcase_add_test(tc, test_g_web_engine_get_engine_notifier);
	tcase_add_test(tc, test_g_web_engine_set_open_link_mode);
	tcase_add_test(tc, test_g_web_engine_set_true_zoom_mode);
	tcase_add_test(tc, test_g_web_engine_notify_plugins);
	tcase_add_test(tc, test_g_web_engine_preload_current_skin);
	tcase_add_test(tc, test_g_web_engine_invoke_selectmatch);
	tcase_add_test(tc, test_g_web_engine_get_server_certificate);
	tcase_add_test(tc, test_g_web_engine_get_page_verifier_name);
	tcase_add_test(tc, test_g_web_engine_permit_page_unload);
	tcase_add_test(tc, test_g_web_engine_get_thumbnail);
	tcase_add_test(tc, test_g_web_engine_get_text_zoom_level);
	tcase_add_test(tc, test_g_web_engine_set_text_zoom_level);
	tcase_add_test(tc, test_g_web_engine_enable_shistory_thumbnails);
	tcase_add_test(tc, test_g_web_engine_update_area);
	tcase_add_test(tc, test_g_web_engine_send_mouse_event);
	suite_add_tcase(s, tc);

	return s;
}
