#include <check.h>
#include "testing.h"
#include <glib-object.h>

#include "gwebbus.h"

static GWebBus* self;


static void callback(guint msgid,
		gpointer data,
		guint len,
		gpointer userdata)
{
}

void setup_gwebbus(void)
{
	g_type_init();

	self = g_web_bus_new("server");
	fail_if(self == NULL, "failed to create bus");
}

void teardown_gwebbus(void)
{
	g_object_unref(self);
}

START_TEST(test_g_web_bus_register_callback)
{
	gboolean ret, isreg;
	guint msgid;

	msgid = 0;

	ret = g_web_bus_register_callback(self, msgid, callback, NULL);
	isreg = g_web_bus_is_registered(self, msgid);

	fail_unless(ret, "function returned false");
	fail_unless(isreg, "callback is not registered");
}
END_TEST

START_TEST(test_g_web_bus_is_registered)
{
	gboolean ret;
	guint msgid;

	msgid = 0;

	ret = g_web_bus_is_registered(self, msgid);
	fail_if(ret, "callback is already registered");
}
END_TEST

START_TEST(test_g_web_bus_send_message)
{
	gboolean ret;
	guint msgid, len;
	const gchar* name = NULL;
	const gpointer data = NULL;

	msgid = 0;
	len = 0;

	ret = g_web_bus_send_message(self, name, msgid, data, len);

	fail_if(ret, "function returned true with NULL values");
}
END_TEST

START_TEST(test_g_web_bus_update_channel)
{
	gboolean ret;

	ret = g_web_bus_update_channel(self);

	fail_unless(ret, "function returned false");
}
END_TEST


Suite* create_gwebbus_suite(void)
{
	Suite* s = suite_create("gwebbus");

	TCase* tc = tcase_create("tests");
	tcase_add_checked_fixture(tc, setup_gwebbus, teardown_gwebbus);
	tcase_add_test(tc, test_g_web_bus_register_callback);
	tcase_add_test(tc, test_g_web_bus_is_registered);
	tcase_add_test(tc, test_g_web_bus_send_message);
	tcase_add_test(tc, test_g_web_bus_update_channel);
	suite_add_tcase(s, tc);

	return s;
}
