#ifndef _XSP_H_
#define _XSP_H_

#include <X11/Xfuncproto.h>
#include <X11/Xlib.h>

typedef struct {
    int type;			/* event base */
    unsigned long serial;
    Bool send_event;
    Display *display;
    int x;
    int y;
    int pressure;
} XSPRawTouchscreenEvent;

typedef struct {
    int type;			/* event base */
    unsigned long serial;
    Bool send_event;
    Display *display;
} XSPDSPStoppedEvent;


_XFUNCPROTOBEGIN

Bool XSPQueryExtension(
    Display* dpy,
    int* event_basep,
    int* error_basep,
    int* majorp,
    int* minorp
);


Status XSPSetTSRawMode(Display *dpy, Bool enable);
Status XSPSetTSCalibration(Display *dpy, 
			int calconst1,
			int calconst2,
			int calconst3,
			int calconst4,
			int calconst5,
			int calconst6,
			int calconst7);

Status XSPRegisterDSPArea(Display *dpy, int screen_num, int x, int y, int width, int height);
Status XSPCancelDSPArea(Display *dpy, int screen_num);

Status XSPSetPixelDoubling(Display *dpy, int screen_num, int state);

_XFUNCPROTOEND


#endif
