#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "omap.h"

#include <fbdev.h>
#include <scrnintstr.h>
#include <sys/io.h>


static Bool omapCardInit(KdCardInfo *card)
{
    ENTER();
    OmapCardInfo *omapc;

    omapc = (OmapCardInfo *)xalloc(sizeof(OmapCardInfo));
    if (!omapc) return FALSE;
    if (!fbdevInitialize(card, &omapc->backend_priv.fbdev)) {
        xfree(omapc);
        return FALSE;
    }
    card->driver = omapc;
    LEAVE();
    return TRUE;
}


static Bool omapScreenInit(KdScreenInfo *screen)
{
    ENTER();
    OmapScreenInfo *omaps;

    omaps = (OmapScreenInfo *)xalloc(sizeof(OmapScreenInfo));

    if (!omaps) return FALSE;

    memset(omaps, '\0', sizeof(OmapScreenInfo));

    omaps->omapc = screen->card->driver;
    omaps->screen = screen;
    screen->driver = omaps;	
    screen->softCursor = FALSE;

    if (screen->fb[0].depth == 0) screen->fb[0].depth = 16;

    if(!fbdevScreenInitialize(screen, &omaps->backend_priv.fbdev)) {
        DBGOUT("fbdevScreenInitialize failed");
        screen->driver = NULL;
        xfree(omaps);
        return FALSE;
    }

    LEAVE();
    return TRUE;
}

static Bool omapInitScreen(ScreenPtr pScreen)
{
    ENTER();
    LEAVE();
    return fbdevInitScreen(pScreen);
}

static Bool omapFinishInitScreen(ScreenPtr pScreen)
{
    ENTER();
    LEAVE();
    return fbdevFinishInitScreen(pScreen);
}

static Bool omapCreateResources(ScreenPtr pScreen)
{
    ENTER();
    LEAVE();
    return fbdevCreateResources(pScreen);
}

static void omapPreserve(KdCardInfo *card)
{
    ENTER();
    LEAVE();
    fbdevPreserve(card);
}

static Bool omapDPMS(ScreenPtr pScreen, int mode)
{
    ENTER();
    LEAVE();
    return TRUE;
}

static Bool omapEnable(ScreenPtr pScreen)
{
    ENTER();
    LEAVE();
    return fbdevEnable(pScreen);
}

static void omapDisable(ScreenPtr pScreen)
{
    ENTER();
    LEAVE();
    fbdevDisable(pScreen);
}

static void omapRestore(KdCardInfo *card)
{
    ENTER();
    fbdevRestore(card);
    LEAVE();
}

static void omapScreenFini(KdScreenInfo *screen)
{
    ENTER();
    OmapScreenInfo *omaps = (OmapScreenInfo *)screen->driver;

    fbdevScreenFini(screen);
    xfree(omaps);
    screen->driver = 0;
    LEAVE();
}

static void omapCardFini(KdCardInfo *card)
{
    ENTER();
    fbdevCardFini(card);
    LEAVE();
}


KdCardFuncs omapFuncs = {
    omapCardInit,
    omapScreenInit,
    omapInitScreen,
    omapFinishInitScreen,
    omapCreateResources,
    omapPreserve,
    omapEnable,
    omapDPMS,
    omapDisable,
    omapRestore,
    omapScreenFini,
    omapCardFini,

    NULL,			/* initCursor */
    NULL,			/* enableCursor */
    NULL,			/* disableCursor */
    NULL,			/* finiCursor */
    NULL,			/* recolorCursor */

    omapDrawInit,           /* initAccel */
    omapDrawEnable,         /* enableAccel */
    omapDrawSync,           /* syncAccel */
    omapDrawDisable,        /* disableAccel */
    omapDrawFini,           /* finiAccel */

    fbdevGetColors,         /* getColors */
    fbdevPutColors         /* putColors */
};
