/**
   X Colorkey eXtension

   Authors:
   Tapani Paelli <tapani.palli@nokia.com>

*/

/*
 *   modified from fb routines, Copyright  1998 Keith Packard
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "xck.h"

/*
  xckEvenTile
*/
void
xckEvenTile (FbBits	*dst,
	     int	dstStride,
	     int	dstX,
	     
	     int	width,
	     int	height,
	     
	     FbBits	*tile,
	     int        tileStride,
	     int        tileWidth,
	     int	tileHeight,
	     
	     int	alu,
	     FbBits	pm,
	     int	xRot,
	     int	yRot,
	     int        ckey,
	     XCK_data   pdata
)
{
    FbBits  *t, *tileEnd, bits;
    FbBits  startmask, endmask;
    int	    n, nmiddle;
    int	    tileX, tileY;
    int	    rot;
    int	    startbyte, endbyte;

    dst += dstX >> FB_SHIFT;
    dstX &= FB_MASK;
    FbMaskBitsBytes(dstX, width, FbDestInvarientRop(alu, pm),
		    startmask, startbyte, nmiddle, endmask, endbyte);
    if (startmask)
	dstStride--;
    dstStride -= nmiddle;

    /*
     * Compute tile start scanline and rotation parameters
     */

    tileEnd = tile + tileHeight;
    modulus (- yRot, tileHeight, tileY);
    t = tile + tileY;
    modulus (- xRot, FB_UNIT, tileX);
    rot = tileX;

    unsigned int *pos_table = pdata->position_map;
    unsigned int *pos_start = pos_table;
    unsigned int yop = 0;
    unsigned int p1,byteamount,line_width;

    while (height--)
    {
      /*
       * Pick up bits for this scanline
       */

      CARD16*start = (CARD16*) t;

      bits = *t++;

      if (t == tileEnd)
      {
	t = tile;
	yop=1;
      }

      if (startmask)
      {
	//	FbDoLeftMaskByteRRop(dst, startbyte, startmask, and, xor);
	dst++;
      }

      n = nmiddle;

      p1 = *pos_table; pos_table++;
      byteamount = *pos_table; pos_table++;

	if (byteamount > 0)
	{
	  byteamount*=2;

	  while (n--)
	  {
	    CARD16*srcp = start;
	    CARD16*dstp = (CARD16*) dst;

	    line_width = tileWidth;
	    line_width>>=4;

	    srcp += p1;
	    dstp += p1;
	    memcpy(dstp,srcp,byteamount);

	    dst++;
	  }
	}

	else
	{
	  while (n--)
	    dst++;
	}

	if (yop == 1)
	{
	  pos_table = pos_start;
	  yop=0;
	}

      /*
      if (endmask)
	FbDoRightMaskByteRRop(dst, endbyte, endmask, and, xor);
      */

      // next scanline please.
      dst += dstStride;

    }

}

/**
   tiles an area using optimizing table information
   copying is here instead of using xckblt
   (drops a few function calls)

   @TODO if dstX is less than zero, colorkeying bugs.
         actually we will never have less than zero
	 here even if it occurs. we should pass the
	 window offset as a parameter here ...

*/
void
xckOddTile(FbBits    *dst,
	   int      dstStride,
	   int	    dstX,
	   
	   int	    width,
	   int	    height,
	   
	   FbBits    *tile,
	   int      tileStride,
	   int	    tileWidth,
	   int	    tileHeight,
	   
	   int	    alu,
	   FbBits    pm,
	   int	    bpp,
	   
	   int	    xRot,
	   int	    yRot,
	   int      ckey,
	   XCK_data pdata
)
{

  int	    tileX, tileY;
  int	    widthTmp;
  int	    h, w;
  int	    x, y;

  int y_offsets,yy;
  int p1, byteamount;

  unsigned int *pos_table = pdata->position_map;
  unsigned int *pos_start = pos_table;

  pos_start += pdata->u_offset*2;
  y_offsets = pdata->u_offset + pdata->d_offset;

  modulus (- yRot, tileHeight, tileY);
  y = 0;

  int dstXoff;

  while (height)
  {
    h = tileHeight - tileY;
    if (h > height)
      h = height;
    height -= h;
    widthTmp = width;
    x = dstX;
    modulus (dstX - xRot, tileWidth, tileX);

    dstXoff = dstX - xRot;
    dstXoff>>=4;

    /* offsets */
    h -= y_offsets;
    y += y_offsets;

    /* tileY += pdata->u_offset; */

    if (h<0) h = 0;

    CARD16 *isrc= (CARD16*) (tile + tileY * tileStride);

    unsigned int sstride = tileStride * sizeof (CARD16);
    unsigned int dstride = dstStride * sizeof (CARD16);

    while (widthTmp)
    {
      w = tileWidth - tileX;
      if (w > widthTmp)
	w = widthTmp;
      widthTmp -= w;

      CARD16 *idst= (CARD16*) (dst + y * dstStride);

      int line_width = w;

      line_width>>=4;
      //isrc += (tileX>>4); /* move tile pointer, x offset */
      idst += (x>>4);

      CARD16 *srcp = isrc;
      CARD16 *dstp = idst;

      pos_table = pos_start;

      /* offset in y, pos_table has 2 integers per scanline */
      pos_table += tileY*2;

      /* for each scanline */
      for(yy=0; yy<h; yy++)
      {
	/* read position and amount of bytes */
	p1 = *pos_table; pos_table++;
	byteamount = *pos_table; pos_table++;

	// pointers to right rows...
	srcp = isrc+yy*sstride;
	dstp = idst+yy*dstride;

	// move source by x offset
	srcp += (tileX>>4);

	// move position to tileX if smaller
	if (p1 < (tileX>>4))
	{
	  byteamount -= (((tileX>>4)-p1) + (tileX>>4));
	  p1 = (tileX>>4);
	}

	else
	  p1 -= (tileX>>4);

	/* clipping in x */
	while (p1+byteamount > line_width)
	  byteamount--;

	/* any bytes to copy? */
	if (byteamount > 0)
	{
	  /* move pointers by position information */
	  srcp += p1;
	  dstp += p1;

	  byteamount*=2;
	  memcpy(dstp,srcp,byteamount);
	}
      }
      x += w;
      tileX = 0;
    }
    y += h;
    tileY = 0;
  }
}


void
xckTile (FbBits	    *dst,
	 int        dstStride,
	 int	    dstX,
	 
	 int	    width,
	 int	    height,
	 
	 FbBits	    *tile,
	 int        tileStride,
	 int	    tileWidth,
	 int	    tileHeight,
	 
	 int	    alu,
	 FbBits	    pm,
	 int	    bpp,
	 
	 int	    xRot,
	 int	    yRot,
	 
	 int        ckey,
	 XCK_data pdata
	 )
{

    if (FbEvenTile (tileWidth))
	xckEvenTile (dst, dstStride, dstX, width, height, 
		    tile, tileStride, tileWidth, tileHeight,
		    alu, pm, xRot, yRot, ckey, pdata);
    else
	xckOddTile (dst, dstStride, dstX, width, height, 
		   tile, tileStride, tileWidth, tileHeight,
		   alu, pm, bpp, xRot, yRot, ckey, pdata);
}
