/**
   X Colorkey eXtension

   Authors:
   Tapani Paelli <tapani.palli@nokia.com>
*/

/*
 *
 * modified from fb routines, Copyright  1998 Keith Packard
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "xck.h"

void
xckFill (DrawablePtr pDrawable,
	GCPtr	    pGC,
	int	    x,
	int	    y,
	int	    width,
	int	    height)
{
    FbBits	    *dst;
    int	            dstStride;
    int		    dstBpp;
    int		    dstXoff, dstYoff;
    FbGCPrivPtr	    pPriv = fbGetGCPrivate(pGC);
    fbGetDrawable (pDrawable, dst, dstStride, dstBpp, dstXoff, dstYoff);

    switch (pGC->fillStyle) {
    case FillSolid:
	fbSolid (dst + (y + dstYoff) * dstStride, 
		 dstStride, 
		 (x + dstXoff) * dstBpp,
		 dstBpp,
		 width * dstBpp, height,
		 pPriv->and, pPriv->xor);
	break;
    case FillStippled:
    case FillOpaqueStippled: {
	PixmapPtr   pStip = pGC->stipple;
	int	    stipWidth = pStip->drawable.width;
	int	    stipHeight = pStip->drawable.height;
	
	if (dstBpp == 1)
	{
	    int		alu;
	    FbBits	*stip;
	    int         stipStride;
	    int		stipBpp;
	    int		stipXoff, stipYoff; /* XXX assumed to be zero */

	    if (pGC->fillStyle == FillStippled)
		alu = FbStipple1Rop(pGC->alu,pGC->fgPixel);
	    else
		alu = FbOpaqueStipple1Rop(pGC->alu,pGC->fgPixel,pGC->bgPixel);
	    fbGetDrawable (&pStip->drawable, stip, stipStride, stipBpp, stipXoff, stipYoff);
	    fbTile (dst + (y + dstYoff) * dstStride,
		    dstStride,
		    x + dstXoff,
		    width, height,
		    stip,
		    stipStride,
		    stipWidth,
		    stipHeight,
		    alu,
		    pPriv->pm,
		    dstBpp,
		    
		    (pGC->patOrg.x + pDrawable->x + dstXoff),
		    pGC->patOrg.y + pDrawable->y - y);
	}
	else
	{
	    FbStip	*stip;
	    int         stipStride;
	    int		stipBpp;
	    int		stipXoff, stipYoff; /* XXX assumed to be zero */
	    FbBits	fgand, fgxor, bgand, bgxor;

	    fgand = pPriv->and;
	    fgxor = pPriv->xor;
	    if (pGC->fillStyle == FillStippled)
	    {
		bgand = fbAnd(GXnoop,(FbBits) 0,FB_ALLONES);
		bgxor = fbXor(GXnoop,(FbBits) 0,FB_ALLONES);
	    }
	    else
	    {
		bgand = pPriv->bgand;
		bgxor = pPriv->bgxor;
	    }

	    fbGetStipDrawable (&pStip->drawable, stip, stipStride, stipBpp, stipXoff, stipYoff);
	    fbStipple (dst + (y + dstYoff) * dstStride, 
		       dstStride, 
		       (x + dstXoff) * dstBpp,
		       dstBpp,
		       width * dstBpp, height,
		       stip,
		       stipStride,
		       stipWidth,
		       stipHeight,
		       pPriv->evenStipple,
		       fgand, fgxor,
		       bgand, bgxor,
		       pGC->patOrg.x + pDrawable->x + dstXoff,
		       pGC->patOrg.y + pDrawable->y - y);
	}
	break;
    }

    case FillTiled: {
	PixmapPtr   pTile = pGC->tile.pixmap;
	FbBits	    *tile;
	int         tileStride;
	int	    tileBpp;
	int	    tileWidth;
	int	    tileHeight;
	int	    tileXoff, tileYoff; /* XXX assumed to be zero */

	xckGCPrivPtr pGCPriv = xckGetGCPriv (pGC);

	if (pGCPriv->colorkey_active == TRUE && pGCPriv->colorkey > 0)
	  {
	  /* backoff if no tile found */
	  if (pTile == NULL)
	    break;

	  XCK_data pdata = xckGetPixPriv (pTile);

	  /* scan tile for optimizing information */
	  if (pdata->type == XCK_UNKNOWN) 
	    xckScanPixmap (&pTile->drawable, pGCPriv->colorkey);

	  if (pdata->position_map!=NULL)
	  {
	    /* no transparency found */
	    if (pdata->type == XCK_NORMAL)
	      ;

	    else if (pdata->type == XCK_OPTIMIZE)
	    {
	      fbGetDrawable (&pTile->drawable, tile, tileStride, tileBpp, tileXoff, tileYoff);
	      tileWidth = pTile->drawable.width;
	      tileHeight = pTile->drawable.height;

	      fprintf(stderr,"tiling with %d x %d bpp %d, ckey is %d\n",tileWidth,tileHeight,tileBpp,pGCPriv->colorkey);

	      xckTile (dst + (y + dstYoff) * dstStride, 
		       dstStride, 
		       (x + dstXoff) * dstBpp, 
		       width * dstBpp, height,
		       tile,
		       tileStride,
		       tileWidth * tileBpp,
		       tileHeight,
		       pGC->alu,
		       pPriv->pm,
		       dstBpp,
		       (pGC->patOrg.x + pDrawable->x + dstXoff) * dstBpp,
		       pGC->patOrg.y + pDrawable->y - y,
		       pGCPriv->colorkey,
		       pdata
		       );
	      break;

	    }

	  } /* if position tables exist */

	}

        
	fbGetDrawable (&pTile->drawable, tile, tileStride, tileBpp, tileXoff, tileYoff);
	tileWidth = pTile->drawable.width;
	tileHeight = pTile->drawable.height;
	fbTile (dst + (y + dstYoff) * dstStride, 
		dstStride, 
		(x + dstXoff) * dstBpp, 
		width * dstBpp, height,
		tile,
		tileStride,
		tileWidth * tileBpp,
		tileHeight,
		pGC->alu,
		pPriv->pm,
		dstBpp,
		(pGC->patOrg.x + pDrawable->x + dstXoff) * dstBpp,
		pGC->patOrg.y + pDrawable->y - y);
	break;
    }
    }
    fbValidateDrawable (pDrawable);
}

void
xckSolidBoxClipped (DrawablePtr	pDrawable,
		   RegionPtr	pClip,
		   int		x1,
		   int		y1,
		   int		x2,
		   int		y2,
		   FbBits	and,
		   FbBits	xor)
{
    FbBits	*dst;
    int	        dstStride;
    int		dstBpp;
    int		dstXoff, dstYoff;
    BoxPtr	pbox;
    int		nbox;
    int		partX1, partX2, partY1, partY2;

    fbGetDrawable (pDrawable, dst, dstStride, dstBpp, dstXoff, dstYoff);
    
    for (nbox = REGION_NUM_RECTS(pClip), pbox = REGION_RECTS(pClip); 
	 nbox--; 
	 pbox++)
    {
	partX1 = pbox->x1;
	if (partX1 < x1)
	    partX1 = x1;
	
	partX2 = pbox->x2;
	if (partX2 > x2)
	    partX2 = x2;
	
	if (partX2 <= partX1)
	    continue;
	
	partY1 = pbox->y1;
	if (partY1 < y1)
	    partY1 = y1;
	
	partY2 = pbox->y2;
	if (partY2 > y2)
	    partY2 = y2;
	
	if (partY2 <= partY1)
	    continue;
	
	fbSolid (dst + (partY1 + dstYoff) * dstStride,
		 dstStride,
		 (partX1 + dstXoff) * dstBpp,
		 dstBpp,

		 (partX2 - partX1) * dstBpp,
		 (partY2 - partY1),
		 and, xor);
    }
}
