/**
   X Colorkey eXtension

   Authors:
   Tapani Paelli <tapani.palli@nokia.com>
*/
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include "xck.h"

/**
   Blitting for COMPLEX type pixmap.
   - slow pixel by pixel blitting
   
   adopted from fb routines (© 1998 Keith Packard).
*/
void
xckBlt (FbBits   *srcLine,
	int      srcStride,
	int      srcX,

	FbBits   *dstLine,
        int      dstStride,
	int      dstX,

	int      width,
	int      height,

	int      alu,
	FbBits   pm,
	int      bpp,

	Bool     reverse,
	Bool     upsidedown,
	int      ckey)
{
  unsigned int x,y;
  unsigned int w;
  w = width;

  /* are we just copying multiples of 8 bits?  if so, run, forrest, run!
       the memcpy()'s should be pluggable ala mplayer|xine - perhaps we can get
       one of the above to give up their code for us.
  */
  if((pm==FB_ALLONES) && (alu==GXcopy) && !reverse && (srcX&7)==0 && (dstX&7)==0 && (width&7)==0)
    {
      CARD16 *isrc = (CARD16*) srcLine;
      CARD16 *idst = (CARD16*) dstLine;
      unsigned int sstride = srcStride * sizeof (CARD16);
      unsigned int dstride = dstStride * sizeof (CARD16);

      width>>=4;
      isrc += srcX>>4;
      idst += dstX>>4;

      CARD16 *srcp = (CARD16*) srcLine;
      CARD16 *dstp = (CARD16*) dstLine;

      /* for each scanline */
      for(y=0; y<height; y++)
      {
	/* set pointers to right positions */
	srcp = isrc+y*sstride;
	dstp = idst+y*dstride;

	// copy scanline pixel by pixel
	for (x=0; x<width; x++, srcp++, dstp++)
	{
	  if (*srcp != ckey)
	    *dstp = *srcp;
	}
      }

      return;
    }

}

/********************************************************************/
/********************************************************************/
/********************************************************************/

/**
       16 bit optimized blitting with colorkey + clipping (x and y)
*/
void
colorkey_blit_xclip (DrawablePtr pSrc, DrawablePtr pDst, int dstXoff, int dstYoff)
{
  unsigned int width, height, bpp, Xoff, Yoff;
  unsigned int p1, byteamount;
  unsigned int *pos_table;
  unsigned int first_line = 0;
  unsigned int sy, dy;
  Bool uyclip;

  FbBits *srcLine;
  FbBits *dstLine;
  int srcStride;
  int dstStride;

  fprintf(stderr,"colorkey_blit_xclip\n");

  fbGetDrawable (pSrc, srcLine, srcStride, bpp, Xoff, Yoff);
  fbGetDrawable (pDst, dstLine, dstStride, bpp, Xoff, Yoff);

  PixmapPtr pix = (PixmapPtr) LookupIDByType (pSrc->id , RT_PIXMAP);
  XCK_data pdata = xckGetPixPriv(pix);

  pos_table = pdata->position_map;
  uyclip = FALSE;
  first_line += pdata->u_offset;

  sy = 0;
  dy = 0;

  height = pSrc->height;
  width  = pSrc->width;

  /* upper y clip */
  if (dstYoff < 0)
  {
    first_line += ((-dstYoff)-pdata->u_offset);
    height -= (-dstYoff);
    dstYoff = 0;
    uyclip=TRUE;
  }

  dstLine += (pDst->y) * dstStride;
  dstLine += (dstYoff) * dstStride;

  // bottom y clip
  if (pSrc->height+dstYoff > pDst->height)
    height -= dstYoff;

  width*=bpp;

  CARD16 *isrc= (CARD16*) srcLine;
  CARD16 *idst= (CARD16*) dstLine;
  unsigned int sstride = srcStride * sizeof (CARD16);
  unsigned int dstride = dstStride * sizeof (CARD16);

  idst += pDst->x;
  width>>=4;

  CARD16 *srcp = (CARD16*) srcLine;
  CARD16 *dstp = (CARD16*) dstLine;

  /* upper y-offset */
  pos_table += first_line*2;
  height -= pdata->d_offset;

  if (uyclip == TRUE)
    dy = 0;
  else
    dy = first_line;

  /* dest out of range */
  if (dstXoff > pDst->width)
    return;

  /* for each scanline */
  for (sy=first_line; sy<first_line+height; sy++, dy++)
  {
    srcp = isrc+sy*sstride;
    dstp = idst+dy*dstride;

    /* read position and amount of bytes */
    p1 = *pos_table++;
    byteamount = *pos_table++;

    /* if these are zero, skip memcpy operation */
    if (byteamount != 0)
    {
      /* move pointers by position information */
      srcp += p1;
      dstp += p1;

      /* x-offset less than zero */
      if (dstXoff < 0)
      {
	/* reset pointers */
	srcp = isrc+sy*sstride;
	dstp = idst+dy*dstride;
	
	/* move destination by dstXoff */
	if (p1 > (-dstXoff))
	  dstp += p1 - (-dstXoff);

	/* move source and count new byteamount if needed */
	srcp += -dstXoff;

	if (p1 > (-dstXoff))
	  srcp += p1 - (-dstXoff);
	else
	  byteamount -= (-dstXoff)-p1;

      } /* offset less than zero */

      else
	/* move destination by given offset */
	dstp += dstXoff;

      /* check if it goes over destination pixmap */
      while (p1+dstXoff+byteamount > pDst->width)
	byteamount--;

      /* copy if there's something to copy */
      if (byteamount > 0)
      {
	byteamount*=2;
	memcpy(dstp, srcp, byteamount);
      }
    }
  }
} /* colorkey_blit_xclip */

/********************************************************************/
/********************************************************************/
/********************************************************************/

/**
   16 bit optimized blitting with colorkey (+ y clipping)
   no x-clipping. makes it a bit faster but also more risky.
*/
void
colorkey_blit (DrawablePtr pSrc, DrawablePtr pDst, int dstXoff, int dstYoff)
{
  unsigned int width, height, bpp, Xoff, Yoff;
  unsigned int p1, byteamount;
  unsigned int *pos_table;
  unsigned int first_line = 0;
  unsigned int sy, dy;
  Bool uyclip;

  FbBits *srcLine;
  FbBits *dstLine;
  int srcStride;
  int dstStride;

  fprintf(stderr,"colorkey_blit\n");

  fbGetDrawable (pSrc, srcLine, srcStride, bpp, Xoff, Yoff);
  fbGetDrawable (pDst, dstLine, dstStride, bpp, Xoff, Yoff);

  PixmapPtr pix = (PixmapPtr) LookupIDByType (pSrc->id , RT_PIXMAP);
  XCK_data pdata = xckGetPixPriv(pix);

  pos_table = pdata->position_map;
  uyclip = FALSE;

  first_line += pdata->u_offset;

  sy = 0;
  dy = 0;

  height = pSrc->height;
  width  = pSrc->width;

  /* upper y clip */
  if (dstYoff < 0)
  {
    first_line += ((-dstYoff)-pdata->u_offset);
    height -= (-dstYoff);
    dstYoff = 0;
    uyclip=TRUE;
  }

  dstLine += (pDst->y) * dstStride;
  dstLine += (dstYoff) * dstStride;

  // bottom y clip
  if (pSrc->height+dstYoff > pDst->height)
    height -= dstYoff;

  width*=bpp;

  CARD16 *isrc = (CARD16*) srcLine;
  CARD16 *idst = (CARD16*) dstLine;
  unsigned int sstride = srcStride * sizeof (CARD16);
  unsigned int dstride = dstStride * sizeof (CARD16);

  idst += pDst->x;
  width>>=4;

  CARD16 *srcp = (CARD16*) srcLine;
  CARD16 *dstp = (CARD16*) dstLine;

  /* move pointer to upper y-offset */
  pos_table += first_line*2;
  height -= pdata->d_offset;

  if (uyclip == TRUE)
    dy = 0;
  else
    dy = first_line;

  /* for each scanline */
  for (sy=first_line; sy<first_line+height; sy++, dy++)
  {
    srcp = isrc+sy*sstride;
    dstp = idst+dy*dstride;

    /* read position and amount of bytes */
    p1 = *pos_table++;
    byteamount = *pos_table++;

    /* if these are zero, skip memcpy operation */
    if (byteamount != 0)
    {
      byteamount*=2;
      srcp += p1;
      dstp += p1;
      memcpy(dstp, srcp, byteamount);
    }
  }

} /* colorkey_blit */



/********************************************************************/
/********************************************************************/
/********************************************************************/



/**
   modified from fb routines, Copyright © 1998 Keith Packard

   I just added my own function call instead of fbBlt.
   // Tapani
*/
void
xckCopyNtoN (DrawablePtr pSrcDrawable,
            DrawablePtr pDstDrawable,
            GCPtr       pGC,
            BoxPtr      pbox,
            int         nbox,
            int         dx,
            int         dy,
            Bool        reverse,
            Bool        upsidedown,
            Pixel       bitplane,
            void        *closure)
{
  CARD8       alu = pGC ? pGC->alu : GXcopy;
  FbBits      pm = pGC ? fbGetGCPrivate(pGC)->pm : FB_ALLONES;
  FbBits      *src;
  int         srcStride;
  int         srcBpp;
  int         srcXoff, srcYoff;
  FbBits      *dst;
  int         dstStride;
  int         dstBpp;
  int         dstXoff, dstYoff;

  xckGCPrivPtr pGCPriv = xckGetGCPriv(pGC);

#ifdef XCK_DEBUG
  fprintf(stderr,":: function xckCopyNtoN (%d boxes to blit)\n",nbox);
#endif

#ifdef FB_24_32BIT
  if (pSrcDrawable->bitsPerPixel != pDstDrawable->bitsPerPixel)
    {
      fb24_32CopyMtoN (pSrcDrawable, pDstDrawable, pGC, pbox, nbox,
		       dx, dy, reverse, upsidedown, bitplane, closure);
      return;
    }
#endif

  fbGetDrawable (pSrcDrawable, src, srcStride, srcBpp, srcXoff, srcYoff);
  fbGetDrawable (pDstDrawable, dst, dstStride, dstBpp, dstXoff, dstYoff);

  /* note that y-offset is calculated here in the function call */
  while (nbox--)
    {
      /* call colorkey blitter function */
      xckBlt (src + (pbox->y1 + dy + srcYoff) * srcStride,
	      srcStride,
	      (pbox->x1 + dx + srcXoff) * srcBpp,
                                                                                                                                                                           
	      dst + (pbox->y1 + dstYoff) * dstStride,
	      dstStride,
	      (pbox->x1 + dstXoff) * dstBpp,
                                                                                                                                                                           
	      (pbox->x2 - pbox->x1) * dstBpp,
	      (pbox->y2 - pbox->y1),
	      alu,
	      pm,
	      dstBpp,
                                                                                                                                                                           
	      reverse,
	      upsidedown,
	      pGCPriv->colorkey);
      pbox++;
    }
}
