#!/bin/sh
# X server startup/shutdown script

. /etc/osso-af-init/x-server.defs

case "$1" in
  start)
  if [ ! -r /etc/pointercal -a -r /etc/pointercal.default ]; then
  	cp -f /etc/pointercal.default /etc/pointercal
  fi
  
  [ -c /dev/input/mouse0 ] && EXTRAOPT='-mouse /dev/input/mouse0'

  if [ -x /usr/sbin/dsmetool -a -x /usr/bin/Xomap ]
  then
  
	  dsmetool --nice=-1 -r "/usr/bin/Xomap \
         $EXTRAOPT -mouse /dev/input/event0 \
         -dpi $DISPLAY_DPI "
  elif [ -x /usr/bin/Xomap ]
  then
 	/usr/bin/Xomap \
	$EXTRAOPT -mouse /dev/input/event0 \
	-dpi $DISPLAY_DPI  >/dev/null 2>&1 & 
  fi
		 
	;; 
  stop)
  	[ -c /dev/input/mouse0 ] && EXTRAOPT='-mouse /dev/input/mouse0'
	if [ -x /usr/sbin/dsmetool -a -x /usr/bin/Xomap ]	
  	then
  	 	dsmetool -k "/usr/bin/Xomap \
         	$EXTRAOPT -mouse /dev/input/event0 \
         	-dpi $DISPLAY_DPI "
	elif [ -x /usr/bin/Xomap ]
	then
		/usr/bin/Xomap \
		$EXTRAOPT -mouse /dev/input/event0 \
		-dpi $DISPLAY_DPI
	fi	 
    ;;
  *)      
    echo "Usage: $0 {start|stop}"
	exit 1
    ;;
esac

