/*
 * Copyright © 2008 Nokia Corporation
 *
 * Permission to use, copy, modify, distribute and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the names of the authors and/or copyright holders
 * not be used in advertising or publicity pertaining to distribution of the
 * software without specific, written prior permission.  The authors and
 * copyright holders make no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without any express
 * or implied warranty.
 *
 * THE AUTHORS AND COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO
 * THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR
 * ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 * RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 * CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Siarhei Siamashka <siarhei.siamashka@nokia.com>
 *
 * Portions based on fbpict.c
 */

#ifndef _FBARMV6_H_
#define _FBARMV6_H_

/* a very simple test for ARMv6 instructions support availability, probably it is
   better to integrate something into configure script instead */
#if defined(__ARM_ARCH_6__) || defined(__ARM_ARCH_6J__)
#define USE_ARMV6
#endif

#ifdef USE_ARMV6

#define FbByteMulAdd_store_r5g6b5_armv6(x, a, y) do {                         \
        unsigned int t = ((x & 0xff00ff) * a) + 0x800080;                     \
        x = (((x >> 8) & 0xff) * a) + 0x80;                                   \
        t = (t + ((t >> 8) & 0xff00ff));                                      \
        x = (x + ((x >> 8)));                                                 \
        asm("uqadd8 %0, %1, %2 \n" : "=r" (t) : "r" (t), "r" (y << 8));       \
        asm("uqadd8 %0, %1, %2 \n" : "=r" (x) : "r" (x), "r" (y));            \
        x = ((t >> (3 + 8)) & 0x001F)                                         \
                | ((t >> (8 + 8)) & 0xF800) | ((x >> 5) & 0x07E0);            \
    } while (0)

#define FbByteMulAdd_store_x8r8g8b8_armv6(x, a, y) do {                       \
        unsigned int t = ((x & 0xff00ff) * a) + 0x800080;                     \
        x = (((x >> 8) & 0xff) * a) + 0x80;                                   \
        t = (t + ((t >> 8) & 0xff00ff));                                      \
        x = (x + ((x >> 8)));                                                 \
        t = (t >> 8) & 0xff00ff;                                              \
        x &= 0xff00;                                                          \
        x += t;                                                               \
        asm("uqadd8 %0, %1, %2 \n" : "=r" (x) : "r" (x), "r" (y & 0xffffff)); \
    } while (0)

#endif

struct _FbComposeData;

void fbCompositeSolidMask_nx8x0565_armv6 (struct _FbComposeData *params);
void fbCompositeSrcAdd_8000x8000_armv6 (struct _FbComposeData *params);
void fbComposite_x8r8g8b8_src_r5g6b5_armv6 (struct _FbComposeData *params);

void fbmemcpy_arm(void *dst, void *src, int w);

#endif
