/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of telepathy-feed
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef _UTIL_H
#define _UTIL_H

#include <dbus/dbus.h>
#include <dbus/dbus-glib-bindings.h>

char *get_hashtable_as_string(GHashTable *ht);

gboolean tf_tp_conn_inspect_handle (DBusGProxy *proxy, const guint IN_handle_type, const guint IN_handle, char ** OUT_arg2, GError **error);
gboolean tf_tp_conn_request_handle (DBusGProxy *proxy,
                                    const guint IN_handle_type,
                                    const char *IN_name,
                                    guint      *OUT_arg2,
                                    GError    **error);

#endif /* _UTIL_H */
