/* -*- Mode: C; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of telepathy-feed
 *
 * Copyright (C) 2006 Nokia Corporation. All rights reserved.
 *
 * Contact: Onne Gorter <onne.gorter@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <libtelepathy/tp-conn.h>
#include "util.h"

static void
concat_vals (gpointer key, gpointer value, gpointer userdata)
{
  char *rv, *str;
  
  str = *((char **)userdata);
  rv = g_strdup_printf ("%s%s%s", str ? str : "", str ? ", " : "", 
                       (char*)key);
  if (str) {
    g_free (str);
  }
  
  *((char**)userdata) = rv;
}

char *
get_hashtable_as_string (GHashTable *ht)
{
  char *rv = NULL;

  g_hash_table_foreach (ht, concat_vals, (gpointer)&rv);

  return rv;
}


G_GNUC_DEPRECATED gboolean
tf_tp_conn_inspect_handle (DBusGProxy *proxy, 
                           const guint IN_handle_type, 
                           const guint IN_handle, 
                           char      **OUT_arg2, 
                           GError    **error)
{
  GArray *arr;
  char **names;
  gboolean ret;

  arr = g_array_new (FALSE, FALSE, sizeof (guint));
  g_array_append_val (arr, IN_handle);

  ret = tp_conn_inspect_handles (proxy, IN_handle_type, arr, &names, error);
  if (ret) {
    *OUT_arg2 = names[0];
    g_free (names);
  }
  g_array_free (arr, TRUE);

  return ret;
}

G_GNUC_DEPRECATED  gboolean
tf_tp_conn_request_handle (DBusGProxy *proxy,
                           const guint IN_handle_type,
                           const char *IN_name,
                           guint      *OUT_arg2,
                           GError    **error)
{
  const char *names[2] = { NULL, NULL };
  GArray *arr;

  names[0] = IN_name;
  
  if (tp_conn_request_handles (proxy, IN_handle_type, names, &arr, error)) {
    *OUT_arg2 = g_array_index (arr, guint, 0);
    return TRUE;
  }

  return FALSE;
}
