/**
 * @file callbacks.h misc UI stuff
 *
 * Copyright (C) 2003, 2004 Lars Lindner <lars.lindner@gmx.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef _CALLBACKS_H
#define _CALLBACKS_H

#include <hildon/hildon-caption.h>

#include <gtk/gtk.h>
#include "ui_mainwindow.h"
#include "ui_feedlist.h"
#include "ui_feed.h"
#include "ui_itemlist.h"
#include "ui_folder.h"
#include "ui_search.h"
#include "ui_popup.h"
#include "ui_prefs.h"
#include "ui_dnd.h"
#include "export.h"
#include "htmlview.h"
#include "appdata.h"

#define MIN_INTERVAL 15
#define CELL_RENDERER_WIDTH 300
#define DEFAULT_INTERVAL 30
/* Filter pattern for opml Hildon file chooser */
#define OPML_FILE_EXTENSION_1 "xml"
#define OPML_FILE_EXTENSION_2 "opml"



#define RSS_RESPONSE_NEW_FOLDER 10001
#define RSS_RESPONSE_RENAME_FOLDER 10002
#define RSS_RESPONSE_DELETE_FOLDER 10003
#define RSS_RESPONSE_FEED_PROP_UNSUBSCRIBE 11001

#define RSS_RESPONSE_FEED_IMPORT_OPML_BROWSE 10004

#define RSS_RESPONSE_FEED_PROP_CHANGEFOLDER 11002

#define ZOOM_50 50
#define ZOOM_80 80
#define ZOOM_100 100
#define ZOOM_120 120
#define ZOOM_150 150
#define ZOOM_200 200


#define WAITTIME_BEFORE_SHOWN_NEW_OUTOFMEM_DIALOG 15  /* in seconds. show the dialog every 15 seconds by default */




extern GdkPixbuf *icons[MAX_ICONS];

/** 
 * GUI initialization methods. Sets up dynamically created
 * widgets, load persistent settings and starts cache loading.
 */
void ui_init(gboolean startIconified, AppUIData * app_ui_data);


void change_zoom_cb(GtkWidget * widget, gpointer data);


void ui_show_info_box(const char *format, ...);
void ui_show_error_box(const char *format, ...);

void on_prefdialog_response(GtkWidget * prefdialog, gint responseId,
                            gpointer user_data);
void automatic_updates_toggled_cb(GtkToggleButton * togglebutton,
                                  gpointer user_data);
gboolean on_prefdialog_insensitive_press(GtkWidget * widget,
                                         GdkEventButton * event,
                                         gpointer user_data);

/*
 * void radio_button_automatically_toggled_cb (GtkToggleButton *togglebutton,
 * gpointer         user_data);
 */

void on_refreshbtn_clicked_cb(nodePtr ptr);
void on_refresh_finished(gboolean disable_banner,
                         gboolean do_not_signal_applet);

void on_nextbtn_clicked(GtkButton * button, gpointer user_data);
void on_refreshbtn_clicked(GtkButton * button, gpointer user_data);
void on_managefoldersbtn_clicked(GtkButton * button, gpointer user_data);
void on_refresh_menuitem_selected(GtkWidget * menuitem, gpointer user_data);

/** Quits the program
  *
  * @param reset_state if the state should be reset on quitting
  * @return always FALSE
  */
gboolean on_quit_cb(gpointer data);
gboolean on_quit(gboolean reset_state);
void abort_quit();

void on_scrolldown_activate(GtkMenuItem * menuitem, gpointer user_data);

void toggle_folder_list(GtkWidget * button, gpointer user_data);

gboolean on_gtkhtml_keyboard_event(GtkWidget *widget, GdkEventKey *event, gpointer user_data);
gboolean on_gtkhtml_expose();

/**
 * Callback for folder list button.
 *
 * @param button button widget
 * @param user_data user data
 */
void on_folder_list_button_clicked(GtkWidget * button, gpointer user_data);


/**
 * Callback for toolbar menu item.
 *
 * @param button button widget
 * @param user_data user data
 */
void toggle_toolbar_cb(GtkWidget * widget, gpointer user_data);

/**
   Callback for key_press signal when toolbar is hidden.

   @param widget widget for which the callback is called
   @param event GDK event
   @param user_data user data
   @return TRUE to block the event, FALSE otherwise
 */
gboolean key_press_with_hidden_toolbar(GtkWidget * widget,
                                       GdkEventKey * event,
                                       gpointer user_data);

/**
 * Callback for toolbar menu item.
 *
 * @param widget widget for which the callback is called
 * @param user_data user data
 */
gboolean hide_temp_shown_toolbar(GtkWidget * widget, gpointer user_data);

/**
 * Callback for fullscreen menu item.
 *
 * @param button button widget
 * @param user_data user data
 */
void on_toggle_fullscreen_mode(GtkWidget * widget, gpointer user_data);


/**
 * Toggle fullscreen mode and update the fullscreen menu item.
 *
 * @param button button widget
 * @param user_data user data
 */
void toggle_fullscreen_and_update_menu(GtkWidget * widget,
                                       gpointer user_data);


/* FIXME: These were probably meant to be on_feedlist_drag? */

void
on_manage_folders_drag_data_received(GtkWidget * widget,
                                     GdkDragContext * context,
                                     gint x,
                                     gint y,
                                     GtkSelectionData * selection_data,
                                     guint info, guint time);

gboolean
on_manage_folders_drag_drop(GtkWidget * widget,
                            GdkDragContext * context,
                            gint x, gint y, guint time);

/* FIXME: move the following to ui_filter... */
void on_popup_filter_selected(void);

void on_addrulebtn_clicked(GtkButton * button, gpointer user_data);

void on_rulepropbtn_clicked(GtkButton * button, gpointer user_data);

void on_ruleupbtn_clicked(GtkButton * button, gpointer user_data);

void on_ruledownbtn_clicked(GtkButton * button, gpointer user_data);

void on_rulechangedbtn_clicked(GtkButton * button, gpointer user_data);

void
on_feedlist_drag_data_get(GtkWidget * widget,
                          GdkDragContext * drag_context,
                          GtkSelectionData * data,
                          guint info, guint time, gpointer user_data);

void
on_feedlist_drag_data_received(GtkWidget * widget,
                               GdkDragContext * drag_context,
                               gint x,
                               gint y,
                               GtkSelectionData * data,
                               guint info, guint time, gpointer user_data);

void on_about_activate(GtkMenuItem * menuitem, gpointer user_data);

void on_menu_open(GtkMenuItem * menuitem, gpointer user_data);

void on_menu_feed_new(GtkMenuItem * menuitem, gpointer user_data);

void on_menu_delete(GtkMenuItem * menuitem, gpointer user_data);

void on_menu_properties(GtkMenuItem * menuitem, gpointer user_data);

void on_menu_update(GtkMenuItem * menuitem, gpointer user_data);

void on_menu_folder_delete(GtkMenuItem * menuitem, gpointer user_data);

void on_menu_folder_rename(GtkMenuItem * menuitem, gpointer user_data);

void on_cut(GtkAction * action, gpointer data);
void on_copy(GtkAction * action, gpointer data);
void on_paste(GtkAction * action, gpointer data);
void on_selectall(GtkAction * action, gpointer data);
void on_menuitem_edit(GtkWidget * widget, gpointer user_data);
void on_menuitem_tools(GtkWidget * widget, gpointer user_data);

void toggle_find_on_page(GtkWidget * widget, gpointer user_data);
void find_toolbar_search(GtkWidget * widget, gpointer data);
void find_toolbar_close(GtkWidget * widget, gpointer data);

/**
   Refresh a node. Check if the refresh is interrupted.

   @param nodePtr node
   @return TRUE to continue refreshing, FALSE to interrupt
 */
gboolean update_node(nodePtr ptr);

GtkWidget *display_new_folder_dialog(GtkWidget * widget,
                                     GtkWindow * parent_window);

/** Pops up the Hildon Filer chooser dialog
   @param widget Not used
   @param user_data: Is used as AppUIData
*/
void display_file_chooser_dialog(GtkWidget * widget, gpointer user_data);
void display_change_folder_dialog(GtkWidget *, gpointer);

void top_changed(GObject * self,
                 GParamSpec * property_param, gpointer user_data);


/**
   Callback for key_press signal for HildonApp widget.

   @param widget widget for which the callback is called
   @param event GDK event
   @param user_data user data
   @return TRUE to block the event, FALSE otherwise
 */
gboolean on_key_press(GtkWidget * widget, GdkEventKey * event,
                      gpointer user_data);

void on_refresh_action(AppUIData * app_ui_data);

/** Frees the find string used for find on page implementation
  */
void free_find_string();

/** Does state save
  */
void save_state(AppData * app_data);

/** Restores the state
  */
void restore_state(AppData * app_data);

/**
   Key press handler for cancelling a dialog

   @param widget the dialog to cancel
   @param event GDK event
   @param data not used
 */
gboolean key_press_for_cancelling_dialog(GtkWidget * widget,
                                         GdkEventKey * event, gpointer data);

/**
   Focus-in event handler for feedlist pane

   Undims unsubscribe feed and feed details buttons / menuitems, if selection is not on folder.

 */
void on_feedlist_focus_in();

/**
   Focus-in event handler for html_scrollpane

   When search results are displayed, dims unsubscribe feed and feed details
   buttons / menuitems.

   @param widget focus holder
   @param event GDK event focus
   @param data not used
 */
void on_html_scrollpane_focus_in(GtkWidget * widget,
                                 GdkEventFocus * event, gpointer data);

void stop_search(void);

void on_open_cmenuitem_selected(GtkWidget * menuitem, gpointer user_data);

void on_new_folder_cmenuitem_selected(GtkWidget * menuitem,
                                      gpointer user_data);

void on_rename_cmenuitem_selected(GtkWidget * menuitem, gpointer user_data);

void on_delete_cmenuitem_selected(GtkWidget * menuitem, gpointer user_data);

void on_copy_link_menuitem_selected(GtkWidget * menuitem, gpointer user_data);

void on_send_post_menuitem_selected(GtkWidget * menuitem, gpointer user_data);

void on_load_image_menuitem_selected(GtkWidget * menuitem,
                                     gpointer user_data);

void on_save_image_menuitem_selected(GtkWidget * menuitem,
                                     gpointer user_data);

void on_clear_image_cache(GtkWidget * menuitem, gpointer user_data);

void on_menuitem_sort(GtkWidget * button, gpointer user_data);

void on_insensitive_infoprint(GtkWidget * widget, gchar * info);

void switch_progressbar(progress_bar_mode mode);

void update_progress_bar();


void ui_show_save_nodevicemem_dialog(void);

gboolean on_search_field_key_press(GtkWidget * widget, GdkEventKey * event,
                                   gpointer user_data);

gboolean on_search_field_focus_out (GtkWidget *widget, GdkEventFocus *event, gpointer user_data);
#endif
