/**
  @file util.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _UTIL_H_
#define _UTIL_H_

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <time.h>

#ifdef DEBUG
char *bytestr(const unsigned char *data, int len);
char *chomp(char *str);
#endif

time_t parse_iso8601(const char *str, int len);

char *utf16_to_utf8(const unsigned char *utf16, size_t len);

#endif /* _UTIL_H_ */
