/**
  @file server.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _SERVER_H_
#define _SERVER_H_

#include <stdint.h>
#include <glib.h>
#include <bluetooth/bluetooth.h>

typedef struct server_context ServerContext;

gboolean server_start(bdaddr_t *local_dev, uint8_t channel, const char *root, int limit);

void server_stop(void);

gboolean server_has_target(ServerContext *server, const unsigned char *target, unsigned int length);

#endif /* _SERVER_H_ */
