/**
  @file dbus.h

  @author Johan Hedberg <johan.hedberg@nokia.com>

  Copyright (C) 2006 Nokia Corporation. All rights reserved.

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License, version 2, as
  published by the Free Software Foundation.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/
#ifndef _DBUS_H_
#define _DBUS_H_

#include "client.h"

gboolean init_dbus(void);

void deinit_dbus(void);

char *srv_dbus_auth(ClientConnection *client,
                    ObjectTransfer   *xfer,
                    gpointer          user_data);

gboolean srv_dbus_progr(ClientConnection *client,
                        ObjectTransfer   *xfer,
                        gpointer          user_data);

void srv_dbus_xfer(ClientConnection *client,
                   ObjectTransfer   *xfer,
                   gboolean          started,
                   gboolean          success,
                   gpointer          user_data);

#endif /* _BTCOND_DBUS_H_ */
