#include <config.h>
#if DBUS_ENABLE==1

#ifndef _gpsd_dbus_h_
#define _gpsd_dbus_h_

//#define DBUS_API_SUBJECT_TO_CHANGE
#include <dbus/dbus.h>

#include <gpsd.h>

int initialize_dbus_connection (void);
int cleanup_dbus(void);
void send_dbus_fix (struct gps_device_t* channel);
int send_dbus_status_changed (struct gps_device_t* channel, int force);
int check_dbus_messages(struct gps_device_t *devices, int max_devices);
int get_dbus_socket(int *fd);

#define GPSD_SERVICE        "org.gpsd"
#define GPSD_INTERFACE      GPSD_SERVICE
#define GPSD_PATH           "/org/gpsd"
#define GPSD_GET_STATUS_REQ "get_status"

#endif /* _gpsd_dbus_h_ */

#endif
