#include <libmodest-dbus-client-1.0/libmodest-dbus-client/libmodest-dbus-client.h>

#include <stdio.h>
#include <libosso.h>
#include <glib.h>

#include <ossoemailinterface.h>


int main(int argc, char *argv[])
{
	GSList *filenames = NULL;
	filenames = g_slist_append (filenames,
		"/usr/include/math.h");
	filenames = g_slist_append (filenames,
		"/usr/include/malloc.h");
	
	/* Initialize maemo application */
	osso_context_t * osso_context = osso_initialize(
	    "test_hello", "0.0.1", TRUE, NULL);
	       
	/* Check that initialization was ok */
	if (osso_context == NULL)
	{
		printf("osso_initialize() failed.\n");
	    return OSSO_ERROR;
	}
	
	/* Call the function in libmodest-dbus-client: */
	const osso_return_t ret = osso_email_files_email (osso_context, filenames);

	if (ret != OSSO_OK) {
		printf("osso_email_files_email() failed.\n");
		return OSSO_ERROR;
	} else {
		printf("osso_email_files_email() succeeded.\n");
	}
		
    /* Exit */
    return 0;

}
