#include <libmodest-dbus-client-1.0/libmodest-dbus-client/libmodest-dbus-client.h>

#include <stdio.h>
#include <libosso.h>
#include <glib.h>

#include <ossoemailinterface.h>


int main(int argc, char *argv[])
{
	/* Initialize maemo application */
	osso_context_t * osso_context = osso_initialize(
	    "test_hello", "0.0.1", TRUE, NULL);
	       
	/* Check that initialization was ok */
	if (osso_context == NULL)
	{
		printf("osso_initialize() failed.\n");
		return OSSO_ERROR;
	}
	
	/* Call the function in libmodest-dbus-client: */
	GSList *list = osso_email_get_folder_list (osso_context);

	if (list) {
		GSList *iter = NULL;
		for (iter = list; iter; iter = iter->next) {
			gchar *name = (gchar *)iter->data;	
			if (name) {
				printf("  Folder name=%s\n", name);
				g_free (name);
			}
		}
	
		g_slist_free (list);
	} else {
		printf("  The list of folders was empty.\n");	
	}	

		
    /* Exit */
    return 0;

}
