/**
 * @file nitro-ui-main.c
 *  
 * This file contains the main function for NITRO UI Application.
 * This application is invoked by the NITRO Daemon in two modes -
 * 1. Send all files (Will send all the Rich cores to NITRO Server
 * 2. Send a file (Will send only a newly generated Rich core
 * Based on the above two modes, it will launch appropriate
 * dialog to the user
 *
 * This file is part of nitro
 *
 * Copyright (C) 2007-2008 Nokia Corporation. 
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#include <stdio.h>
#include <string.h>
#include <gconf/gconf-client.h>
#include <libgnomevfs/gnome-vfs.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libosso.h>
#include <log-functions.h>
#include <osso-log.h>

#include "nitro-ui-main.h"
#include "nitro-ui-utils.h"
#include "nitro-handler.h"

/* It stores the list of files to be uploaded*/
GSList *files_list = NULL;

/* NITRO UI Application context */
osso_context_t *context = NULL;

/* nitro_ui_status is the application mode
 *  which can take the values -
 * NOT_ALREADY_UP, SEND_FILE, SEND_ALL_FILES */
static nitroUIMode nitro_ui_status = NOT_ALREADY_UP;

/**
  This function is a callback to detect when the device is about to
  shut down. When that occurs, it's time for the Nitro UI to go down.
  
  @param hw_state contains the monitored hardware state changes
  @param data not used in this case

*/
static void hw_state_event_cb(osso_hw_state_t *hw_state, gpointer data)
{
        if (hw_state->shutdown_ind == TRUE) {
                osso_log(LOG_DEBUG, "[%s]: Shutting down Nitro UI\n",
			 __FUNCTION__);
                nitro_ui_exit();
                return;
        }
}


/**
 This is a callback for the RPC method when requested on the 
 registered interface

 @param The interface that the method is called on
 @param The method which can be -
 	NITRO_METHOD_SEND_ALL-Sends all the RichCores present in 'core-dumps' dirs
	NITRO_METHOD_SEND_FILE-Sends only one RichCore whose uri is passed as argument
 @param A GArray of osso_rpc_t structures
 @param An application specific pointer
 @param The return value of the method

 @return OSSO_OK if success else OSSO_ERROR
*/
static osso_return_t 
nitro_ui_rpc_callback_handler(const gchar * interface, const gchar * method, 
			 GArray * arguments, gpointer method_name, osso_rpc_t *retval)
{
	gchar *file_text_uri = NULL;
	
	if ((method == NULL) || (interface == NULL)) {
                osso_log(LOG_DEBUG, "Invalid input params received \n");
		return OSSO_ERROR;
	}

	if(!strcmp(method,NITRO_METHOD_SEND_ALL)) {
		nitro_ui_collect_all_corefile_names();
		nitro_ui_status = SEND_ALL_FILES;
		nitro_ui_set_connec_callback_notifiers();
		nitro_ui_ask_user_conf(TRUE);
		return OSSO_OK;
	} else if(!strcmp(method,NITRO_METHOD_SEND_FILE)) {
		if((g_array_index(arguments, osso_rpc_t, 0).value.s) == NULL) {
			osso_log(LOG_DEBUG, "NULL param passed to nitro_ui \n");
			return OSSO_ERROR;
		}
		/* Appending single file to the list*/
		file_text_uri = g_strdup(g_array_index(arguments, osso_rpc_t, 0).value.s);
		files_list = g_slist_append(files_list, file_text_uri);
		if(nitro_ui_status == NOT_ALREADY_UP) {
			nitro_ui_status = SEND_FILE;
			nitro_ui_set_connec_callback_notifiers();
			nitro_ui_ask_user_conf(FALSE);
		}
			
		return OSSO_OK;
	} else
		osso_log(LOG_DEBUG,"[%s] Unknown method is called", __FUNCTION__);
		return OSSO_ERROR;
}


/**
  main:

  @param argc is a number of command line arguments.
  @param argv is Command line argument strings.
  @return gint
*/
gint main(int argc, char *argv[])
{
	GError *error = NULL;
	osso_hw_state_t hw_state = {TRUE, FALSE, FALSE, FALSE, 0};
	
	bindtextdomain(PACKAGE, "/usr/share/locale");
        bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain(PACKAGE);
	
	/* Initialization functions */
#ifdef  MAEMO_CHANGES
	g_thread_init(NULL);
#endif
	osso_log(LOG_DEBUG, "NITRO UI is launched \n");
	context = osso_initialize("nitro_ui", "0.1", TRUE, NULL);
	g_return_val_if_fail(context != NULL, 0);

	if (!gconf_init(argc, argv, &error)) {
		osso_log(LOG_ERR, "Error in Gconf init = %s  \n", error->message);
		g_error_free(error);
		return FALSE;
	}

	gtk_init(&argc, &argv);
	gnome_vfs_init();
	
	if(nitro_libs_init() != TRUE) {
		osso_log(LOG_ERR, "Failed to initialize nitro_libs");
		return FALSE;
	}
	
	/* We want to monitor for impeding shutdown events */
	osso_hw_set_event_cb(context, &hw_state, hw_state_event_cb, NULL);

	/* registering rpc callback */
	if(osso_rpc_set_default_cb_f_with_free(context, nitro_ui_rpc_callback_handler, NULL, osso_rpc_free_val) != OSSO_OK) {
		osso_deinitialize(context);
		osso_log(LOG_DEBUG, "EXITING SINCE rpc callback register failed");
		return OSSO_ERROR;
	}

	gtk_main();
	osso_deinitialize(context);
	gnome_vfs_shutdown();
	return 0;
}

