/*
 * This file is part of maemopad
 *
 * Copyright (C) 2005-2008 Nokia Corporation. All rights reserved.
 *
 * This maemo code example is licensed under a MIT-style license,
 * that can be found in the file called "COPYING" in the root
 * directory.
 *
 */

#include <ui/interface.h>
#include <ui/callbacks.h>

#include <appdata.h>

#include <gtk/gtkmain.h>

#include <hildon-1/hildon/hildon-program.h>

#include <libintl.h>
#include <locale.h>
#include <libosso.h>

#define OSSO_SERVICE "com.nokia."PACKAGE

#define _(String) gettext(String)

#include <config.h>

/*
 * create our application specific data
 * This consists of allocating some space
 * for the AppData structure, and also
 * creating the list store that will act
 * as a model for the contact list.
 * The other elements of the AppData structure
 * are implicitly set by the call to g_new0
 * which zeroes the memory of the AppData, thereby
 * setting create_new to FALSE, and iter to NULL.
 *
 */

static AppData *create_data ()
{
    AppData *result = g_new0( AppData, 1 );

    result->osso = osso_initialize ( OSSO_SERVICE, VERSION, TRUE, NULL );
    g_assert ( result->osso );
    return result;
}

/* Here we clean up all the data that we allocated */
static void destroy_data ( AppData *data )
{
    g_free ( data );
}

int main( int argc, char* argv[] )
{
    AppData* data; 
    HildonProgram* program; 
    AppUIData* main_view;

    /* Initialise the locale stuff */
    setlocale ( LC_ALL, "" );
    bindtextdomain ( GETTEXT_PACKAGE, LOCALEDIR );
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain ( GETTEXT_PACKAGE );

    /* Init the gtk - must be called before any hildon stuff */
    gtk_init( &argc, &argv );

    /* Create the hildon application and setup the title */
    program = HILDON_PROGRAM ( hildon_program_get_instance () );
    g_set_application_name ( _("MaemoPad") );

    if(!g_thread_supported()) {
        g_thread_init(NULL);
    }

    /* Create the data and views for our application */
    data = create_data ();
    data->program = program;
    main_view = interface_main_view_new ( data );

    hildon_program_add_window( data->program, data->window );

    g_signal_connect( G_OBJECT(data->window), "delete_event", gtk_main_quit, NULL );    
    /* Connect key presses signals */
    g_signal_connect(G_OBJECT(data->window), "key_press_event",
                       G_CALLBACK(key_press),(gpointer) main_view);
    g_signal_connect(G_OBJECT(data->window), "key_release_event",
                       G_CALLBACK(key_release), (gpointer) main_view);
    
    /* Begin the main app */
    gtk_widget_show ( GTK_WIDGET ( program ) );
    gtk_main();

    /* Clean up */
    interface_main_view_destroy ( main_view );
    destroy_data ( data );

    return 0;
}     

