/*
    Copyright (C) 2003 Nokia 
    Contact Jussi Laako <jussi.laako@nokia.com>

    This file originated from the Outo project.

    Outo is free software; you can redistribute it and/or modify
    it under the terms of the GNU Lesser General Public License as published 
    by the Free Software Foundation; either version 2.1 of the License, or
    (at your option) any later version.

    Outo is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public License
    along with Outo; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef __DEFINED_OUTO_H_
#define __DEFINED_OUTO_H_


typedef enum {
  EXPECT_OK =0,
  EXPECT_ASSERT
} EXPECTED;

typedef struct _testcase {
  int (*test)();
  char* description;
  EXPECTED ex_result;
} testcase;


/* these funcs are for the test library to implement */

/* mandatory */
testcase* get_tests();

/* optional */
void init_test();


/* some macros that can be used in test libraries. note that these are NOT
   needed, plain return 0; is a fine way to say test failed.
 */
#define FAIL(msg) do{printf(msg);return 0;}while(0)
#define PASS(msg) do{printf(msg);return 1;}while(0)



/* 
   all the signals that are considered to be a result of throwing assert
   SIGABRT is the normal, some versions of glib seems to use SIGTRAP
   not in use yet, defined in outo.c
*/
/* #define ASSERT_SIGNALS = {SIGABRT, SIGTRAP} */


#endif





