#include <time.h>
#include <gtk/gtk.h>

#include <scwview.h>
#include <scwentry.h>

#define ITEM_COUNT 10
#define INTERVAL 20


GtkWidget *win;


void delete_win (GtkWidget *widget, gpointer user_data)
{
  gtk_widget_destroy (widget);
  gtk_main_quit ();
}

void on_activated (ScwView *view, gchar *id, gchar *action_data, gpointer user_data)
{
  g_print ("Activated id=%s, data=%s\n", id, action_data);
}

GRand *rng;
guint count;
GtkTreeModel *model1;
GtkTreeModel *model2;

gboolean append_one (gpointer data);
gboolean prepend_one (gpointer data);
gboolean insert_random (gpointer data);
gboolean change_random (gpointer data);
gboolean remove_first (gpointer data);
gboolean remove_random (gpointer data);
gboolean switch_model (gpointer data);
gboolean switch_model2 (gpointer data);

gboolean append_one (gpointer data)
{
  gchar *str = g_strdup_printf ("[<b>%i</b> %p]", count++, data);
  GtkTreeIter iter;
  GtkListStore *model;

  g_return_if_fail (data != NULL);
  g_return_if_fail (GTK_IS_LIST_STORE (data));
  
  model = GTK_LIST_STORE (data);

  gtk_list_store_append (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                      0, time(NULL),
                      1, gdk_pixbuf_new_from_file_at_size ("debian-logo.png",
                                                           24, 24,
                                                           NULL),
                      2, str,
                      3, "This <action id='append'>row</action> was <icon id='gtk-add'> <b>appended</b> ",
                      -1);
  
  g_free (str);
  
}

gboolean prepend_one (gpointer data)
{
  gchar *str;
  GtkTreeIter iter;
  GtkListStore *model;
  
  g_return_if_fail (data != NULL);
  g_return_if_fail (GTK_IS_LIST_STORE (data));
  
  model = GTK_LIST_STORE (data);

  str = g_strdup_printf ("[<action id='%i'>%p</action>]", count++, data);
  gtk_list_store_prepend (GTK_LIST_STORE (model), &iter);
  gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                      0, time(NULL),
                      1, gdk_pixbuf_new_from_file_at_size ("debian-logo.png",
                                                           24, 24,
                                                           NULL),
                      2, str,
                      3, "This <action id='prepend'>row</action> was <icon id='gtk-remove'/><b>prepended</b> ",
                      -1);
  g_free (str);

}

gboolean insert_random (gpointer data)
{
  gint i;
  GtkTreeIter iter;
  GtkListStore *model;
  
  g_return_if_fail (data != NULL);
  g_return_if_fail (GTK_IS_LIST_STORE (data));
  
  model = GTK_LIST_STORE (data);

  i = gtk_tree_model_iter_n_children (GTK_TREE_MODEL(model), NULL);

  if (i > 0)
    {
      gchar *str = g_strdup_printf ("[<b>%i</b> %p]", count++, data);
      gtk_list_store_insert (GTK_LIST_STORE (model), &iter,
                              g_rand_int_range (rng, 0, i));
                              
      gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                          0, time(NULL),
                          1, gdk_pixbuf_new_from_file_at_size ("debian-logo.png",
                                                                24, 24,
                                                                NULL),
                          2, str,
                          3, "This <action id='random'>row</action> was <icon id='gtk-dialog-question'><u>random</u>",
                          -1);
      g_free (str);
    }
    
}

gboolean change_random (gpointer data)
{
  gint i;
  GtkTreeIter iter;
  GtkListStore *model;
  
  g_return_if_fail (data != NULL);
  g_return_if_fail (GTK_IS_LIST_STORE (data));
  
  model = GTK_LIST_STORE (data);

  i = gtk_tree_model_iter_n_children (GTK_TREE_MODEL(model), NULL);

  if (i > 0)
    {
      gchar *str = g_strdup_printf ("[<b>%i</b> %p]", count++, data);
      gtk_tree_model_iter_nth_child (GTK_TREE_MODEL(model), &iter, NULL,
                                     g_rand_int_range (rng, 0, i));
                              
      gtk_list_store_set (GTK_LIST_STORE (model), &iter,
                          2, str,
                          3, "This <action id='changed'>row</action> was <big>changed</big>",
                          -1);
      g_free (str);
    }
    
}

gboolean remove_random (gpointer data)
{
  gint i;
  GtkTreeIter iter;
  GtkListStore *model;
  
  g_return_if_fail (data != NULL);
  g_return_if_fail (GTK_IS_LIST_STORE (data));
  
  model = GTK_LIST_STORE (data);

  i = gtk_tree_model_iter_n_children (GTK_TREE_MODEL(model), NULL);

  if (i > 0)
    {
      gtk_tree_model_iter_nth_child (GTK_TREE_MODEL(model), &iter, NULL,
                                     g_rand_int_range (rng, 0, i));
      gtk_list_store_remove (GTK_LIST_STORE (model), &iter);
    }
    
}


gboolean remove_first (gpointer data)
{
  GtkTreeIter iter;
  GtkListStore *model;
  
  g_return_if_fail (data != NULL);
  g_return_if_fail (GTK_IS_LIST_STORE (data));
  
  model = GTK_LIST_STORE (data);

  if (gtk_tree_model_get_iter_first (GTK_TREE_MODEL (model), &iter))
    {
      gtk_list_store_remove (GTK_LIST_STORE (model), &iter);
    }
  else
    {
      gtk_widget_destroy (win);
      gtk_main_quit ();
      return FALSE;
    }

  return TRUE;
}

gboolean switch_model (gpointer data)
{
  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW (data));
/*  
  g_print ("Swithcing to model %p\n", model1);  
*/
  g_object_set (G_OBJECT(data), "model", model1, NULL);

  g_timeout_add (1000, (GSourceFunc) switch_model2, data);
  
  return FALSE;
}

gboolean switch_model2 (gpointer data)
{
  g_return_if_fail (data != NULL);
  g_return_if_fail (SCW_IS_VIEW (data));
/*
  g_print ("Swithcing to model %p\n", model2);  
*/
  g_object_set (G_OBJECT(data), "model", model2, NULL);
  
  g_timeout_add (1000, (GSourceFunc) switch_model, data);
  return FALSE;
}


int main (int argc, char **argv)
{
  int i;
  GtkWidget *widget;
  GtkWidget *sw;
  GtkTreeIter iter;
  GtkTreeIter iter2;
 
  count = 0;
  rng = g_rand_new ();
  
/*
  g_log_set_always_fatal (G_LOG_LEVEL_WARNING | G_LOG_LEVEL_CRITICAL);
*/ 
  gtk_init (&argc, &argv);
  gtk_rc_parse_string ("style \"test\" "
                       "{ "
                       "ScwView::alternate-row-colors = 1 "
                       "ScwView::row-padding = 2 "
                       "ScwView::column-spacing = 10 "
                       "text[NORMAL] = \"#303030\" "
                       "text[ACTIVE] = \"#000000\" "
                       "text[SELECTED] = \"#000000\" "
                       "text[PRELIGHT] = \"#5050ff\" "
                       "base[NORMAL] = \"#FFFFFF\" "
                       "base[SELECTED] = \"#ded3d6\" "
                       "} class \"ScwView\" style \"test\" ");

  win = GTK_WIDGET (g_object_new (GTK_TYPE_WINDOW, NULL));
  gtk_widget_set_size_request (win, 400, 200);

  model1 = GTK_TREE_MODEL (gtk_list_store_new (4,
                                              SCW_TYPE_TIMESTAMP,
                                              GDK_TYPE_PIXBUF,
                                              SCW_TYPE_PRESENCE,
                                              G_TYPE_STRING));
  model2 = GTK_TREE_MODEL (gtk_list_store_new (4,
                                              SCW_TYPE_TIMESTAMP,
                                              GDK_TYPE_PIXBUF,
                                              SCW_TYPE_PRESENCE,
                                              G_TYPE_STRING));

  widget = GTK_WIDGET (g_object_new (SCW_TYPE_VIEW,
                                    "model", model1,
                                    "align-presences", TRUE,
                                    "presence-alignment", PANGO_ALIGN_LEFT,
                                    "scroll-on-append", TRUE,
                                    NULL));

  sw = GTK_WIDGET (g_object_new (GTK_TYPE_SCROLLED_WINDOW,
                                 "hadjustment", NULL,
                                 "vadjustment", NULL,
                                 "hscrollbar-policy", GTK_POLICY_NEVER,
                                 "vscrollbar-policy", GTK_POLICY_AUTOMATIC,
                                  NULL));

  gtk_container_add (GTK_CONTAINER (sw), widget); 

  g_signal_connect (G_OBJECT (widget), "activate",
                    G_CALLBACK (on_activated), NULL);
  g_signal_connect (G_OBJECT (win), "delete-event",
                    G_CALLBACK (delete_win), NULL);
  gtk_container_add (GTK_CONTAINER (win), sw);
  gtk_widget_show_all (win);

  for (i = 0; i < ITEM_COUNT;i++)
    {
      append_one (model1);
      while (gtk_events_pending ())
    	  gtk_main_iteration ();      
    }

  for (i = 0; i < ITEM_COUNT;i++)
    {
      prepend_one (model1);
      while (gtk_events_pending ())
    	  gtk_main_iteration ();      
    }

  for (i = 0; i < ITEM_COUNT;i++)
    {
      insert_random (model1);
      while (gtk_events_pending ())
    	  gtk_main_iteration ();      
    }
  for (i = 0; i < ITEM_COUNT*3;i++)
    {
      remove_random (model1);
      while (gtk_events_pending ())
    	  gtk_main_iteration ();      
    }

  return (0);
}
