/*
 * Farsight Voice+Video library
 *  Copyright 2006 Collabora Ltd, 
 *  Copyright 2006 Nokia Corporation
 *   @author: Philippe Khalaf <philippe.khalaf@collabora.co.uk>.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright notice,
 *     this list of conditions and the following disclaimer in the documentation
 *     and/or other materials provided with the distribution.
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF 
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <talk/base/thread.h>
#include <talk/base/physicalsocketserver.h>
#include <talk/base/network.h>
#include <talk/base/socketaddress.h>
#include <talk/p2p/base/socketmanager.h>
#include <talk/p2p/base/helpers.h>
#include <talk/p2p/client/basicportallocator.h>
#include <talk/p2p/client/httpportallocator.h>

#include <iostream>

#include "socketclient.h"

SocketClient::SocketClient(SocketAddress *stun_addr,
        SocketAddress *turn_addr)
{
    HttpPortAllocator *hpa;

    socket = NULL;
    sigl1 = NULL;
    sigl2 = NULL;

    cricket::InitRandom("boo", 3);

    worker_thread = new cricket::Thread();

    network_manager = new cricket::NetworkManager();

    hpa = new cricket::HttpPortAllocator(network_manager, "farsight-libjingle");

    if (stun_addr) {
        std::vector<cricket::SocketAddress> stun_hosts;
        stun_hosts.push_back (*stun_addr);
        hpa->SetStunHosts (stun_hosts);
    }

    if (turn_addr) {
        std::vector<std::string> relay_hosts;
        relay_hosts.push_back (turn_addr->IPAsString());
        hpa->SetRelayHosts (relay_hosts);
    }

    port_allocator = hpa;

    SessionManager *manager =
        new cricket::SessionManager(port_allocator, worker_thread);
    socket_manager = new cricket::SocketManager(manager);

    socket_manager->SignalRequestSignaling.connect(this,
            &SocketClient::OnRequestSignaling);

    worker_thread->Start();

    //socket_manager->SignalState.connect(this, &SocketClient::OnSocketState);
}

SocketClient::~SocketClient()
{
    delete socket_manager;
    delete port_allocator;
    delete network_manager;
    delete worker_thread;
}

void SocketClient::OnSocketRead(P2PSocket *socket, const char *data, size_t len)
{
    //std::cout << "Got packet!!!" << socket << std::endl;
}

void SocketClient::CreateSocket(const std::string &name)
{
    /* TODO attach a SocketMonitor to this socket */
    socket = socket_manager->CreateSocket(name);

    socket->SignalReadPacket.connect(this, &SocketClient::OnSocketRead);
    socket_manager->OnSignalingReady();
}

void SocketClient::SetRelayToken(const std::string &relay_token)
{
    HttpPortAllocator *hpa = (HttpPortAllocator *) port_allocator;
    hpa->SetRelayToken(relay_token);
}


void SocketClient::OnRequestSignaling() {
    std::cout << "OnRequestsignaling called, sending SignalingReady" << std::endl;
    socket_manager->OnSignalingReady();
}
