/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin <romaxa@gmail.com>
 *
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include <stdio.h>
#include "gtkmozembedmarshal.h"
#include "gtkmozembed_prompter.h"
#include "GtkPrompterService.h"
#include "nsIGenericFactory.h"

// class and instance initialization

guint moz_prompter_signals[EMBED_PROMPT_LAST_SIGNAL] = { 0 };

static void gtk_moz_prompter_class_init (GtkMozPrompterClass *klass);
static void gtk_moz_prompter_init (GtkMozPrompter *prompter);
static void gtk_moz_prompter_finalize (GObject *object);
static GtkMozPrompter *gtk_moz_prompter_new ();


static GObjectClass *parent_class = NULL;

// GObject + class-related functions

GType
gtk_moz_prompter_get_type (void)
{
  static GType moz_prompter_type = 0;
  if (moz_prompter_type == 0)
  {
    const GTypeInfo our_info =
    {
      sizeof (GtkMozPrompterClass),
      NULL, /* base_init */
      NULL, /* base_finalize */
      (GClassInitFunc) gtk_moz_prompter_class_init,
      NULL,
      NULL, /* class_data */
      sizeof (GtkMozPrompter),
      0, /* n_preallocs */
      (GInstanceInitFunc) gtk_moz_prompter_init,
    };

    moz_prompter_type = g_type_register_static (G_TYPE_OBJECT,
                                               "GtkMozPrompter",
                                               &our_info,
                                               (GTypeFlags)0);
  }

  return moz_prompter_type;
}

void gtk_moz_prompter_init (GtkMozPrompter *prompter)
{
  return;
}

GtkMozPrompter *
gtk_moz_prompter_new ()
{
  return GTK_MOZ_PROMPTER(g_object_new(GTK_TYPE_MOZ_PROMPTER, NULL));
}

GtkMozPrompter *
gtk_moz_prompter_get(void)
{
  static GtkMozPrompter *singleton_object = nsnull;
  if (!singleton_object)
  {
      singleton_object = gtk_moz_prompter_new();
  }

  return singleton_object;
}

// GObject methods
void
gtk_moz_prompter_finalize (GObject *object)
{
  //GtkMozPrompter * prompter = GTK_MOZ_PROMPTER(object);

  G_OBJECT_CLASS (parent_class)->finalize (object);
}

void
gtk_moz_prompter_class_init(GtkMozPrompterClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  parent_class = G_OBJECT_CLASS(g_type_class_peek_parent (klass));
  object_class->finalize = gtk_moz_prompter_finalize;

  moz_prompter_signals[ALERT] =
    g_signal_new ("alert",
                  G_TYPE_FROM_CLASS (klass),
                  G_SIGNAL_RUN_FIRST,
                  G_STRUCT_OFFSET(GtkMozPrompterClass, alert),
                  NULL, NULL,
                  gtkmozembed_microb_VOID__POINTER_STRING_STRING_BOOLEAN_STRING_POINTER,
                  G_TYPE_NONE, 6,
                  G_TYPE_POINTER,
                  G_TYPE_STRING,
                  G_TYPE_STRING,
                  G_TYPE_BOOLEAN,
                  G_TYPE_STRING,
                  G_TYPE_POINTER);
  moz_prompter_signals[CONFIRM] =
    g_signal_new ("confirm",
                  G_TYPE_FROM_CLASS (klass),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET(GtkMozPrompterClass, confirm),
                  NULL, NULL,
                  gtkmozembed_microb_BOOLEAN__POINTER_STRING_STRING_STRING_POINTER,
                  G_TYPE_BOOLEAN, 5,
                  G_TYPE_POINTER,
                  G_TYPE_STRING,
                  G_TYPE_STRING,
                  G_TYPE_STRING,
                  G_TYPE_POINTER);
  moz_prompter_signals[CONFIRM_EX] =
    g_signal_new ("confirm_ex",
                  G_TYPE_FROM_CLASS (klass),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET(GtkMozPrompterClass, confirm_ex),
                  NULL, NULL,
                  gtkmozembed_microb_INT__POINTER_STRING_STRING_UINT_STRING_STRING_STRING_STRING_POINTER,
                  G_TYPE_INT, 9,
                  G_TYPE_POINTER,
                  G_TYPE_STRING,
                  G_TYPE_STRING,
                  G_TYPE_UINT,
                  G_TYPE_STRING,
                  G_TYPE_STRING,
                  G_TYPE_STRING,
                  G_TYPE_STRING,
                  G_TYPE_POINTER);
  moz_prompter_signals[PROMPT] =
    g_signal_new ("prompt",
                  G_TYPE_FROM_CLASS (klass),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET(GtkMozPrompterClass, prompt),
                  NULL, NULL,
                  gtkmozembed_microb_BOOLEAN__POINTER_STRING_STRING_POINTER_STRING_POINTER,
                  G_TYPE_BOOLEAN, 6,
                  G_TYPE_POINTER,
                  G_TYPE_STRING,
                  G_TYPE_STRING,
                  G_TYPE_POINTER,
                  G_TYPE_STRING,
                  G_TYPE_POINTER);
  moz_prompter_signals[PROMPT_AUTH] =
    g_signal_new ("prompt_auth",
                  G_TYPE_FROM_CLASS (klass),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET(GtkMozPrompterClass, prompt_auth),
                  NULL, NULL,
                  gtkmozembed_microb_BOOLEAN__POINTER_STRING_STRING_POINTER_POINTER_STRING_POINTER,
                  G_TYPE_BOOLEAN, 7,
                  G_TYPE_POINTER,
                  G_TYPE_STRING,
                  G_TYPE_STRING,
                  G_TYPE_POINTER,
                  G_TYPE_POINTER,
                  G_TYPE_STRING,
                  G_TYPE_POINTER);
  moz_prompter_signals[SELECT] =
    g_signal_new ("select",
                  G_TYPE_FROM_CLASS (klass),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET(GtkMozPrompterClass, select),
                  NULL, NULL,
                  gtkmozembed_microb_BOOLEAN__POINTER_STRING_STRING_POINTER_POINTER,
                  G_TYPE_BOOLEAN, 5,
                  G_TYPE_POINTER,
                  G_TYPE_STRING,
                  G_TYPE_STRING,
                  G_TYPE_POINTER,
                  G_TYPE_POINTER);

  moz_prompter_signals[COOKIE_DIALOG] =
    g_signal_new ("cookie_dialog",
                  G_TYPE_FROM_CLASS (klass),
                  G_SIGNAL_RUN_LAST,
                  G_STRUCT_OFFSET(GtkMozPrompterClass, cookie_dialog),
                  NULL, NULL,
                  gtkmozembed_microb_VOID__POINTER_POINTER_POINTER_ULONG_STRING_STRING_STRING_STRING_STRING,
                  G_TYPE_NONE, 9,
                  G_TYPE_POINTER,
                  G_TYPE_POINTER,
                  G_TYPE_POINTER,
                  G_TYPE_ULONG,
                  G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                  G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                  G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                  G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE,
                  G_TYPE_STRING | G_SIGNAL_TYPE_STATIC_SCOPE);
}
