/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin <romaxa@gmail.com>
 *
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef gtkmozembed_common2_h
#define gtkmozembed_common2_h

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include <stddef.h>
#include <gtk/gtk.h>
#include "gtkmozembed.h"

#ifdef MOZILLA_CLIENT
#include "nscore.h"
#else /* MOZILLA_CLIENT */
#ifndef nscore_h__
/* Because this header may be included from files which not part of the mozilla
   build system, define macros from nscore.h */

#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 3)
#define NS_HIDDEN __attribute__((visibility("hidden")))
#else
#define NS_HIDDEN
#endif

#define NS_FROZENCALL
#define NS_EXPORT_(type) type
#define NS_IMPORT_(type) type
#endif /* nscore_h__ */
#endif /* MOZILLA_CLIENT */

#ifdef XPCOM_GLUE

#define GTKMOZEMBED_API(type, name, params) \
  typedef type (NS_FROZENCALL * name##Type) params; \
  extern name##Type name NS_HIDDEN;

#else /* XPCOM_GLUE */

#ifdef _IMPL_GTKMOZEMBED
#define GTKMOZEMBED_API(type, name, params) NS_EXPORT_(type) name params;
#else
#define GTKMOZEMBED_API(type,name, params) NS_IMPORT_(type) name params;
#endif

#endif /* XPCOM_GLUE */

/** @struct GtkWebHistoryItem.                                                                                                                      
 *  Defines a web history item.                                                                                                                     
 */
//typedef struct _GtkMozHistoryItem GtkMozHistoryItem;
//struct _GtkMozHistoryItem
//{
//  const gchar *title;   /** < URL title */
//  const gchar *url;	    /** < URL */
//  long accessed;        /** < The last time that the URL was accessed */
//};

GTKMOZEMBED_API(gboolean,      gtk_moz_common_microb_init,        (void))
GTKMOZEMBED_API(gboolean,      gtk_moz_common_microb_stop,        (void))
GTKMOZEMBED_API(gint,          gtk_moz_common_get_shistory_list,   (GtkMozEmbed *embed, GtkMozHistoryItem **GtkHI, guint type))
GTKMOZEMBED_API(gint,          gtk_moz_common_get_shistory_index,  (GtkMozEmbed *embed))
GTKMOZEMBED_API(void,          gtk_moz_common_shistory_goto_index, (GtkMozEmbed *embed, gint index))
GTKMOZEMBED_API(gboolean,      gtk_moz_common_get_server_cert,     (GtkMozEmbed *embed, gpointer *cert, gpointer ctx))
GTKMOZEMBED_API(gboolean,      gtk_moz_common_clipboard,           (GtkMozEmbed *embed, guint action))
GTKMOZEMBED_API(gboolean,      gtk_moz_common_load_image,          (gpointer node, const char *url))

typedef enum
{
  GTK_MOZ_COMMON_BACK_SHISTORY,
  GTK_MOZ_COMMON_FORWARD_SHISTORY,
  GTK_MOZ_COMMON_ALL_SHISTORY
} GtkMozSessionHistory;

typedef enum
{
  GTK_MOZ_CLIPBOARD_SELECT_ALL,
  GTK_MOZ_CLIPBOARD_CUT,
  GTK_MOZ_CLIPBOARD_COPY,
  GTK_MOZ_CLIPBOARD_PASTE,
  GTK_MOZ_CLIPBOARD_CAN_CUT,
  GTK_MOZ_CLIPBOARD_CAN_PASTE,
  GTK_MOZ_CLIPBOARD_CAN_COPY
} GtkMozClipboardAction;

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* gtkmozembed_common2_h */
