/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Christopher Blizzard.
 * Portions created by the Initial Developer are Copyright (C) 2001
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Christopher Blizzard <blizzard@mozilla.org>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
/**
 * Derived from GContentHandler http://landfill.mozilla.org/mxr-test/gnome/source/galeon/mozilla/ContentHandler.h
 */
#ifndef __EmbedDownloadMgr_h
#define __EmbedDownloadMgr_h

#include "EmbedPrivate.h"
#include "nsIHelperAppLauncherDialog.h"
#include "nsIMIMEInfo.h"
#include "nsCOMPtr.h"
#include "nsIExternalHelperAppService.h"
#include "nsIRequest.h"
#include "nsILocalFile.h"
#include "nsIIncrementalDownload.h"
#include "nsIRequestObserver.h"

#ifdef MOZ_XPINSTALL
#include "nsIXPIDialogService.h"
#endif
#include "nsIObserverService.h"

#include "nsWeakReference.h"
#include "nsIObserver.h"
#define EMBED_DOWNLOADMGR_DESCRIPTION "MicroB Download Manager"
#define EMBED_DOWNLOADMGR_CID {0x53df12a2, 0x1f4a, 0x4382, {0x99, 0x4e, 0xed, 0x62, 0xcf, 0x0d, 0x6b, 0x3a}}

class nsIURI;
class nsIFile;
class nsIFactory;
class nsExternalAppHandler;

class EmbedDownload
{
public:
  EmbedDownload();
  ~EmbedDownload();
  GtkObject*  parent;
  GtkWidget*  gtkMozEmbedParentWidget;/** Associated gtkmozembed widget */

  /* Pointer to mozilla interfaces */
  nsCOMPtr <nsIHelperAppLauncher> launcher;    /** < The mozilla's download dialog */
  nsCOMPtr <nsIIncrementalDownload> incr_launcher;
  nsIRequest* request;               /** < The download request */
  PRBool isCanceled;
};

class EmbedDownloadMgr :
#ifdef MOZ_XPINSTALL
                         public nsIXPIDialogService,
#endif
                         public nsIHelperAppLauncherDialog
{
  public:
    EmbedDownloadMgr();
    virtual ~EmbedDownloadMgr();

    NS_DECL_ISUPPORTS
    NS_DECL_NSIHELPERAPPLAUNCHERDIALOG
#ifdef MOZ_XPINSTALL
    NS_DECL_NSIXPIDIALOGSERVICE
    static void GetEMLocalizedString (const nsAString & key, nsAString & aResult,
                                      PRBool aFormatted = PR_FALSE,
                                      const PRUnichar ** aFormatArgs = nsnull,
                                      PRUint32 aFormatArgsLength = 0);
    static void GetXILocalizedString (const nsAString & key, nsAString & aResult,
                                      PRBool aFormatted = PR_FALSE,
                                      const PRUnichar ** aFormatArgs = nsnull,
                                      PRUint32 aFormatArgsLength = 0);
#endif
    static nsresult CreateIncrementalDownload(const char *aUrl, const char *aDestination, PRBool aHidden = PR_FALSE);
    static nsresult CreateIncrementalDownload(EmbedDownload *download);

  private:
    /** Gets all informations about a file which is being downloaded.
    */
    NS_METHOD GetDownloadInfo(nsIHelperAppLauncher *aLauncher, nsISupports *aContext);

    EmbedDownload *mDownload;
    nsCOMPtr < nsIDOMWindow > mParentWindow;
};

// {8b330507-5666-4f17-b9ff-f35fe09d5b70}                                                                                                                                                            
#define NS_EMBED_DOWNLOAD_CID \
{ 0x8b330507, 0x5666, 0x4f17, { 0xb9, 0xff, 0xf3, 0x5f, 0xe0, 0x9d, 0x5b, 0x70} }

#define NS_EMBED_DOWNLOAD_CONTRACTID "@browser/components-installer;1"

#ifdef MOZ_RDF
class EmbedDownloadObserver : public nsIObserver
{
  public:
    NS_DECL_ISUPPORTS
    NS_DECL_NSIOBSERVER

    static NS_METHOD Create (nsISupports * aOuter, REFNSIID aIID,
                             void **aResult);

    static NS_METHOD RegisterSelf (nsIComponentManager * aCompMgr,
                                   nsIFile * aPath,
                                   const char *aLoaderStr,
                                   const char *aType,
                                   const nsModuleComponentInfo * aInfo);
    static NS_METHOD UnregisterSelf(nsIComponentManager* aCompMgr,                                                                                                      
                                    nsIFile* aPath, const char *aLoaderStr,                                                                                                         
                                    const nsModuleComponentInfo *aInfo);

    NS_DEFINE_STATIC_CID_ACCESSOR (NS_EMBED_DOWNLOAD_CID)
  private:

    EmbedDownloadObserver ();
    ~EmbedDownloadObserver ();
    
    nsresult FindUpdates(const PRUnichar *aData);
    nsresult UninstallComponent(const PRUnichar *aData);

    nsresult Init ();
};
#endif

#endif /* __EmbedDownloadMgr_h */
