/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 tw=80 et cindent: */
/*
 * ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Mozilla browser.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Oleg Romashin.
 * Portions created by the Initial Developer are Copyright (C) 2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Oleg Romashin <romaxa@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
#ifndef EmbedContextMenuInfo2_h__
#define EmbedContextMenuInfo2_h__

#include "nsCOMPtr.h"
#include "nsStringGlue.h"
#include "gtkmozembed_context.h"

class nsIDOMEvent;
class nsIDOMNode;
class nsIDOMWindow;
class nsIDOMDocument;
class nsIDOMViewCSS;
class imgIRequest;
class nsIURI;

//*****************************************************************************
// class EmbedContextMenuInfo2
//
//*****************************************************************************
class EmbedContextMenuInfo2 : public nsISupports
{
public:
  EmbedContextMenuInfo2 (GtkMozContext *ctx, const void *aEmbed = nsnull);
  virtual ~EmbedContextMenuInfo2 (void);

  NS_DECL_ISUPPORTS

  nsresult UpdateContextData (nsIDOMEvent *aDOMEvent);
  nsresult GetContextText (nsAString &aString, PRBool aSelection = PR_TRUE, PRInt32 *aSelStart = nsnull);
  nsresult GetJSHandledInfo (nsIDOMEvent *aEvent, PRInt32 *aIsJSHandled = nsnull);
  nsresult InsertTextToNode (nsIDOMNode *aDOMNode, nsAString &aString, PRInt32 surr1, PRInt32 surr2);
  nsresult GetCSSBackground   (nsIDOMNode *node, nsAString& url);

// Utils
  static nsresult CheckDomImageElement (nsIDOMNode *node, nsString& aHref, PRInt32 &aWidth, PRInt32 &aHeight, PRUint32 *aSize = nsnull);
  static nsresult GetImageRequest (imgIRequest **aRequest, nsIDOMNode *aDOMNode);
  static nsresult ScrollToSelectedNode(nsISupports *element);

  nsCOMPtr<nsIDOMNode>       mEventNode;

private:

  nsresult SetFramePosition(void);
  nsresult CheckRichEdit(void);
  nsresult CheckFormControl(nsIDOMNode* aNode = nsnull);
  nsresult CheckDomHtmlNode(nsIDOMNode* aNode, PRBool &aHasImage);
  nsresult GetEventData ();
  nsresult ResolveBaseURL     (const nsAString &relurl, nsACString &url);
  nsresult SetIntProperty     (const char *name, int value);
  nsresult SetStringProperty  (const char *name, const char *value);
  nsresult SetStringProperty  (const char *name, const nsAString &value);

  GtkMozContext              *mCtx;
  const void                 *mEmbed;

  nsCOMPtr<nsIDOMEvent>      mCtxEvent;
  nsCOMPtr<nsIDOMNode>       mOrigNode;
  nsCOMPtr<nsIDOMViewCSS>    mViewCSS;
  nsCOMPtr<nsIURI>           mBaseURI;

  nsCOMPtr<nsIDOMDocument>   mCtxDocument;

  PRUint32                   mCtxFormType;

  PRUint32                   mIsScrollableElement;
  PRUint32                   mIsJSHandledElement;
  nsCOMPtr<nsIDOMNode>       mInsertNode;

}; // class EmbedContextMenuInfo2

#endif // EmbedContextMenuInfo2_h__
