/*
 * include/asm-arm/arch-omap/tlv320aic33.h
 *
 * Copyright (C) 2006 Nokia Corporation.
 *
 * Contact: Eero Nurkkala
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef __TLV320AIC33_H
#define __TLV320AIC33_H

#include <sound/driver.h>
#include <sound/core.h>
#include <linux/i2c.h>

#define SIZE_REG_CACHE		100
#define SIZE_IGAIN_CACHE	8 /* input level control registers 17-24 */

enum aic33_micbias {
	AIC33_MICBIAS_OFF,
	AIC33_MICBIAS_2V,
	AIC33_MICBIAS_2V5,
	AIC33_MICBIAS_AVDD,
};

enum aic33_dmic_rate {
	AIC33_DMIC_DISABLED,
	AIC33_DMIC_OVERSAMPLING_128,
	AIC33_DMIC_OVERSAMPLING_64,
	AIC33_DMIC_OVERSAMPLING_32,
};

/* digital mic configuration */
struct aic33_dmic_data {
	enum aic33_dmic_rate	dmic_rate;

	/* set if dmic needs bias voltage from AIC33 */
	unsigned		needs_bias:1;
	enum aic33_micbias	dmic_bias;
};

/* high-power output configuration */
struct aic33_hp_data {
	unsigned		ac_coupled:1;
	unsigned		pd_tri_stated:1;
};

enum aic33_adc_hp_filter {
	AIC33_ADC_HP_DISABLED,
	AIC33_ADC_HP_0_0045xFS,	/* 0.0045 x Fs */
	AIC33_ADC_HP_0_0125xFs,	/* 0.0125 x Fs */
	AIC33_ADC_HP_0_025xFs,	/* 0.025 x Fs */
};

struct aic33 {
	struct mutex	mutex;

	struct		i2c_client client;

	int		(*enable_clock)(struct device *dev);
	void		(*disable_clock)(struct device *dev);

	int		(*platform_init)(struct device *dev);
	void		(*platform_cleanup)(struct device *dev);

	void		(*ext_hp_amplifier_ctrl)(struct device *dev, int on);
	void		(*ext_lo_amplifier_ctrl)(struct device *dev, int on);

	unsigned	adc_enabled:1;
	unsigned	dac_enabled:1;
	unsigned	dmic_enabled:1;

	struct aic33_dmic_data	*dmic_data;

	/* register cache */
	u8		cache[SIZE_REG_CACHE];

	/*
	 * we need separate gain cache for input level control registers since
	 * the same bits are used both for gain value (0-8) and mute (0xf) and
	 * we need to restore gain value when unmuting
	 */
	u8		igain_cache[SIZE_IGAIN_CACHE];
};

struct aic33_platform_data {
	void		(*codec_reset)(int reset_active);
	int		(*codec_init)(struct device *aic33_dev);
	void		(*codec_cleanup)(struct device *aic33_dev);
	int		(*enable_clock)(struct device *dev);
	void		(*disable_clock)(struct device *dev);

	void		(*ext_hp_amplifier_ctrl)(struct device *dev, int on);
	void		(*ext_lo_amplifier_ctrl)(struct device *dev, int on);

	unsigned	pll_p;
	unsigned	pll_r;
	unsigned	pll_j;
	unsigned	pll_d;

	/* bit and word clock directions */
	unsigned	bclk_output:1;
	unsigned	wclk_output:1;

	enum aic33_adc_hp_filter	adc_hp_filter;

	/* digital mic configuration. NULL if not used */
	struct aic33_dmic_data		*dmic_data;
	/* high-power output configuration. NULL if not used */
	struct aic33_hp_data		*hp_data;
};

extern void aic33_mixer_set_power(struct device *dev, int dac, int adc);
extern int aic33_mixer_register_controls(struct device *dev,
					 struct snd_card *card);
extern int aic33_enable_mclk(struct device *dev);
extern void aic33_disable_mclk(struct device *dev);

#endif
