/*
 * pc2400m_if.h
 *
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Jouni Lappi <jouni.lappi@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_IF_H
#define PC2400M_IF_H

#include <linux/netdevice.h>
#include <linux/spi/spi.h>
#include <linux/list.h>
#include <linux/workqueue.h>
#include <linux/wireless.h>
#include <linux/spinlock.h>

#define PC2400M_DRV_IF_USE_DEPRECAT
#define MAX_WIMAX_SCAN_RESULTS 20
#define VERSION_STR_LEN 20

enum ifstatus {
        UNINITIALIZED,
        INIT_DONE,
	CONNECTED,

};
enum wmx_error_code {
	No_error,
	Remote_disconnection,
	OOZ,
	HW_Failure
};
struct pc2400m_complete_struct {
	struct completion comp;
	int pc2400m_result;
};

/* macro for wimax commands send to driver */
#define WIMAX_WAIT_CMD(_device, _cmd) \
	pc2400m_com_lock(_device); \
	pc2400m_driver_if->wimax_cmd(_device, _cmd, &pc2400m_complete); \
	pc2400m_com_unlock(); \
	wait_for_completion(&pc2400m_complete.comp); 

#define WIMAX_NO_WAIT_CMD(_device,_cmd) \
	pc2400m_com_lock(_device); \
	pc2400m_driver_if->wimax_cmd(_device, _cmd, NULL); \
	pc2400m_com_unlock(); 

#define WIMAX_NO_LOCK_CMD(_device,_cmd) \
	pc2400m_driver_if->wimax_cmd(_device, _cmd, NULL); \

#define WIMAX_WAIT_RSP \
	struct pc2400m_complete_struct pc2400m_complete;\
	init_completion(&pc2400m_complete.comp);


struct socket;

/* hold the device interface data specific to our particular
   piece of hardware. will hold all relevant status information
   specific to one interface, spinlocks, etc */
struct net_local {
	
	struct net_device_stats stats; /* regular net device statistics */

	struct iw_statistics wstats;   /* wireless extensions statistics */

	/* for maintaining a list of devices */
	struct list_head listelem;

	/* pointers to linked device structures */
	struct net_device *net_dev;
#ifndef CONFIG_NET_PC2400M_SIM
	struct spi_device *spi_dev;
#else
	struct platform_device *spi_dev;
#endif
	/* SPI transaction data */
	struct work_struct spi_work;
	void *spi_msg;
	void (*complete_cb)(struct net_device*, s32, void*);
	void *cb_data;
	s32  spi_total;

	/* interrupt handling */
	int irq_gpio;
	struct work_struct irq_work;
	void (*irq_cb)(struct net_device*);

	/* chipset power management */
	int power_gpio;
	int reset_gpio;

#ifdef CONFIG_NET_PC2400M_SIM
	/* simulator socket reference */
	struct socket *sock;
	struct socket *indsock;
#endif

	unsigned long irq_flags;
	spinlock_t irq_lock;

	/* client data pointer for the driver */
	void *driver_priv;

	/* temporary scan buffer */
	int   event_stream_len;
	int   event_stream_maxlen;
	char *event_stream;
	
	/* work queue for data sending */
	struct work_struct tx_work;
	struct sk_buff *tx_buff;

	unsigned long tx_flags;
	spinlock_t tx_lock;
	u32 tx_credit;

	/* radio state */
	int radio_disabled;

	/* current network connection */
	u32 nap;
	u8  quality;

	/* temporary buffer for prod_test file */
	u32 pt_len;
	char *pt_buffer;
	/* this used for storing return value for waiting function */
	/* tubes_pid */
	u32 tube1_pid;
	u32 tube2_pid;
	u32 tube3_pid;
        char fw_vrs[VERSION_STR_LEN];
        char hw_vrs[VERSION_STR_LEN];
        u8 cinr;
        char *bsid;
        u8 nsp_name_len;
        u8 nsp_realm_len;
	char *p_nsp_name;
	char *p_nsp_realm;
	u32 nsp_id;
        enum ifstatus  if_status;
	enum wmx_error_code errcod;

};

extern struct net_device *pc2400m_if_new_device(void);
extern int pc2400m_if_init_device(struct net_device *dev);
extern void pc2400m_if_free_device(struct net_device *dev_pc2400m);
extern void pc2400m_if_suspend_device(struct net_device *dev_pc2400m);
extern void pc2400m_if_resume_device(struct net_device *dev_pc2400m);

extern struct wimax_driver_if *pc2400m_driver_if;

#endif /* PC2400M_IF_H */
