/*
 * pc2400m_drv_sllist.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_TRACE_ENABLE
#define PC2400M_TRACE_ENABLE ON
#endif

/* trace groups, and trace identifiers */

RES_BEGIN(WIMAX_OSAL_AUTOGEN_RESOURCE_TRC_WIMAX, AUTOGEN_NO_RESOURCE_ID,
           WIMAXDD, "WIMAX Driver Traces", "", FALSE )

/* CHIPSET group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_CHIPSET, "Chipset", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_UNSOLICITED, 
		    "Unsolicited")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* SPI INFO group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_SPI_INFO, "SPI", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_FW_DL, 
		    "Firmware download")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* SPI DEBUG group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_SPI_DEBUG, "SPI", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_FW_BLOCK_ADDRESS,
		    "Firmware block address")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_FW_BLOCK_SIZE,
		    "Firmware block size")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* SPI ERROR group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_SPI_ERROR, "SPI", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_INIT_ERR,         
		    "Initialization failure")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_FW_DL_RETRY,
		    "Retrying firmware download")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_FW_DL_FAIL,
		    "Firmware download failed")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_FW_INVALID,
		    "Firmware file invalid")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_FW_JUMPING,
		    "Jumping to address")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_TX_CMD_FAIL,
		    "Transmit command fail")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_RX_CMD_FAIL,
		    "Receive command fail")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_NOT_FULL_BLOCKS,
		    "Transmit not full blocks")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_OUT_OF_DATA,
		    "Out of data in read")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CORRUPT_XFER_HDR,
		    "Corrupt transfer header")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_RX_SYNC_LOST,
		    "Rx sequence number mismatch")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_RX_EMPTY,
		    "Rx empty transaction")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_DEVICE_REBOOT,
		    "Device reboot detected")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CMD0_ERROR,
		    "CMD0 response error")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CMD52_ERROR,
		    "CMD52 response error")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_FAKE_IRQ,
		    "Fake interrupt")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_UNSET_IRQ_FLAG,
		    "Interrupt flag not set")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_TEST_ERR,
		    "Test error")
TRACE_GROUP_END()

/* WIHAL DEBUG group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_WIHAL_DEBUG, "WIHAL", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_DRIVER_UNLOADED,
		 "Device driver successfully unloaded")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_WIHAL_CTRL,
		    "WiHAL control message")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* WIHAL ERROR group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_WIHAL_ERROR, "WiHAL", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_UNKNOWN_CMD,
		    "Unknown command")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_DRIVER_INIT_FAIL, 
		    "Driver initialization failed")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_DROPPED_PACKET,
		    "Recv buffer overflow")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_LINK_DOWN,
		    "Link down, data dropped")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* EAP INFO group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_EAP_INFO, "EAP", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_MSK_SET,
		    "EAP MSK set")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_ALT_ACCEPT_IGN,
		    "EAP ALT ACCEPT ignored")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* EAP DEBUG group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_EAP_DEBUG, "EAP", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_MSK_RECVD,
		    "EAP MSK received")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_EAP_REQ,
		    "EAP request")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_EAP_RESP,
		    "EAP response")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* EAP ERROR group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_EAP_ERROR, "EAP", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_MSK_NOT_RECVD,    
		    "EAP MSK not received in due time")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* CONTROL DISPATCHER ERROR group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_CD_ERROR, "CD", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_UNKNOWN_FRAME,
		    "Unrecognized frame type")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_UNKNOWN_TYPE,     
		    "Discarded unknown indication")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_MSG_TIMEOUT,
		    "Command response timeout")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_QUEUE_FAILED,     
		    "Failed to queue control message")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_PKT_DISCARDED,    
		    "No handler for incoming data")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* DEVICE MANAGER INFO group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_DM_INFO, "DM", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_CHIP_ASIC_VER,
		    "Hardware")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_BOARD_VER,
		    "RF")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_FW_VER,
		    "Firmware")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_L1_VER,
		    "L1")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_L2_VER,
		    "L2")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_L3_VER,
		    "L3")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_MAC_ADDR,
		    "MAC Address")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_LINK_STATE,
		    "Link status")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* DEVICE MANAGER DEBUG group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_DM_DEBUG, "DM", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_RF_CONTROL_RADIO_ON,
		    "RF control radio enabled")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_RF_CONTROL_RADIO_OFF,
		    "RF control radio disabled")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_START_SCAN,
		    "Scanning started")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_STOP_SCAN,
		    "Scanning stopped")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CONNECTING,
		    "Connecting started")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_TRANSITION_START,
		    "Starting transition")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_ST_CH_REASON, 
		    "State change reason")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_ST_CH_STATE,
		    "State change state")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_L4M_VERSION,
		    "Reported L4M version")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_DM_STATE_CHANGE,
		    "DM State change")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_DM_BS_CRITERIA,
		    "DM BS ID criteria")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_DM_BS_CRITERIA_MASK, 
		    "DM BS ID criteria mask")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_CONNECT_PROG, 
		    "Chipset connection progress")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

/* DEVICE MANAGER ERROR group */
TRACE_GROUP_BEGIN(PC2400M_GROUP_DM_ERROR, "DM", PC2400M_TRACE_ENABLE)
        TRACE_BEGIN(PC2400M_TRACE_REQUEST_FAILED,
		    "Request failed with status")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_INVALID_DM_STATE, 
		    "Invalid state for transition")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_UNEXP_END_STATE,
		    "Unexpected end state for transition")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_UNEXP_RESP,
		    "Unexpected command response")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_UNEXP_STATE_IND,
		    "Unexpected chipset state change")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_TRANS_TOUT,
		    "Transition timed out")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CHIP_EXP_TLV_MISSING,
		    "Expected TLV missing")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_UNKNOWN_SCAN_STATUS,
		    "Unknown scan status received")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_TOO_MANY_SEARCH_LIMITS,
		    "Too many search limits, truncating")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_UNKNOWN_STATUS_IN_INIT,
		    "Unknown status while initializing")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_UNKNOWN_STATUS_IN_TERMINATE,
		    "Unknown status while terminating")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_UNABLE_TO_INITIALIZE,
		    "Chip initialization failure")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_CANNOT_GO_PRODUCTION,
		    "Cannot switch to production mode")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_HW_RF_SWITCH_OFF,
		    "HW RF Switch off")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_VERSION_NOTE,
		    "Firmware note")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
        TRACE_BEGIN(PC2400M_TRACE_UNSUPPORTED_VERSION,
		    "Unsupported firmware interface")
                WIMAX_OSAL_AUTOGEN_TRACE_INFO
        TRACE_END()
TRACE_GROUP_END()

RES_END
