/*
 * pc2400_drv_spi.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_DRV_SPI_H
#define PC2400M_DRV_SPI_H

#include "pc2400m_drv_com.h"
#include "pc2400m_drv_hdi.h"
#include "pc2400m_drv_ring.h"

struct pc2400m_trans_elem {
	void* packet;
	s32 type;
};

struct pc2400m_drv_hdi_spi_if {

	/* inherit HDI stuff */
	struct pc2400m_drv_hdi_if hdi;

	/* IRQ callback */
	pc2400m_hdi_int_cb irq_cb;
	
	/* SPI queue */
	u32 rx_seq;
	u32 tx_seq;
	Q_DECLARE(rx_q, struct pc2400m_trans_elem, PC2400M_TRANS_Q_SIZE);
	Q_DECLARE(tx_q, struct pc2400m_trans_elem, PC2400M_TRANS_Q_SIZE);
	u32 tx_q_len;
	u8 spi_data[PC2400M_DATA_SIZE+2]; /* 2 = sizeof struct R_5 */

};


#endif /* PC2400M_DRV_SPI_H */
