/*
 * pc2400m_drv_sdio.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */



#ifndef PC2400M_DRV_SDIO_H
#define PC2400M_DRV_SDIO_H


typedef enum {
        d2h     = 0,
        h2d     = 1
} e_read_write;

typedef enum {
        func0   = 0,
        func1   = 1
} e_func_num;

struct R_1 {
	union {
		struct {
			u8 idle_state:1;
			u8 erase_reset:1;
			u8 illegal_cmd:1;
			u8 com_crc_err:1;
			u8 erase_seq_err:1;
			u8 addr_err:1;
			u8 parameter_err:1;
			u8 zero:1;
		} bits;
		u8 as_u8;
	} u;
	u8 pad;
	u8 pad2;
	u8 pad3;
};

struct MOD_R_1 {
	union {
		struct {
			u8 idle_state:1;
			u8 zero1:1;
			u8 illegal_cmd:1;
			u8 com_crc_err:1;
			u8 func_num_err:1;
			u8 zero0:1;
			u8 parameter_err:1;
			u8 start:1;
		} bits;
		u8 as_u8;
	} u;
};

#pragma pack(push,1)
struct R_4 {
	union {
		struct {
			struct MOD_R_1 R1;
			u8 memory_present:1;
			u8 stuff_bits:3;
			u8 num_of_io_fct:3;
			u8 card_bit:1;
			u8 io_ocr2;
			u8 io_ocr1;
			u8 io_ocr0;	
		} bits;
		u8 as_u8[5];
	} u;
	u8 pad;
	u8 pad2;
	u8 pad3;
};
#pragma pack(pop)

struct CMD_52 {
	union {
		struct {
			u32 data:8;
			u32 reserved1:1;
			u32 address:17;
			u32 reserved2:1;
			u32 read_after_write:1;
			u32 function:3;
			u32 write_to_device:1;
		} bits;
		u32 as_u32;
	} u;
};

struct CMD_53 {
	union {
		struct {
			u32 count:9;
			u32 address:17;
			u32 opcode:1;
			u32 blockmode:1;
			u32 function:3;
			u32 write_to_device:1;
		} bits;
		u32 as_u32;
	} u;
};

struct R_5 {
	union {
		struct {
			struct MOD_R_1 r1;
			u8 read_data:8;
		} bits;
		u16 as_u16;
	} u;
	u8 pad;
	u8 pad2;
};
#define R_5_SIZE    2

struct SPI_DATA_R {
	union {
		struct {
			u8 end:1;
			u8 status:3;
			u8 zero:1;
			u8 dont_c:3;
		} bits;
		u8 as_u8;
	} u;
};


#pragma pack(push,1)
struct SD_CMD {
	u8 command_index:6;
	u8 direction:1;
	u8 start_bit:1;
	u32 argument:32;
	u8 end_bit:1;
	u8 crc7:7;
};
#pragma pack(pop)

struct pc2400m_drv_hdi_if;

extern s32 pc2400m_drv_send_cmd0(struct pc2400m_drv_hdi_if *hnd);
extern u32 pc2400m_drv_send_cmd5(struct pc2400m_drv_hdi_if *hnd, u32 ocr, 
				 struct R_4* r4);
extern s32 pc2400m_drv_send_cmd52(struct pc2400m_drv_hdi_if *hnd,
				  unsigned address,
				  u8 data,
				  e_read_write read_write,
				  e_func_num func_num);
extern s32 pc2400m_drv_send_write_cmd53(struct pc2400m_drv_hdi_if *hnd,
					unsigned byte_block_count,
					unsigned address,
					u8 *data, 
					u32 len);
extern s32 pc2400m_drv_send_read_cmd53(struct pc2400m_drv_hdi_if *hnd,
				       unsigned byte_block_count,
				       unsigned address,
				       u8 *data, 
				       u32 len);
#endif /* PC2400M_DRV_SDIO_H */
