/*
 * pc2400m_drv_com.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


#ifndef PC2400M_DRV_COM_H
#define PC2400M_DRV_COM_H

#include "pc2400m_osal.h"
#include "pc2400m_osal_trace.h"
#include "pc2400m_drv_if.h"
#include "pc2400m_drv_ring.h"
#include "pc2400m_drv_chipif.h"

/* boolean values */
#ifndef FALSE
#define FALSE 0
#endif /* FALSE */

#ifndef TRUE
#define TRUE 1
#endif /* TRUE */

/* internal status codes */
/* reuse kernel codes - additional ones here */
/* EIO
   MISSING: the rest */
/* "sababa" is hebrew, and means "cool" or "ok" */
#define ESABABA     0

/* frame types for SPI transaction */
#define FRAME_TYPE_DATA            0x0
#define FRAME_TYPE_CONTROL         0x1
#define FRAME_TYPE_TRACE_INFO      0x2

#define PC2400M_BLOCK_SIZE         256
#define PC2400M_MAX_NUM_OF_BLOCKS  64
#define PC2400M_START_ARASAN       1
#define PC2400M_MAX_TRANSACTION    (PC2400M_MAX_NUM_OF_BLOCKS * \
                                    PC2400M_BLOCK_SIZE)
#define PC2400M_GAP                1
#define PC2400M_SDIO_CMD_SIZE      6
#define PC2400M_CMD_SIZE           (PC2400M_START_ARASAN + \
                                    PC2400M_SDIO_CMD_SIZE + PC2400M_GAP)
#define PC2400M_BLOCK_EXCESS       40
#define PC2400M_DATA_SIZE          (PC2400M_MAX_NUM_OF_BLOCKS * \
		                    (PC2400M_BLOCK_SIZE + \
                                     PC2400M_BLOCK_EXCESS))
#define PC2400M_DESCRIPTOR_SIZE    4
#define PC2400M_TRANSPORT_HDR_SIZE 16
#define PC2400M_MAX_DESCRIPTORS    60
#define PC2400M_HDR_SIZE           (PC2400M_TRANSPORT_HDR_SIZE + \
                                    PC2400M_DESCRIPTOR_SIZE * \
                                    PC2400M_MAX_DESCRIPTORS)
#define PC2400M_MAX_PAYLOAD        (PC2400M_MAX_TRANSACTION - PC2400M_HDR_SIZE)

#define PC2400M_FRAME_PAD          16

#define PC2400M_TRANS_Q_SIZE       (PC2400M_MAX_DESCRIPTORS+1) /* One wasted */

struct pc2400m_drv_dm_if;

typedef void (*drv_send_system_state_ind_fnc)(wimax_osal_context*, 
					      enum drv_system_state);
typedef void (*drv_send_network_status_ind_fnc)(wimax_osal_context*,
					    enum drv_network_status,
					    enum drv_status,
					    u8 *bs_id,
					    u8);
typedef void (*drv_send_search_ind_fnc)(wimax_osal_context*, u8, u32*, u8*);
typedef void (*drv_send_search_resp_fnc)(wimax_osal_context*, enum drv_status);

struct pc2400m_private;
typedef void (*drv_unref_cb)(wimax_osal_context*, void*);
typedef void (*drv_ref_fnc)(struct pc2400m_private*);
typedef void (*drv_unref_fnc)(struct pc2400m_private*);
typedef void (*drv_unref_data_fnc)(struct pc2400m_private*, drv_unref_cb, 
				   void*);

struct pc2400m_private {

	/* function interface */
	drv_send_network_status_ind_fnc send_network_status_ind;
	drv_send_system_state_ind_fnc send_system_state_ind;
	drv_send_search_ind_fnc send_search_ind;
	drv_send_search_resp_fnc send_search_resp;

        drv_ref_fnc ref;
        drv_unref_fnc unref;
        drv_unref_data_fnc unref_data;

	/* subsystem instance pointers */
	void *ctx;
	struct pc2400m_drv_dm_if *dm;
	struct pc2400m_drv_dm_if *dm_old;

	/* data credit counter */
	u32 send_credit;

	/* receive ring definition */
	int recv_polled;
	wimax_osal_packet_list pkt_list;

	/* EAP msk storage */
	u8 msk[L3L4_MSK_LENGTH];
#define PC2400M_DRV_MSK_FLAG_VALID   0x01
#define PC2400M_DRV_MSK_FLAG_REQD    0x02
	u8 msk_flags;
#define PC2400M_DRV_MSK_REQ_TIMEOUT  1000000 /* microseconds */
	s32 msk_req_timer;

	/* driver mode flags */
#define PC2400M_DRV_COM_PROD_TEST_MODE 0x00000001
	u32 mode_flags;

	/* reference counter */
        u32 ref_cnt;
        drv_unref_cb unref_cb;
        void *unref_cb_data;

};

#endif /* PC2400M_DRV_COM_H */
