/*
 * pc2400m_drv_chipif.h
 *
 * Copyright (C) 2007 Nokia Corporation
 * Author: Juuso Oikarinen <juuso.oikarinen@nokia.com>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 */


 
#ifndef PC2400M_DRV_CHIPIF_H
#define PC2400M_DRV_CHIPIF_H


/* supported message versions */
struct L3L4SupportedVersion {
        u16 major;
        u16 minor;
        u16 branch;
        u8 *note;
};

#define L3L4_SUPPORTED_VERSIONS \
        { \
	        {0x0002, 0x0000, 0x0000, "Production testing only!"}, \
		{0x0003, 0x0000, 0x0000, NULL}, \
		{0xffff, 0xffff, 0xfffe, "Testing"}, \
		{0xffff, 0xffff, 0xffff, NULL}, \
		{0x0001, 0x0006, 0x0002, "DSim simulator"} \
	};

/* control message header definitions */
#define L3L4_VERSION         0x00
#define L3L4_ACCESSIBILITY   0x00

/* message status codes */
enum L3L4ResponseStatus {
	L3L4_RESPONSE_STATUS_SUCCESS_DONE = 0x00,
	L3L4_RESPONSE_STATUS_SUCCESS_IN_PROCESS,
	L3L4_RESPONSE_STATUS_INVALID_OPCODE,
	L3L4_RESPONSE_STATUS_ERROR_BAD_STATE,
	L3L4_RESPONSE_STATUS_ILLEGAL_VALUE,
	L3L4_RESPONSE_STATUS_MISSING_PARAMS,
	L3L4_RESPONSE_STATUS_VERSION_ERROR,
	L3L4_RESPONSE_STATUS_ACCESSIBILITY_ERROR,
	L3L4_RESPONSE_STATUS_BUSY,
	L3L4_RESPONSE_STATUS_CORRUPTED_TLV,
	L3L4_RESPONSE_STATUS_UNINITIALIZED,
	L3L4_RESPONSE_STATUS_UNKNOWN_ERROR,
	L3L4_RESPONSE_STATUS_PRODUCTION_ERROR,	
};

enum L3L4ReportStateReason {
        L3L4_REPORT_STATE_REASON_NORMAL    = 0x01,
        L3L4_REPORT_STATE_REASON_FAIL_TO_CONNECT_TO_NW,
        L3L4_REPORT_STATE_REASON_FAIL_TO_CONNECT_DATA_PATH
};


/* chipset states */
enum L3L4SystemState {
        L3L4_SYSTEM_STATE_UNINITIALIZED = 0x01,
        L3L4_SYSTEM_STATE_INIT,
        L3L4_SYSTEM_STATE_READY,
        L3L4_SYSTEM_STATE_SCAN,
        L3L4_SYSTEM_STATE_STANDBY,
        L3L4_SYSTEM_STATE_CONNECTING,
        L3L4_SYSTEM_STATE_WIMAX_CONNECTED,
        L3L4_SYSTEM_STATE_DATA_PATH_CONNECTED,
        L3L4_SYSTEM_STATE_IDLE,
        L3L4_SYSTEM_STATE_DISCONNECTING,
        L3L4_SYSTEM_STATE_OUT_OF_ZONE,
        L3L4_SYSTEM_STATE_SLEEP_ACTIVE,
        L3L4_SYSTEM_STATE_PRODUCTION,
        L3L4_SYSTEM_STATE_CONFIG,
	L3L4_SYSTEM_STATE_RF_OFF,
	L3L4_SYSTEM_STATE_RF_SHUTDOWN,
};

/* scan commands */
enum L3L4ScanCommand {
        L3L4_SCAN_COMMAND_START    = 0x01,
        L3L4_SCAN_COMMAND_STOP
};

enum L3L4Bandwidth {
	L3L4_BANDWIDTH_NA = 0x00,
        L3L4_BANDWIDTH_3_5,
        L3L4_BANDWIDTH_5,
        L3L4_BANDWIDTH_7,
        L3L4_BANDWIDTH_8_75,
        L3L4_BANDWIDTH_10
};

enum L3L4Fft{
	L3L4_FFT_NA = 0x00,
        L3L4_FFT_512,
        L3L4_FFT_1024
};

enum L3L4ScanStatus {
        L3L4_SCAN_STATUS_DONE = 0x01,
        L3L4_SCAN_STATUS_SCANING,
        L3L4_SCAN_STATUS_FAILURE,
        L3L4_SCAN_STATUS_STOPPED
};

enum L3L4ConnectProgress {
	L3L4_CONNECT_PROGRESS_RANGING = 0x01,
	L3L4_CONNECT_PROGRESS_SBC,
	L3L4_CONNECT_PROGRESS_EAP_AUTHENTICATION,
	L3L4_CONNECT_PROGRESS_3_WAY_HANDSHAKE,
	L3L4_CONNECT_PROGRESS_REGISTRATION,
};

enum L3L4MediaStatus {
        L3L4_MEDIA_STATUS_LINK_UP   = 0x01,
        L3L4_MEDIA_STATUS_LINK_DOWN
};

enum L3L4RfStatus {
        L3L4_RF_STATUS_ON    = 0x01,
        L3L4_RF_STATUS_OFF
};

enum L3L4ModeOfOperation {
	L3L4_MODE_OF_OPERATION_NORMAL = 0x01,
	L3L4_MODE_OF_OPERATION_PRODUCTION,
};

enum L3L4EapKeyValid {
	L3L4_EAP_KEY_VALID_VALID = 0x01,
	L3L4_EAP_KEY_VALID_INVALID,
};

enum L3L4RfSwitch {
        L3L4_RF_SWITCH_ON = 0x01,
        L3L4_RF_SWITCH_OFF,
};

/* opcode masks */
#define L3L4_INDICATION_MASK         (0x8000) 

/* module definitions */
#define L3L4_MODULE_ID_NDS           (0x4000)
#define L3L4_MODULE_ID_GENERAL       (0x5000)
#define L3L4_MODULE_ID_SUPPLICANT    (0x6000)
#define L3L4_MODULE_ID_PRODUCTION    (0x7000)

/* request types */
#define L3L4_REQUEST_TYPE_GET        (0x200)
#define L3L4_REQUEST_TYPE_SET        (0x400)
#define L3L4_REQUEST_TYPE_CMD        (0x600)


/* get opcodes */
#define L4_L3_OPCODE_GET_LM_VERSION  \
        (L3L4_MODULE_ID_GENERAL | L3L4_REQUEST_TYPE_GET | 0x1)
#define L4_L3_OPCODE_GET_DEVICE_INFO \
        (L3L4_MODULE_ID_GENERAL | L3L4_REQUEST_TYPE_GET | 0x2)

/* set opcodes */
#define L4_L3_OPCODE_SET_SCAN_PARAM  \
        (L3L4_MODULE_ID_NDS | L3L4_REQUEST_TYPE_SET | 0x2)
#define L4_L3_OPCODE_SET_EAP_SUCCESS  \
        (L3L4_MODULE_ID_SUPPLICANT | L3L4_REQUEST_TYPE_SET | 0x2)
#define L4_L3_OPCODE_SET_EAP_FAIL  \
        (L3L4_MODULE_ID_SUPPLICANT | L3L4_REQUEST_TYPE_SET | 0x3)
#define L4_L3_OPCODE_SET_EAP_KEY  \
        (L3L4_MODULE_ID_SUPPLICANT | L3L4_REQUEST_TYPE_SET | 0x4)

/* command opcodes */
#define L4_L3_OPCODE_CMD_RF_CONTROL  \
        (L3L4_MODULE_ID_NDS | L3L4_REQUEST_TYPE_CMD | 0x2)
#define L4_L3_OPCODE_CMD_SCAN  \
        (L3L4_MODULE_ID_NDS | L3L4_REQUEST_TYPE_CMD | 0x3)
#define L4_L3_OPCODE_CMD_CONNECT  \
        (L3L4_MODULE_ID_NDS | L3L4_REQUEST_TYPE_CMD | 0x4)
#define L4_L3_OPCODE_CMD_DISCONNECT  \
        (L3L4_MODULE_ID_NDS | L3L4_REQUEST_TYPE_CMD | 0x5)
#define L4_L3_OPCODE_CMD_INIT  \
        (L3L4_MODULE_ID_GENERAL | L3L4_REQUEST_TYPE_CMD | 0x1)
#define L4_L3_OPCODE_CMD_TERMINATE  \
        (L3L4_MODULE_ID_GENERAL | L3L4_REQUEST_TYPE_CMD | 0x2)
#define L4_L3_OPCODE_CMD_MODE_OF_OPERATION  \
        (L3L4_MODULE_ID_GENERAL | L3L4_REQUEST_TYPE_CMD | 0x3)
#define L4_L3_OPCODE_CMD_SEND_EAP_RESPONSE  \
        (L3L4_MODULE_ID_SUPPLICANT | L3L4_REQUEST_TYPE_CMD | 0x2)

/* indication opcodes */
#define L3_L4_OPCODE_REPORT_STATE  \
        (L3L4_INDICATION_MASK | L3L4_MODULE_ID_GENERAL | 0x2)
#define L3_L4_OPCODE_REPORT_SCAN_RESULT  \
        (L3L4_INDICATION_MASK | L3L4_MODULE_ID_NDS | 0x2)
#define L3_L4_OPCODE_REPORT_EAP_REQUEST  \
        (L3L4_INDICATION_MASK | L3L4_MODULE_ID_SUPPLICANT | 0x2)
#define L3_L4_OPCODE_REPORT_EAP_RESTART  \
        (L3L4_INDICATION_MASK | L3L4_MODULE_ID_SUPPLICANT | 0x3)
#define L3_L4_OPCODE_REPORT_ALT_ACCEPT  \
        (L3L4_INDICATION_MASK | L3L4_MODULE_ID_SUPPLICANT | 0x4)
#define L3_L4_OPCODE_REPORT_KEY_REQUEST  \
        (L3L4_INDICATION_MASK | L3L4_MODULE_ID_SUPPLICANT | 0x5)



/* TLV header */
struct L3L4_TLV_HDR_STR {
	u16 type;
	u16 length;
};
#define L3L4_TLV_HDR_LEN         (sizeof(struct L3L4_TLV_HDR_STR))

/* TLV definitions */
#define L3L4_TLV_TYPE_L4_MESSAGE_VERSION 129
struct L3L4_TLV_STR_L4_MESSAGE_VERSION {
	struct L3L4_TLV_HDR_STR tlv;
	u16 version_major;
	u16 version_minor;
	u16 version_branch;
	u16 reserved;
};
#define L3L4_TLV_SIZE_L4_MESSAGE_VERSION \
                            (sizeof(struct L3L4_TLV_STR_L4_MESSAGE_VERSION))


#define L3L4_TLV_TYPE_VERSIONS_STRINGS 130

#define L3L4_TLV_TYPE_MODE_OF_OPERATION 131
struct L3L4_TLV_STR_MODE_OF_OPERATION {
	struct L3L4_TLV_HDR_STR tlv;
	u32 mode;
};
#define L3L4_TLV_SIZE_MODE_OF_OPERATION \
                            (sizeof(struct L3L4_TLV_STR_MODE_OF_OPERATION))

#define L3L4_TLV_TYPE_DEVICE_DETAILS 140
struct L3L4_TLV_STR_DEVICE_DETAILS {
	struct L3L4_TLV_HDR_STR tlv;
        u32 model_type;
        u32 model_type_str_len;
#define L3L4_MODEL_TYPE_STR_LEN      124
        u8 model_type_str[L3L4_MODEL_TYPE_STR_LEN];
        u32 manufacturer_id;
        u32 manufacturer_id_str_len;
#define L3L4_MANUFACTURER_ID_STR_LEN 124
        u8 manufacturer_id_str[L3L4_MANUFACTURER_ID_STR_LEN];
        u32 serial_nbr_str_len;
#define L3L4_SERIAL_NBR_STR_LEN      124
        u8 serial_nbr_str[L3L4_SERIAL_NBR_STR_LEN];
#define L3L4_MAC_ADDR_LEN            6
	u8 mac_address[L3L4_MAC_ADDR_LEN];
	u8 reserved1;
	u8 reserved2;
};
#define L3L4_TLV_SIZE_DEVICE_DETAILS \
                            (sizeof(struct L3L4_TLV_STR_DEVICE_DETAILS))

#define L3L4_TLV_TYPE_SYSTEM_STATE 141
struct L3L4_TLV_STR_SYSTEM_STATE {
	struct L3L4_TLV_HDR_STR tlv;
	u32 state;
};
#define L3L4_TLV_SIZE_SYSTEM_STATE (sizeof(struct L3L4_TLV_STR_SYSTEM_STATE))

#define L3L4_TLV_TYPE_REPORT_STATE_REASON 150
struct L3L4_TLV_STR_REPORT_STATE_REASON {
	struct L3L4_TLV_HDR_STR tlv;
	u32 reason;
};
#define L3L4_TLV_SIZE_REPORT_STATE_REASON \
                            (sizeof(struct L3L4_TLV_STR_REPORT_STATE_REASON))


#define L3L4_TLV_TYPE_LINK_STATUS 160
struct L3L4_TLV_STR_LINK_STATUS {
	struct L3L4_TLV_HDR_STR tlv;
	u32  up_link_speed;
	u32  down_link_speed;
	u32  center_frequency;
	u32  tx_power;
	u32  rx_rssi;
	u32  rx_cinr;
#define L3L4_OPERATOR_ID_LEN 3
	u8   operator_id[L3L4_OPERATOR_ID_LEN];
	u8   link_quality;
};
#define L3L4_TLV_SIZE_LINK_STATUS (sizeof(struct L3L4_TLV_STR_LINK_STATUS))

#define L3L4_TLV_TYPE_MEDIA_STATUS 161
struct L3L4_TLV_STR_MEDIA_STATUS {
	struct L3L4_TLV_HDR_STR tlv;
	u32  media_status;
};
#define L3L4_TLV_SIZE_MEDIA_STATUS (sizeof(struct L3L4_TLV_STR_MEDIA_STATUS))



#define L3L4_TLV_TYPE_RF_OPERATION 162
struct L3L4_TLV_STR_RF_OPERATION {
	struct L3L4_TLV_HDR_STR tlv;
        u32  rf_operation;
};	
#define L3L4_TLV_SIZE_RF_OPERATION (sizeof(struct L3L4_TLV_STR_RF_OPERATION))

#define L3L4_TLV_TYPE_RF_SWITCHES_STATUS 163
struct L3L4_TLV_STR_RF_SWITCHES_STATUS {
        struct L3L4_TLV_HDR_STR tlv;
        u8 sw_rf_switch;
        u8 hw_rf_switch;
        u8 reserved1;
        u8 reserved2;
};
#define L3L4_TLV_SIZE_RF_SWITCHES_STATUS \
                               (sizeof(struct L3L4_TLV_STR_RF_SWITCHES_STATUS))

#define L3L4_TLV_TYPE_CHANNEL_INFO 181
struct L3L4_TLV_STR_CHANNEL_INFO {
	struct L3L4_TLV_HDR_STR tlv;
        u32  frequency;
        u32  max_tx_power;
        u16  channel_id;
        u8   bandwidth;
        u8   fft;
        u8   preambles[15];
        u8   reserved;
};
#define L3L4_TLV_SIZE_CHANNEL_INFO (sizeof(struct L3L4_TLV_STR_CHANNEL_INFO))



#define L3L4_TLV_TYPE_TH_CRITERIA 182
struct L3L4_TLV_STR_TH_CRITERIA {
	struct L3L4_TLV_HDR_STR tlv;
	u32 rssi;
	u32 cinr;
};
#define L3L4_TLV_SIZE_TH_CRITERIA (sizeof(struct L3L4_TLV_STR_TH_CRITERIA))


#define L3L4_TLV_TYPE_NETWORK_SCAN_RESULT 185
struct L3L4_TLV_STR_NETWORK_SCAN_RESULT {
	struct L3L4_TLV_HDR_STR tlv;
	u32  best_rssi;
        u8   network_id[3];
        u8   num_of_links;
};
#define L3L4_TLV_SIZE_NETWORK_SCAN_RESULT \
                              (sizeof(struct L3L4_TLV_STR_NETWORK_SCAN_RESULT))

#define L3L4_TLV_TYPE_SCAN_COMMAND 186
struct L3L4_TLV_STR_SCAN_COMMAND {
	struct L3L4_TLV_HDR_STR tlv;
	u32  do_scan_command;
};
#define L3L4_TLV_SIZE_SCAN_COMMAND (sizeof(struct L3L4_TLV_STR_SCAN_COMMAND))

#define L3L4_TLV_TYPE_SCAN_STATUS 187
struct L3L4_TLV_STR_SCAN_STATUS {
	struct L3L4_TLV_HDR_STR tlv;
	u32 scan_status;
};
#define L3L4_TLV_SIZE_SCAN_STATUS (sizeof(struct L3L4_TLV_STR_SCAN_STATUS))


#define L3L4_TLV_TYPE_BS_CRITERIA 190
struct L3L4_TLV_STR_BS_CRITERIA {
	struct L3L4_TLV_HDR_STR tlv;
        u8   bsid_criterion[6];
        u8   bsid_criterion_mask[6];
        u32  home_operator;
};
#define L3L4_TLV_SIZE_BS_CRITERIA (sizeof(struct L3L4_TLV_STR_BS_CRITERIA))

#define L3L4_TLV_TYPE_CONNECT_PROGRESS 191
struct L3L4_TLV_STR_CONNECT_PROGRESS {
	struct L3L4_TLV_HDR_STR tlv;
	u32  progress;
};
#define L3L4_TLV_SIZE_CONNECT_PROGRESS \
                             (sizeof(struct L3L4_TLV_STR_CONNECT_PROGRESS))

#define L3L4_TLV_TYPE_REPORT_EAP_REQUEST 1026
struct L3L4_TLV_STR_REPORT_EAP_REQUEST {
	struct L3L4_TLV_HDR_STR tlv;
	u16 length;
	u8 data; /* variable length data, up to 1600 bytes */
};
#define L3L4_TLV_SIZE_REPORT_EAP_REQUEST       (L3L4_TLV_HDR_LEN + sizeof(u16))

#define L3L4_TLV_TYPE_REPORT_EAP_RESPONSE 1027
struct L3L4_TLV_STR_REPORT_EAP_RESPONSE {
	struct L3L4_TLV_HDR_STR tlv;
	u16 length;
	u8 data; /* variable length data, up to 1600 bytes */
};
#define L3L4_TLV_SIZE_REPORT_EAP_RESPONSE      (L3L4_TLV_HDR_LEN + sizeof(u16))

#define L3L4_TLV_TYPE_SET_EAP_KEY_VALID 1028
struct L3L4_TLV_STR_SET_EAP_KEY_VALID {
	struct L3L4_TLV_HDR_STR tlv;
	u32 key_valid;
};
#define L3L4_TLV_SIZE_SET_EAP_KEY_VALID \
                             (sizeof(struct L3L4_TLV_STR_SET_EAP_KEY_VALID))

#define L3L4_TLV_TYPE_SET_EAP_KEY_MSK 1029
struct L3L4_TLV_STR_SET_EAP_KEY_MSK {
	struct L3L4_TLV_HDR_STR tlv;
#define L3L4_MSK_LENGTH 64
	u8 msk[L3L4_MSK_LENGTH];
};
#define L3L4_TLV_SIZE_SET_EAP_KEY_MSK \
                             (sizeof(struct L3L4_TLV_STR_SET_EAP_KEY_MSK))

 
/* Generic control message header */
struct pc2400m_drv_chipif_ctrl_msg {
	u16 type;
	u16 length;
	u16 version;
	u16 accessibility;
	u16 status;
	u16 reserved;
};
#define PC2400M_DRV_CHIPIF_CTRL_MSG_LEN (12)



#endif /* PC2400M_DRV_CHIPIF_H */
