/*
 * File: linux/drivers/cpufreq/cpufreq_null.c
 *
 * Copyright (C) 2007 Nokia Corporation.
 *
 * Klaus Pedersen <klaus.k.pedersen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */  

/*
 * The "null" governor is meant to be used as default during boot until
 * a proper governor is set from userspace.
 */

#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/cpufreq.h>
#include <linux/init.h>

#define dprintk(msg...) \
	cpufreq_debug_printk(CPUFREQ_DEBUG_GOVERNOR, "null", msg)

static int cpufreq_governor_null(struct cpufreq_policy *policy,
                                 unsigned int event)
{
	unsigned int f;

	switch (event) {
	case CPUFREQ_GOV_START:
	case CPUFREQ_GOV_LIMITS:
		f = policy->cur;
		dprintk("(re-)setting to %u kHz because of event %u\n",
                        f, event);
		__cpufreq_driver_target(policy, f, CPUFREQ_RELATION_L);
		break;
	default:
		break;
	}
	return 0;
}

struct cpufreq_governor cpufreq_gov_null = {
	.name		= "null",
	.governor	= cpufreq_governor_null,
	.owner		= THIS_MODULE,
};
EXPORT_SYMBOL(cpufreq_gov_null);

static int __init cpufreq_gov_null_init(void)
{
	return cpufreq_register_governor(&cpufreq_gov_null);
}

static void __exit cpufreq_gov_null_exit(void)
{
	cpufreq_unregister_governor(&cpufreq_gov_null);
}

MODULE_AUTHOR("Klaus Pedersen <klaus.k.pedersen@nokia.com");
MODULE_DESCRIPTION("CPUfreq policy governor 'null'");
MODULE_LICENSE("GPL");

fs_initcall(cpufreq_gov_null_init);
module_exit(cpufreq_gov_null_exit);
