/*
 * arch/arm/mach-omap/omap2/serial.c
 *
 * OMAP2 serial support.
 *
 * Copyright (C) 2005 Nokia Corporation
 * Author: Paul Mundt <paul.mundt@nokia.com>
 *
 * Based off of arch/arm/mach-omap/omap1/serial.c
 *
 * This file is subject to the terms and conditions of the GNU General Public
 * License. See the file "COPYING" in the main directory of this archive
 * for more details.
 */
#include <linux/kernel.h>
#include <linux/init.h>
#include <linux/serial_reg.h>
#include <linux/clk.h>
#include <linux/platform_device.h>
#include <linux/ioport.h>

#include <asm/io.h>

#include <asm/arch/serial.h>
#include <asm/arch/board.h>

static struct resource omap2_uart1_resources[] = {
	{
		.start		= OMAP_UART1_BASE,
		.end		= OMAP_UART1_BASE + 0x3ff,
		.flags		= IORESOURCE_MEM,
	}, {
		.start		= 72,
		.flags		= IORESOURCE_IRQ,
	}
};

static struct resource omap2_uart2_resources[] = {
	{
		.start		= OMAP_UART2_BASE,
		.end		= OMAP_UART2_BASE + 0x3ff,
		.flags		= IORESOURCE_MEM,
	}, {
		.start		= 73,
		.flags		= IORESOURCE_IRQ,
	}
};

static struct resource omap2_uart3_resources[] = {
	{
		.start		= OMAP_UART3_BASE,
		.end		= OMAP_UART3_BASE + 0x3ff,
		.flags		= IORESOURCE_MEM,
	}, {
		.start		= 74,
		.flags		= IORESOURCE_IRQ,
	}
};

static struct platform_device uart1_device = {
	.name			= "omap-uart",
	.id			= 1,
	.num_resources		= ARRAY_SIZE(omap2_uart1_resources),
	.resource		= omap2_uart1_resources,
};

static struct platform_device uart2_device = {
	.name			= "omap-uart",
	.id			= 2,
	.num_resources		= ARRAY_SIZE(omap2_uart2_resources),
	.resource		= omap2_uart2_resources,
};

static struct platform_device uart3_device = {
	.name			= "omap-uart",
	.id			= 3,
	.num_resources		= ARRAY_SIZE(omap2_uart3_resources),
	.resource		= omap2_uart3_resources,
};

static struct platform_device *uart_devices[] = {
	&uart1_device,
	&uart2_device,
	&uart3_device
};

void __init omap_serial_init(void)
{
	int i, r;
	const struct omap_uart_config *info;

	/*
	 * Make sure the serial ports are muxed on at this point.
	 * You have to mux them off in device drivers later on
	 * if not needed.
	 */

	info = omap_get_config(OMAP_TAG_UART,
			       struct omap_uart_config);
	if (info == NULL)
		return;

	for (i = 0; i < ARRAY_SIZE(uart_devices); i++) {
		if (!(info->enabled_uarts & (1 << i)))
			continue;
		r = platform_device_register(uart_devices[i]);
		if (r < 0)
			printk("Failed to register UART%d\n", i + 1);
	}

#if 0
		switch (i) {
		case 0:
			uart1_ick = clk_get(NULL, "uart1_ick");
			if (IS_ERR(uart1_ick))
				printk("Could not get uart1_ick\n");
			else {
				clk_enable(uart1_ick);
			}

			uart1_fck = clk_get(NULL, "uart1_fck");
			if (IS_ERR(uart1_fck))
				printk("Could not get uart1_fck\n");
			else {
				clk_enable(uart1_fck);
			}
			break;
		case 1:
			uart2_ick = clk_get(NULL, "uart2_ick");
			if (IS_ERR(uart2_ick))
				printk("Could not get uart2_ick\n");
			else {
				clk_enable(uart2_ick);
			}

			uart2_fck = clk_get(NULL, "uart2_fck");
			if (IS_ERR(uart2_fck))
				printk("Could not get uart2_fck\n");
			else {
				clk_enable(uart2_fck);
			}
			break;
		case 2:
			uart3_ick = clk_get(NULL, "uart3_ick");
			if (IS_ERR(uart3_ick))
				printk("Could not get uart3_ick\n");
			else {
				clk_enable(uart3_ick);
			}

			uart3_fck = clk_get(NULL, "uart3_fck");
			if (IS_ERR(uart3_fck))
				printk("Could not get uart3_fck\n");
			else {
				clk_enable(uart3_fck);
			}
			break;
		}

//		omap_serial_reset(p);
#endif
}
