/*
 * (C) Copyright 2005
 * Texas Instruments, <www.ti.com>
 *
 * (C) Copyright 2007 Nokia Corporation
 * Contact: Igor Stoppa <igor.stoppa@nokia.com>
 * Selective frequency scaling
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR /PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */
#ifndef __MACH_OMAP24XX_SCALE_H
#define __MACH_OMAP24XX_SCALE_H

/*Get the Base Address */
#ifdef CONFIG_ARCH_OMAP24XX
#include <asm/arch/omap24xx.h>
#elif CONFIG_ARCH_OMAP243X
#include <asm/arch/omap2430.h>
#else
#error "Unsupported configuration"
#endif


#define A_OMAP24XX_PRCM_BASE	IO_ADDRESS(OMAP24XX_PRCM_BASE)
#define A_PRCM_CLKCFG_CTRL	IO_ADDRESS(OMAP24XX_PRCM_BASE + 0x80)
#define PRCM_CLKCFG_CTRL_OFFS	(A_PRCM_CLKCFG_CTRL - A_OMAP24XX_PRCM_BASE)

#define OMAP24XX_CM_BASE	(OMAP24XX_PRCM_BASE + 0x500)
#define A_OMAP24XX_CM_BASE	IO_ADDRESS(OMAP24XX_CM_BASE)

#define A_CM_CLKEN_PLL		IO_ADDRESS(OMAP24XX_CM_BASE + 0x00)
#define CM_CLKEN_PLL_OFFS	(A_CM_CLKEN_PLL - A_OMAP24XX_CM_BASE)

#define A_CM_IDLEST_CKGEN	IO_ADDRESS(OMAP24XX_CM_BASE + 0x20)
#define CM_IDLEST_CKGEN_OFFS	(A_CM_IDLEST_CKGEN - A_OMAP24XX_CM_BASE)

#define A_CM_CLKSEL1_PLL	IO_ADDRESS(OMAP24XX_CM_BASE + 0x40)
#define CM_CLKSEL1_PLL_OFFS	(A_CM_CLKSEL1_PLL - A_OMAP24XX_CM_BASE)

#define A_CM_CLKSEL2_PLL	IO_ADDRESS(OMAP24XX_CM_BASE + 0x44)
#define CM_CLKSEL2_PLL_OFFS	(A_CM_CLKSEL2_PLL - A_OMAP24XX_CM_BASE)

#define A_OMAP24XX_SDRC_BASE	IO_ADDRESS(OMAP24XX_SDRC_BASE)

#define A_SDRC_DLLA_CTRL	IO_ADDRESS(OMAP24XX_SDRC_BASE + 0x60)
#define SDRC_DLLA_CTRL_OFFS	(A_SDRC_DLLA_CTRL - A_OMAP24XX_SDRC_BASE)

#define A_SDRC_DLLB_CTRL	IO_ADDRESS(OMAP24XX_SDRC_BASE + 0x68)
#define SDRC_DLLB_CTRL_OFFS	(A_SDRC_DLLB_CTRL - A_OMAP24XX_SDRC_BASE)

#define A_SDRC_RFR_CTRL0	IO_ADDRESS(OMAP24XX_SDRC_BASE + 0xA4)
#define SDRC_RFR_CTRL0_OFFS	(A_SDRC_RFR_CTRL0 - A_OMAP24XX_SDRC_BASE)

#define A_SDRC_RFR_CTRL1	IO_ADDRESS(OMAP24XX_SDRC_BASE + 0xD4)
#define SDRC_RFR_CTRL1_OFFS	(A_SDRC_RFR_CTRL1 - A_OMAP24XX_SDRC_BASE)

#define FREQ_SCALING_DOWN	0
#define FREQ_SCALING_UP		1

#define QUICK_PRESCALER_x1	1
#define QUICK_PRESCALER_x2	2

#endif
