/*
 * This file is part of functracer-postproc.
 *
 * Copyright (C) 2008 by Nokia Corporation
 *
 * Contact: Eero Tamminen <eero.tamminen@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef FTPRO_MAPS_H
#define FTPRO_MAPS_H

/* default type for addresses */
typedef unsigned long t_address;

#define LINE_MAX 256

/* map list node structure */
typedef struct t_map {
	t_address dyn_addr_init;
	t_address dyn_addr_end;
	char pathname[LINE_MAX];
	int is_absolute;

	struct t_map *next;
} t_map;

/* map list structure */
typedef struct t_maplist {
	struct t_map *first;
	struct t_map *last;
} t_maplist;

int maplist_init (t_maplist *maplist);
int maplist_is_empty (t_maplist *maplist);
int maplist_free (t_maplist *maplist);
int maplist_add (t_maplist *maplist, t_address dyn_addr_init,
		 t_address dyn_addr_end, char pathname[LINE_MAX]);
int read_map_file (t_maplist *maplist);

#endif /* FTPRO_MAPS_H */
