/*
 * This file is part of eds-sync
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Author: Ross Burton <ross@openedhand.com>
 * Author: Onne Gorter <onne.gorter@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib.h>
#include <stdlib.h>

#include "notification.h"
#include "eds-sync-marshal.h"

enum
{
  REPLY,

  LAST_SIGNAL
};

static guint context_signals[LAST_SIGNAL] = { 0, };

static void
eds_notify_context_base_init (gpointer g_iface)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      GType iface_type = G_TYPE_FROM_INTERFACE (g_iface);

      context_signals[REPLY] =
        g_signal_new ("reply",
                      iface_type,
                      G_SIGNAL_RUN_LAST,
                      G_STRUCT_OFFSET (EdsNotifyContextIface, reply),
                      NULL, NULL,
                      eds_sync_marshal_VOID__INT_BOOLEAN,
                      G_TYPE_NONE, 2,
                      G_TYPE_INT,
                      G_TYPE_BOOLEAN);
                      
      initialized = TRUE;
    }
}

GType
eds_notify_context_get_type (void)
{
  static GType iface_type = 0;

  if (G_UNLIKELY (iface_type == 0))
    {
      const GTypeInfo iface_info =
      {
        sizeof (EdsNotifyContextIface),  /* class_size */
        eds_notify_context_base_init, /* base_init */
        NULL,                         /* base_finalize */
      };

      iface_type = g_type_register_static (G_TYPE_INTERFACE,
                                           "EdsNotifyContext",
                                           &iface_info, 0);

      g_type_interface_add_prerequisite (iface_type, G_TYPE_OBJECT);
    }

  return iface_type;
}

gint
eds_sync_notify_auth_request (EdsNotifyContext *context,
                              gint              handle,
                              const gchar      *account,
                              const gchar      *name,
                              const gchar      *address,
                              const gchar      *message)
{
  g_return_val_if_fail (EDS_IS_NOTIFY_CONTEXT (context), -1);

  return EDS_NOTIFY_CONTEXT_GET_IFACE (context)->auth_request (context,
                                                               handle,
                                                               account,
                                                               name,
                                                               address,
                                                               message);
}

gint
eds_sync_notify_auth_response (EdsNotifyContext *context,
                               gint              handle,
                               const gchar      *account,
                               const gchar      *address,
                               const gchar      *message,
                               gboolean          is_accepted)
{
  g_return_val_if_fail (EDS_IS_NOTIFY_CONTEXT (context), -1);

  return EDS_NOTIFY_CONTEXT_GET_IFACE (context)->auth_response (context,
                                                                handle,
                                                                account,
                                                                address,
                                                                message,
                                                                is_accepted);
}

void
eds_sync_notify_cancel (EdsNotifyContext *context,
                        GArray           *ids)
{
  g_return_if_fail (EDS_IS_NOTIFY_CONTEXT (context));
  g_return_if_fail (ids != NULL);

  EDS_NOTIFY_CONTEXT_GET_IFACE (context)->cancel_operations (context, ids);
}
