/*
 * This file is part of eds-sync
 *
 * Copyright (C) 2007 Nokia Corporation. All rights reserved.
 *
 * Author: Ross Burton <ross@openedhand.com>
 * Author: Onne Gorter <onne.gorter@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

#ifndef _EDS_SYNC_H
#define _EDS_SYNC_H

#include <glib-object.h>

G_BEGIN_DECLS

/** Debugging flags*/
enum {
  DEBUG_EVENTS  = 1 << 0,
  DEBUG_HANDLES = 1 << 1,
  DEBUG_VERBOSE = 1 << 2,
  DEBUG_AVATARS = 1 << 3,
};

#define e_debug(f, x...) if (debug_flags & DEBUG_EVENTS) g_debug (G_STRLOC ": " f, ##x)
#define h_debug(f, x...) if (debug_flags & DEBUG_HANDLES) g_debug (G_STRLOC ": " f, ##x)
#define v_debug(f, x...) if (debug_flags & DEBUG_VERBOSE) g_debug (G_STRLOC ": " f, ##x)
#define a_debug(f, x...) if (debug_flags & DEBUG_AVATARS) g_debug (G_STRLOC ": " f, ##x)

/* The current debug state */
extern guint debug_flags;

/* error enumeration */
typedef enum {
  EDS_SYNC_ERROR_TELEPATHY,
  EDS_SYNC_ERROR_EDS,
  EDS_SYNC_ERROR_UNKNOWN
} EdsSyncError;

GQuark eds_sync_error_quark (void);
#define EDS_SYNC_ERROR  (eds_sync_error_quark ())

#define EDS_TYPE_SYNC                   (eds_sync_get_type ())
#define EDS_SYNC(obj)                   (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDS_TYPE_SYNC, EdsSync))
#define EDS_SYNC_CLASS(klass)           (G_TYPE_CHECK_CLASS_CAST ((klass), EDS_TYPE_SYNC, EdsSyncClass))
#define EDS_IS_SYNC(obj)                (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDS_TYPE_SYNC))
#define EDS_IS_SYNC_CLASS(klass)        (G_TYPE_CHECK_CLASS_TYPE ((klass), EDS_TYPE_SYNC))
#define EDS_SYNC_GET_CLASS(obj)         (G_TYPE_INSTANCE_GET_CLASS ((obj), EDS_TYPE_SYNC, EdsSyncClass))

typedef struct _EdsSync         EdsSync;
typedef struct _EdsSyncPrivate  EdsSyncPrivate;
typedef struct _EdsSyncClass    EdsSyncClass;

struct _EdsSync
{
  GObject parent_instance;

  EdsSyncPrivate *priv;
};

struct _EdsSyncClass
{
  GObjectClass parent_class;

  void (* avatar_updated) (EdsSync    *sync,
			   const char *account,
			   const char *token);
};

GType eds_sync_get_type (void) G_GNUC_CONST;

EdsSync* eds_sync_new (void);

gboolean eds_sync_handle_channel (EdsSync *sync,
                                  const gchar *bus_name,
                                  const gchar *object_path,
                                  const gchar *channel_type,
                                  const gchar *channel,
                                  guint handle_type,
                                  guint handle,
                                  GError **error);

void eds_sync_channel_closed (EdsSync *sync);

void eds_sync_signal_avatar_updated (EdsSync *sync,
				     const char *account,
				     const char *token);

G_END_DECLS

#endif /* _EDS_SYNC_H */
