/*
 * This file is part of cx3110x
 *
 * Copyright (C) 2003 Conexant Americas Inc. All Rights Reserved.
 * Copyright (C) 2004, 2005, 2006 Nokia Corporation
 *
 * Contact: Kalle Valo <Kalle.Valo@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef __SMOID2_H__
#define __SMOID2_H__
/*
    WARNING

    WARNING: This header file is automatically generated. Changes made to this 
    will be discarded when the file is generated from its source!
 */

/*
    MIB API
 */

/*
    Generic objects
 */

/*
    Device objects

    The device objects contain objects that configure the device's properties 
    example the MAC address, LED modes), reflect the device's state (for 
    link state) and UMAC version information, and configure generic UMAC properties.
 */

#define HAVE_DATA_MEMBER 1

/* UMAC Mode */
#define DOT11_MODE_CLIENT                       0x00
#define DOT11_MODE_AP                           0x01
#define MODE_PROMISCUOUS                        0x02


/* Offloadable operations */
#define OFFLOAD_WEP_ENCRYPT                     0x00000001
#define OFFLOAD_WEP_DECRYPT                     0x00000002
#define OFFLOAD_TKIP_ENCRYPT                    0x00000004
#define OFFLOAD_TKIP_DECRYPT                    0x00000008
#define OFFLOAD_MICHAEL_CALC                    0x00000010
#define OFFLOAD_CCMP_ENCRYPT                    0x00000020
#define OFFLOAD_CCMP_DECRYPT                    0x00000040


/* Debug Levels */
#define DEBUG_LEVEL_NONE                        0x00
#define DEBUG_LEVEL_FATAL                       0x01
#define DEBUG_LEVEL_ERROR                       0x02
#define DEBUG_LEVEL_WARNING                     0x04
#define DEBUG_LEVEL_INFO                        0x08
#define DEBUG_LEVEL_DEBUG                       0x10
#define DEBUG_LEVEL_ENTRY                       0x20
#define DEBUG_LEVEL_EXIT                        0x40
#define DEBUG_LEVEL_STATE                       0x80
#define DEBUG_LEVEL_ALL                         0xff


typedef struct obj_interfaceid
{
    uint16_t role;
    uint16_t if_id;
    uint16_t variant;
} obj_interfaceid;

typedef struct obj_debug
{
    uint8_t package;
    uint8_t level;
} obj_debug;

/* Device */
#define GEN_OID_MACADDRESS                      0x00000000
#define GEN_OID_LINKSTATE                       0x00000001
#define GEN_OID_LEDCONFIG                       0x00000005
#define GEN_OID_MODE                            0x00000006
#define GEN_OID_COMPONENT_NR                    0x00000007
#define GEN_OID_VERSION                         0x00000008
#define GEN_OID_INTERFACE_ID                    0x00000009
#define GEN_OID_COMPONENT_ID                    0x0000000a
#define GEN_OID_HIBERNATE                       0x0000000b
#define GEN_OID_FAA                             0x0000000c
#define GEN_OID_COMMIT                          0x0000000d
#define GEN_OID_OFFLOAD                         0x0000000e
#define GEN_OID_EFFECTIVETHROUGHPUT             0x0000000f
#define GEN_OID_DIRECTLINKSTATE                 0x0000000f
#define GEN_OID_RESET                           0x00000010
#define GEN_OID_INTRABSSRELAY                   0x00000011
#define GEN_OID_DEBUG                           0x00000012


/*
    Statistics objects

    The Statistics objects contain statistics of the device's behavior on MSDU 
    MPDU level statistics are available from implementation specific 
    group, for example the 802.11 MPDU statistics group.
 */

/* Statistics */
#define GEN_OID_MSDUTXSUCCESSFUL                0x01000000
#define GEN_OID_MSDUTXMULTICAST                 0x01000001
#define GEN_OID_MSDUTXDROPPED                   0x01000002
#define GEN_OID_MSDUTXFAILED                    0x01000003
#define GEN_OID_MSDURXSUCCESSFUL                0x01000004
#define GEN_OID_MSDURXMULTICAST                 0x01000005
#define GEN_OID_MSDURXDROPPED                   0x01000006
#define GEN_OID_MSDURXFAILED                    0x01000007


/*
    Miscellaneous objects
 */

/* Tunnel operations */
#define TUNNEL_OGET                             0
#define TUNNEL_OSET                             1
#define TUNNEL_ORESPONSE                        2
#define TUNNEL_OERROR                           3
#define TUNNEL_OTRAP                            4


/* Tunnel Operations */
#define TUNNEL_FRAW                             0x01
#define TUNNEL_FLE                              0x02


typedef struct obj_tunnel
{
    uint8_t version;
    uint8_t operation;
    uint8_t oid[4];
    uint8_t device_id;
    uint8_t flags;
    uint32_t length;
} obj_tunnel;

/* Miscellaneous */
#define GEN_OID_TUNNEL                          0x02000000


/*
    802.11 objects
 */

/*
    Service Set objects

    The Service Set objects configure the Basic Service Set properties like 
    of BSS, Service Set Identifier, etc... These objects determine the BSS's 
    when setting up a BSS or which BSS to join.
 */

/* BSS Types */
#define DOT11_BSSTYPE_NONE                      0
#define DOT11_BSSTYPE_INFRA                     1
#define DOT11_BSSTYPE_IBSS                      2
#define DOT11_BSSTYPE_ANY                       3


/* States */
#define DOT11_STATE_NONE                        0
#define DOT11_STATE_AUTHING                     1
#define DOT11_STATE_AUTH                        2
#define DOT11_STATE_ASSOCING                    3
#define DOT11_STATE_ASSOC                       5
#define DOT11_STATE_IBSS                        6
#define DOT11_STATE_WDS                         7
#define DOT11_STATE_DL                          8
#define DOT11_STATE_MCDL                        9


/* SSID Offsets */
#define DOT11_SSID_LENGTH                       0
#define DOT11_SSID_STRING                       1


/* VSS control bitmasks */
#define DOT11_VSS_MERGE                         0x00000001
#define DOT11_VSS_ANNOUNCE                      0x00000002


typedef struct obj_ssid
{
    uint8_t length;
    uint8_t octets[33];
    uint8_t pad[2];
} obj_ssid;

typedef struct obj_wpa
{
    uint16_t unicast;
    uint16_t multicast;
    uint16_t authtype;
    uint16_t capabilities;
} obj_wpa;

typedef struct obj_serviceset
{
    uint8_t bssid[6];
    uint16_t ext;
    obj_ssid ssid;
    uint32_t policies;
    uint16_t authenable;
    uint8_t privinvoked;
    uint8_t exunencrypted;
    obj_wpa wpa;
    obj_wpa rsn;
    uint16_t exclusive;
    uint16_t total;
    uint16_t associated;
    uint16_t pad1;
    uint32_t mc_msdu_tx;
    uint32_t mc_msdu_rx;
    uint64_t mc_octets_tx;
    uint64_t mc_octets_rx;
} obj_serviceset;

/* Service Set */
#define DOT11_OID_BSSTYPE                       0x10000000
#define DOT11_OID_BSSID                         0x10000001
#define DOT11_OID_SSID                          0x10000002
#define DOT11_OID_STATE                         0x10000003
#define DOT11_OID_AID                           0x10000004
#define DOT11_OID_SSIDOVERRIDE                  0x10000006
#define DOT11_OID_SERVICESET0                   0x10000008
#define DOT11_OID_VSSCONTROL                    0x10000109


/*
    Superframe objects

    The Superframe objects manage the superframe structure properties of the 
    The superframe is the structure of the period of time between two or more 
    Prominant properties are the beacon period and DTIM period. The superframe 
    determine (amongst others) the frequency of broadcast delivery and power 
    efficiency of clients.
 */

typedef struct obj_sequential
{
    uint16_t frequency;
    uint8_t ssid[34];
    uint16_t timeslice;
    uint16_t mcast_window;
} obj_sequential;

/* Superframe */
#define DOT11_OID_BEACONPERIOD                  0x11000001
#define DOT11_OID_DTIMPERIOD                    0x11000002
#define DOT11_OID_ATIMWINDOW                    0x11000003
#define DOT11_OID_LISTENINTERVAL                0x11000004
#define DOT11_OID_SEQUENTIALBSS                 0x11000007


/*
    Security objects

    The Security objects configure the authentication and privacy aspects of 
    BSS. Note that security mechanisms like WPA and CCX rely on external 
    that handle the high-layer aspects of the security mechanism.
 */

/* Authentication Enable */
#define DOT11_AUTH_NONE                         0x0000
#define DOT11_AUTH_OS                           0x0001
#define DOT11_AUTH_SK                           0x0002
#define DOT11_AUTH_BOTH                         0x0003


/* Authentication Algorithm */
#define DOT11_AUTHALG_NONE                      0
#define DOT11_AUTHALG_OS                        1
#define DOT11_AUTHALG_SK                        2
#define DOT11_AUTHALG_LEAP                      3
#define DOT11_AUTHALG_WPA                       4
#define DOT11_AUTHALG_WPAPSK                    5
#define DOT11_AUTHALG_WPANONE                   6
#define DOT11_AUTHALG_CCKM                      7
#define DOT11_AUTHALG_WPA2                      8
#define DOT11_AUTHALG_WPA2PSK                   9


/* 802.11 Authentication Algorithm Number */
#define DOT11_AUTHALGNR_OS                      0x00
#define DOT11_AUTHALGNR_SK                      0x01
#define DOT11_AUTHALGNR_LEAP                    0x80


/* Privacy Invoked */
#define DOT11_PRIV_INV_NONE                     0
#define DOT11_PRIV_INV_WEP                      1
#define DOT11_PRIV_INV_WEP40                    1
#define DOT11_PRIV_INV_TKIP                     2
#define DOT11_PRIV_INV_AES_CCMP                 3
#define DOT11_PRIV_INV_WEP128                   4
#define DOT11_PRIV_INV_ENABLE                   1




/* Privacy Key Type */
#define DOT11_PRIV_WEP                          0
#define DOT11_PRIV_TKIP                         1
#define DOT11_PRIV_CCX_KP                       2
#define DOT11_PRIV_CCX_KP_MIC                   3
#define DOT11_PRIV_CCX_MIC                      4
#define DOT11_PRIV_AES_CCMP                     5
#define DOT11_PRIV_KRK                          7
#define DOT11_PRIV_PMKID                        8


/* Privacy Types */
#define DOT11_PRIVTYPE_WEP                      0x00000001
#define DOT11_PRIVTYPE_TKIP                     0x00000002
#define DOT11_PRIVTYPE_AES_CCMP                 0x00000020
#define DOT11_PRIVTYPE_WEP_104                  0x00000040


/* WPA Authentication Types */
#define DOT11_AUTH_WPA                          0x0001
#define DOT11_AUTH_WPAPSK                       0x0002


/* WPA Capabilities */
#define DOT11_WPA_CAP_PREAUTH                   0x0001


typedef struct obj_key
{
    uint8_t type;
    uint8_t length;
    uint8_t key[16];
    uint8_t pad[2];
} obj_key;

typedef struct obj_stakey
{
    uint8_t address[6];
    uint16_t ext;
    uint16_t keyid;
    uint8_t type;
    uint8_t length;
    uint8_t key[32];
} obj_stakey;

typedef struct obj_ssmckey
{
    uint8_t address[6];
    uint16_t ext;
    uint8_t keyid;
    uint8_t ssnr;
    uint8_t type;
    uint8_t length;
    uint8_t key[32];
} obj_ssmckey;

typedef struct obj_stasc
{
    uint8_t address[6];
    uint16_t ext;
    uint8_t keyid;
    uint8_t tx_sc;
    uint8_t ssnr;
    uint8_t pad0;
    uint32_t sc_high;
    uint16_t sc_low;
    uint8_t pad1[2];
} obj_stasc;

/* Security */
#define DOT11_OID_AUTHENABLE                    0x12000000
#define DOT11_OID_PRIVACYINVOKED                0x12000001
#define DOT11_OID_EXUNENCRYPTED                 0x12000002
#define DOT11_OID_DEFKEYID                      0x12000003
#define DOT11_OID_DEFKEY1                       0x12000004
#define DOT11_OID_DEFKEY2                       0x12000005
#define DOT11_OID_DEFKEY3                       0x12000006
#define DOT11_OID_DEFKEY4                       0x12000007
#define DOT11_OID_STAKEY                        0x12000008
#define DOT11_OID_STASC                         0x1200000a
#define DOT11_OID_AUTHORDER                     0x1200000b
#define DOT11_OID_WPA                           0x1200000d
#define DOT11_OID_RSN                           0x1200000e
#define DOT11_OID_SSMCKEY                       0x1200000f
#define DOT11_OID_SSMCSC                        0x12000010


/*
    Privacy Statistics objects

    The Privacy Statistics objects contain privacy related counters.
 */

/* Privacy Statistics */
#define DOT11_OID_PRIVTXREJECTED                0x1a000000
#define DOT11_OID_PRIVRXPLAIN                   0x1a000001
#define DOT11_OID_PRIVRXFAILED                  0x1a000002
#define DOT11_OID_PRIVRXNOKEY                   0x1a000003


/*
    MAC Configuration objects

    The MAC Configuration objects configure the 802.11 MAC frame transmission 
    reception properties.
 */

/* MAC Configuration */
#define DOT11_OID_RTSTHRESH                     0x13000000
#define DOT11_OID_FRAGTHRESH                    0x13000001
#define DOT11_OID_SHORTRETRIES                  0x13000002
#define DOT11_OID_LONGRETRIES                   0x13000003
#define DOT11_OID_MAXTXLIFETIME                 0x13000004
#define DOT11_OID_MAXRXLIFETIME                 0x13000005
#define DOT11_OID_AUTHRESPTIMEOUT               0x13000006
#define DOT11_OID_ASSOCRESPTIMEOUT              0x13000007


/*
    ALOFt Objects

    The ALOFt objects configure the Automatic Link Optimization Function's properties.


 */

/* ALOFt array definitions */
#define DOT11_ALOFT_RATEMASK                    0x00ff
#define DOT11_ALOFT_SP                          0x1000
#define DOT11_ALOFT_CTS                         0x2000
#define DOT11_ALOFT_RTS                         0x4000


/* ALOFt */
#define DOT11_OID_ALOFT_TABLE                   0x1d000000
#define DOT11_OID_ALOFT_CTRL_TABLE              0x1d000001
#define DOT11_OID_ALOFT_RETREAT                 0x1d000002
#define DOT11_OID_ALOFT_PROGRESS                0x1d000003
#define DOT11_OID_ALOFT_FIXEDRATE               0x1d000004
#define DOT11_OID_ALOFT_RSSIGRAPH               0x1d000005
#define DOT11_OID_ALOFT_CONFIG                  0x1d000006


/*
    QoS Objects

    The QoS objects configure the Quality of Service properties of the MAC. 
    that these objects are preliminary, pending support by firmware and 
    of the standard.
 */

/* ACK Policies */
#define DOT11_ACKPOLICY_ALWAYS                  0
#define DOT11_ACKPOLICY_NEVER                   1
#define DOT11_ACKPOLICY_DYNAMIC                 2


typedef struct obj_vdcf
{
    uint16_t cwmin;
    uint16_t cwmax;
    uint16_t txop;
    uint16_t aifs;
} obj_vdcf;

typedef struct obj_tspecdesc
{
    uint16_t src_port;
    uint16_t dst_port;
    uint32_t idx_tspec;
    uint8_t idx_wsm_db;
} obj_tspecdesc;

/* QoS */
#define DOT11_OID_VDCF0                         0x1b000000
#define DOT11_OID_VDCF1                         0x1b000001
#define DOT11_OID_VDCF2                         0x1b000002
#define DOT11_OID_VDCF3                         0x1b000003
#define DOT11_OID_VDCF4                         0x1b000004
#define DOT11_OID_VDCF5                         0x1b000005
#define DOT11_OID_VDCF6                         0x1b000006
#define DOT11_OID_VDCF7                         0x1b000007
#define DOT11_OID_MAXFRAMEBURST                 0x1b000008
#define DOT11_OID_TSPECSTART                    0x1b000009
#define DOT11_OID_TSPECSTOP                     0x1b00000a
#define DOT11_OID_ACKPOLICY                     0x1b00000b
#define DOT11_OID_UAPSD                         0x1b00000e
#define DOT11_OID_QOS_DISABLE                   0x1b00000f
#define DOT11_OID_TOS0                          0x1b000010
#define DOT11_OID_TOS1                          0x1b000011
#define DOT11_OID_TOS2                          0x1b000012
#define DOT11_OID_TOS3                          0x1b000013
#define DOT11_OID_TOS4                          0x1b000014
#define DOT11_OID_TOS5                          0x1b000015
#define DOT11_OID_TOS6                          0x1b000016
#define DOT11_OID_TOS7                          0x1b000017
#define DOT11_OID_LM_QDEPTH_WMMSA               0x1b000018
#define DOT11_OID_LM_QDEPTH_VO                  0x1b000019
#define DOT11_OID_LM_QDEPTH_VI                  0x1b00001A
#define DOT11_OID_LM_QDEPTH_BE                  0x1b00001B
#define DOT11_OID_LM_QDEPTH_BK                  0x1b00001C
#define DOT11_OID_BM_TRAP_WME                   0x1b00001D
#define DOT11_OID_BM_TRAP_TX_DONE               0x1b00001E

/*
    Client objects

    The Client objects configure the client related properties of the MAC. The 
    include typical client features like CAM/PSM behavior and roaming parameters.
 */

/* PSM modes */
#define DOT11_PSM_ACTIVE                        0
#define DOT11_PSM_POWERSAVE                     1
#define DOT11_PSM_DYNAMIC                       2


/* Roam Preference */
#define DOT11_RP_NONE                           0
#define DOT11_RP_DOT11G                         1
#define DOT11_RP_DOT11A                         2


/* Roam Exclude Reason */
#define DOT11_ROAMEXCLUDE_CCX_AUTHTYPE          1
#define DOT11_ROAMEXCLUDE_CCX_AUTHTIMEOUT       2
#define DOT11_ROAMEXCLUDE_CCX_CHALLENGEFROMAP   3
#define DOT11_ROAMEXCLUDE_CCX_CHALLENGETOAP     4
#define DOT11_ROAMEXCLUDE_WPA_MICFAILURE        9


/* Scan Modes */
#define SCAN_MODE_PASSIVE                       0
#define SCAN_MODE_ACTIVE                        1


typedef struct obj_roamexclude
{
    uint8_t bssid[6];
    uint16_t ext;
    uint16_t reason;
    uint8_t pad1[2];
} obj_roamexclude;

typedef struct obj_roamparms
{
    int32_t version;
    int32_t joinfailed_penalty;
    int32_t assoc_advantage;
    int32_t weight_penalty;
    int32_t weight_age;
    int32_t weight_rssi;
} obj_roamparms;

typedef struct obj_fgscanparms
{
    int32_t hibernate_short;
    int32_t hibernate_long;
} obj_fgscanparms;

/* Client */
#define DOT11_OID_PSM                           0x14000000
#define DOT11_OID_CAMTIMEOUT                    0x14000001
#define DOT11_OID_RECEIVEDTIMS                  0x14000002
#define DOT11_OID_ROAMPREFERENCE                0x14000003
#define DOT11_OID_ROAMEXCLUDE                   0x14000004
#define DOT11_OID_ROAMEXCLUDEADD                0x14000005
#define DOT11_OID_ROAMEXCLUDEREMOVE             0x14000006
#define DOT11_OID_SCANTHRESHOLD                 0x14000007
#define DOT11_OID_ROAMPARAMETERS                0x14000008
#define DOT11_OID_FGSCANPARAMETERS              0x14000009
#define DOT11_OID_SCANDISABLE                   0x1400000a
#define DOT11_OID_AUTOSCANDISABLE               0x1400000b
#define DOT11_OID_SCANMODE                      0x1400000c
#define DOT11_OID_SCANCHANNELS                  0x1400000d
#define DOT11_OID_SCANSSID                      0x1400000e


/*
    Station objects

    The Station objects configure the peer-station related properties of the MAC.
 */

/* Node Types */
#define DOT11_NODE_UNKNOWN                      0
#define DOT11_NODE_AP                           1
#define DOT11_NODE_CLIENT                       2


typedef struct obj_sta
{
    uint8_t address[6];
    uint16_t ext;
    uint8_t state;
    uint8_t node;
    uint16_t age;
    uint8_t quality;
    int8_t rssi;
    uint8_t rate;
    uint8_t pad0;
} obj_sta;

typedef struct obj_stasetss
{
    uint8_t address[6];
    uint16_t ext;
    uint8_t ssnr;
    uint8_t pad0[3];
} obj_stasetss;

typedef struct obj_stastats
{
    uint8_t address[6];
    uint16_t ext;
    uint32_t age;
    uint32_t msdu_tx;
    uint32_t msdu_rx;
    uint64_t octets_tx;
    uint64_t octets_rx;
} obj_stastats;

typedef struct obj_addrkey
{
    uint8_t mac[6];
    uint16_t ext;
} obj_addrkey;

/* Station */
#define DOT11_OID_CLIENTS                       0x15000001
#define DOT11_OID_CLIENTSASSOCIATED             0x15000002
#define DOT11_OID_CLIENT1                       0x15000003
#define DOT11_OID_CLIENTFIND                    0x150007DB
#define DOT11_OID_WDSLINKADD                    0x150007DC
#define DOT11_OID_WDSLINKREMOVE                 0x150007DD
#define DOT11_OID_EAPAUTHSTA                    0x150007DE
#define DOT11_OID_EAPUNAUTHSTA                  0x150007DF
#define DOT11_OID_DOT1XENABLE                   0x150007E0
#define DOT11_OID_MICFAILURE                    0x150007E1
#define DOT11_OID_STASETSS                      0x150007E2
#define DOT11_OID_STASTATS                      0x150007E3
#define DOT11_OID_EAPAUTHSTAEX                  0x150007E4
#define DOT11_OID_EAPUNAUTHSTAEX                0x150007E5


/*
    Statistics objects

    The Statistics objects provide information on the performance of the MAC 
    MPDU level. Refer to Statistics objects for MSDU level counter statistics.
 */

/* Statistics */
#define DOT11_OID_MPDUTXSUCCESSFUL              0x16000000
#define DOT11_OID_MPDUTXONERETRY                0x16000001
#define DOT11_OID_MPDUTXMULTIPLERETRIES         0x16000002
#define DOT11_OID_MPDUTXFAILED                  0x16000003
#define DOT11_OID_MPDURXSUCCESSFUL              0x16000004
#define DOT11_OID_MPDURXDUPS                    0x16000005
#define DOT11_OID_RTSSUCCESSFUL                 0x16000006
#define DOT11_OID_RTSFAILED                     0x16000007
#define DOT11_OID_ACKFAILED                     0x16000008
#define DOT11_OID_FRAMERECEIVES                 0x16000009
#define DOT11_OID_FRAMEERRORS                   0x1600000A
#define DOT11_OID_FRAMEABORTS                   0x1600000B
#define DOT11_OID_FRAMEABORTSPHY                0x1600000C


/*
    PHY objects

    The PHY objects configure the properties of the PHY.
 */

/* Antenna Diversity */
#define DOT11_DIVERSITY_NONE                    0x0000
#define DOT11_DIVERSITY_RX                      0x0001
#define DOT11_DIVERSITY_TX                      0x0002
#define DOT11_DIVERSITY_BOTH                    0x0003


/* Preamble Settings */
#define DOT11_PREAMBLESETTING_LONG              0
#define DOT11_PREAMBLESETTING_SHORT             1
#define DOT11_PREAMBLESETTING_DYNAMIC           2


/* CCA Modes */
#define DOT11_CCA_ED                            0x0001
#define DOT11_CCA_CS                            0x0002
#define DOT11_CCA_EDANDCS                       0x0004


/* NonERP Protection Modes */
#define DOT11_NONERP_NEVER                      0
#define DOT11_NONERP_ALWAYS                     1
#define DOT11_NONERP_DYNAMIC                    2


/* Slot Setting */
#define DOT11_SLOTSETTING_LONG                  0
#define DOT11_SLOTSETTING_SHORT                 1
#define DOT11_SLOTSETTING_DYNAMIC               2


/* Bands */
#define DOT11_BAND_2400MHZ                      0x0001
#define DOT11_BAND_5000MHZ                      0x0002
#define DOT11_BAND_ALL                          0x0003


/* Profiles */
#define DOT11_PROFILE_B_ONLY                    0
#define DOT11_PROFILE_MIXED                     1
#define DOT11_PROFILE_MIXED_LONG                2
#define DOT11_PROFILE_G_ONLY                    3
#define DOT11_PROFILE_TEST                      4
#define DOT11_PROFILE_B_WIFI                    5
#define DOT11_PROFILE_MIXED_SHORT               6


/* NonERP RTS Threshold */
#define DOT11_NONERP_RTSTHRESHOLD_ALWAYSRTS     0x00000000
#define DOT11_NONERP_RTSTHRESHOLD_ALWAYSCTS     0xffffffff
#define DOT11_NONERP_RTSTHRESHOLD_DEFAULT       0x000002c0


typedef struct obj_frequencies
{
    uint16_t nr;
    uint16_t mhz[1];
} obj_frequencies;

/* PHY */
#define DOT11_OID_SLOTTIME                      0x17000000
#define DOT11_OID_CWMIN                         0x17000001
#define DOT11_OID_CWMAX                         0x17000002
#define DOT11_OID_ACKWINDOW                     0x17000003
#define DOT11_OID_ANTENNARX                     0x17000004
#define DOT11_OID_ANTENNATX                     0x17000005
#define DOT11_OID_ANTENNADIVERSITY              0x17000006
#define DOT11_OID_EDTHRESHOLD                   0x17000008
#define DOT11_OID_PREAMBLESETTINGS              0x17000009
#define DOT11_OID_RATES                         0x1700000A
#define DOT11_OID_CCAMODESUPPORTED              0x1700000B
#define DOT11_OID_CCAMODE                       0x1700000C
#define DOT11_OID_OUTPUTPOWER                   0x1700000F
#define DOT11_OID_SUPPORTEDRATES                0x17000010
#define DOT11_OID_FREQUENCY                     0x17000011
#define DOT11_OID_SUPPORTEDFREQUENCIES          0x17000012
#define DOT11_OID_NOISEFLOOR                    0x17000013
#define DOT11_OID_NONERPPROTECTION              0x17000016
#define DOT11_OID_SLOTSETTINGS                  0x17000017
#define DOT11_OID_NONERPTIMEOUT                 0x17000018
#define DOT11_OID_PROFILES                      0x17000019
#define DOT11_OID_EXTENDEDRATES                 0x17000020
#define DOT11_OID_SUPPORTEDBANDS                0x17000021
#define DOT11_OID_BANDINDEX                     0x17000022
#define DOT11_OID_NONERPRTSTHRESHOLD            0x17000023
#define DOT11_OID_RSSITHRESHOLD                 0x17000024
#define DOT11_OID_SECFREQUENCY                  0x17000025


/*
    MLME objects

    The MLME objects implement the MLME interface, a subset of the MLME SAP as 
    by section 10 of the IEEE 802.11 standard.


 */

/* Reason Codes */
#define DOT11_RC_UNSPECIFIED                    1
#define DOT11_RC_PREV_AUTH_NOT_VALID            2
#define DOT11_RC_DEAUTH_BECAUSE_LEFT_SS         3
#define DOT11_RC_DISASSOC_INACTIVITY            4
#define DOT11_RC_DISASSOC_CANNOT_HANDLE_ASSOCS  5
#define DOT11_RC_CLASS2_RECEIVED                6
#define DOT11_RC_CLASS3_RECEIVED                7
#define DOT11_RC_DISASSOC_BECAUSE_LEFT_SS       8
#define DOT11_RC_NOT_AUTHENTICATED              9
#define DOT11_RC_POWER_CAPABILITY               10
#define DOT11_RC_SUPPORTED_CHANNELS             11
#define DOT11_RC_INVALID_INFORMATION_ELEMENT    13
#define DOT11_RC_MIC_FAILURE                    14
#define DOT11_RC_4_WAY_HANDSHAKE_TIMEOUT        15
#define DOT11_RC_GROUP_KEY_UPDATE_TIMEOUT       16
#define DOT11_RC_IE_MISMATCH                    17
#define DOT11_RC_INVALID_GROUP_CIPHER           18
#define DOT11_RC_INVALID_PAIRWISE_CIPHER        19
#define DOT11_RC_INVALID_APMK                   20
#define DOT11_RC_UNSUPPORTED_RSN_IE_VERSION     21
#define DOT11_RC_INVALID_RSN_IE_CAPABILITIES    22
#define DOT11_RC_IEEE802DOT1X_AUTH_FAILED       23
#define DOT11_RC_CIPHER_SUITE_SECURITY_POLICY   24


/* Status Codes */
#define DOT11_SC_SUCCESSFUL                     0
#define DOT11_SC_UNSPECIFIED                    1
#define DOT11_SC_UNSUPPORTED_CAPABILITIES       10
#define DOT11_SC_NO_ASSOCIATION                 11
#define DOT11_SC_OUTSIDE_SCOPE                  12
#define DOT11_SC_UNSUPPORTED_AUTH_ALG           13
#define DOT11_SC_OUT_OF_SEQUENCE                14
#define DOT11_SC_CHALLENGE_FAILURE              15
#define DOT11_SC_TIMEOUT                        16
#define DOT11_SC_CANNOT_HANDLE_ASSOCS           17
#define DOT11_SC_UNSUPPORTED_BASIC_RATES        18
#define DOT11_SC_UNSUPPORTED_SHORT_PREAMBLE     19
#define DOT11_SC_SPECTRUM_MANAGEMENT            22
#define DOT11_SC_POWER_CAPABILITY               23
#define DOT11_SC_SUPPORTED_CHANNELS             24
#define DOT11_SC_UNSUPPORTED_SHORT_SLOT         25
#define DOT11_SC_INVALID_INFORMATION_ELEMENT    40
#define DOT11_SC_INVALID_GROUP_CIPHER           41
#define DOT11_SC_INVALID_PAIRWISE_CIPHER        42
#define DOT11_SC_INVALID_APMK                   43
#define DOT11_SC_UNSUPPORTED_RSN_IE_VERSION     44
#define DOT11_SC_INVALID_RSN_IE_CAPABILITIES    45
#define DOT11_SC_CIPHER_SUITE_SECURITY_POLICY   46


/* Link Role */
#define LINK_ROLE_SERVER                        0
#define LINK_ROLE_CLIENT                        1


typedef struct obj_mlme
{
    uint8_t address[6];
    uint16_t ext;
    int16_t id;
    uint16_t state;
    uint8_t ssnr;
    uint8_t role;
    uint8_t pad0[2];
    uint16_t code;
    int16_t size;
#ifdef HAVE_DATA_MEMBER
    uint8_t data[1];
#endif 
} obj_mlme;

typedef struct obj_scan
{
    int16_t sweep;
    uint16_t min;
    uint16_t max;
    uint16_t interval;
    uint16_t amin;
    uint16_t amax;
} obj_scan;

typedef struct obj_preauth
{
    int16_t size;
    uint16_t pad;
#ifdef HAVE_DATA_MEMBER
    uint8_t data[1];
#endif 
} obj_preauth;

typedef struct obj_iappreassoc
{
    uint8_t client[6];
    uint8_t old_ap[6];
    uint16_t seqnr;
} obj_iappreassoc;

/* MLME */
#define DOT11_OID_DEAUTHENTICATE                0x18000000
#define DOT11_OID_AUTHENTICATE                  0x18000001
#define DOT11_OID_DISASSOCIATE                  0x18000002
#define DOT11_OID_ASSOCIATE                     0x18000003
#define DOT11_OID_SCAN                          0x18000004
#define DOT11_OID_REASSOCIATE                   0x1800000b
#define DOT11_OID_NULL                          0x1800000d
#define DOT11_OID_BEACONTX                      0x1800000e
#define DOT11_OID_PROBERSP                      0x1800000f
#define DOT11_OID_PREAUTH                       0x18000010
#define DOT11_OID_IAPPREASSOC                   0x18000011


/*
    Status objects
 */

/* Non ERP Status */
#define DOT11_NONERPSTAT_PRESENT                0x01
#define DOT11_NONERPSTAT_PROTECT                0x02
#define DOT11_NONERPSTAT_BARKERPREAMBLE         0x04


/* Status */
#define DOT11_OID_NONERPSTATUS                  0x1e000000


/*
    Configuration objects
 */

/* MLME Policies */
#define DOT11_MLMEPOLICY_PRIVACYREQUIRED        0x00000001
#define DOT11_MLMEPOLICY_PRIVACYCAPABILITY      0x00000002
#define DOT11_MLMEPOLICY_ALLOWUNENCRYPTEDBCAST  0x00000004
#define DOT11_MLMEPOLICY_EXCLUDEDOT11B          0x00000008
#define DOT11_MLMEPOLICY_PRIVACYCAPDIRECTED     0x00000010
#define DOT11_MLMEPOLICY_UNENCRYPTEDBCAST       0x00000020
#define DOT11_MLMEPOLICY_PRIVACYREFUSED         0x00000040
#define DOT11_MLMEPOLICY_IGNOREBCSSID           0x00000080
#define DOT11_MLMEPOLICY_HIDDENNETWORK          0x00000080


typedef struct obj_attachment
{
    uint8_t type;
    uint8_t ssnr;
    int16_t id;
    uint8_t pad1[2];
    int16_t size;
#ifdef HAVE_DATA_MEMBER
    uint8_t data[1];
#endif 
} obj_attachment;

/* Configuration */
#define DOT11_OID_STATIMEOUT                    0x19000000
#define DOT11_OID_19000001                      0x19000001
#define DOT11_OID_BSSTIMEOUT                    0x19000002
#define DOT11_OID_ATTACHMENT                    0x19000003
#define DOT11_OID_MLMEPOLICIES                  0x19000005


/*
    BSS objects
 */

typedef struct obj_bss
{
    uint8_t address[6];
    uint16_t ext;
    uint8_t state;
    uint8_t pad0;
    uint16_t age;
    uint8_t quality;
    int8_t rssi;
    uint8_t ssid[34];
    uint16_t channel;
    uint8_t pad1;
    uint8_t dtim_period;
    uint16_t beacon_period;
    uint16_t capinfo;
    uint16_t rates;
    uint16_t basic_rates;
} obj_bss;

typedef struct obj_bsslist
{
    uint32_t nr;
    obj_bss bsslist[1];
} obj_bsslist;

typedef struct obj_bssex
{
    uint8_t address[6];
    uint16_t ext;
    uint8_t state;
    uint8_t pad1;
    uint16_t age;
    uint8_t quality;
    int8_t rssi;
    uint8_t ssid[34];
    uint16_t channel;
    uint8_t pad2;
    uint8_t dtim_period;
    uint16_t beacon_period;
    uint16_t capinfo;
    uint16_t rates;
    uint16_t basic_rates;
    uint16_t ext_rates;
    uint16_t length;
#ifdef HAVE_DATA_MEMBER
    uint8_t data[1];
#endif 
} obj_bssex;

/* BSS */
#define DOT11_OID_BSSS                          0x1c000000
#define DOT11_OID_BSS1                          0x1c000001
#define DOT11_OID_BSSFIND                       0x1c000042
#define DOT11_OID_BSSLIST                       0x1c000043
#define DOT11_OID_BSSITERATE                    0x1c000044
#define DOT11_OID_BSSLISTFLUSH                  0x1c000045

/*
    Regulatory objects
 */

/* Channel Issue */
#define DOT11_CHANNELISSUE_NONE                 0
#define DOT11_CHANNELISSUE_RADAR                1
#define DOT11_CHANNELISSUE_COUNTRY              2
#define DOT11_CHANNELISSUE_FREQUENCY            3
#define DOT11_CHANNELISSUE_CHANNELSET           4


/* 802.11d Conformance Mode */
#define DOT11_CONFORMANCE_FAST                  0
#define DOT11_CONFORMANCE_STRICT                1
#define DOT11_CONFORMANCE_FLEXIBLE              2


/* World Wide Radio Mode */
#define DOT11_WWR_MODE_NONE                     0
#define DOT11_WWR_MODE_11D                      1
#define DOT11_WWR_MODE_FLEXIBLE                 2
#define DOT11_WWR_MODE_STRICT                   3


/* Channel Mode */
#define DOT11_CHANNELMODE_MANUAL                0
#define DOT11_CHANNELMODE_DYNAMIC               1
#define DOT11_CHANNELMODE_ETSI                  2


typedef struct obj_channelissue
{
    uint32_t reason;
    uint32_t data;
} obj_channelissue;

typedef struct obj_frequency
{
    uint16_t mhz;
    uint16_t pad;
} obj_frequency;

typedef struct obj_country
{
    uint8_t string[4];
    obj_frequency frequencies[1];
} obj_country;

/* Regulatory */
#define DOT11_OID_BANDENABLE                    0x1f000000
#define DOT11_OID_COUNTRYLIST                   0x1f000001
#define DOT11_OID_COUNTRY                       0x1f000002
#define DOT11_OID_CHANNELISSUE                  0x1f000003
#define DOT11_OID_CONFORMANCEMODE               0x1f000004
#define DOT11_OID_WWRMODE                       0x1f000005
#define DOT11_OID_CHANNELMODE                   0x1f000006
#define DOT11_OID_CURRENTCOUNTRY                0x1f000007
#define DOT11_OID_NEXTFREQUENCY                 0x1f000008
#define DOT11_OID_MEASUREMENTTHRESHOLD          0x1f000009
#define DOT11_OID_CHANNELSWITCH                 0x1f00000a


/*
    CCX objects
 */

/* CCX */
#define CCX_OID_REPORTROGUEAPLIST               0xa0000000


/*
    PPE objects
 */

/* PPE Enable */
#define PPE_ENABLE_PDLP                         0x00000001
#define PPE_ENABLE_COMPRESS                     0x00000002
#define PPE_ENABLE_CONCAT                       0x00000004
#define PPE_ENABLE_PBACK                        0x00000008
#define PPE_ENABLE_WDS                          0x00000010
#define PPE_ENABLE_IREP                         0x00000020
#define PPE_ENABLE_STREAM_MODE                  0x00000040
#define PPE_ENABLE_STREAM_ACK                   0x00000080
#define PPE_ENABLE_MESH                         0x00000100


/* IDLP Enable */
#define IDLP_ENABLE_CAN                         0x00000001
#define IDLP_ENABLE_POWERSAVE                   0x00000002
#define IDLP_ENABLE_MULTICHANNEL                0x00000004


/* WDS Privacy */
#define WDS_PRIV_NONE                           0
#define WDS_PRIV_WEP40                          1
#define WDS_PRIV_WEP104                         2
#define WDS_PRIV_TKIP                           3
#define WDS_PRIV_AES_CCMP                       4


/* Instant Repeating Role */
#define IREP_ROLE_CLIENT                        0x00000001
#define IREP_ROLE_SERVER                        0x00000002


/* WDS Modes */
#define WDS_MODE_OFF                            0
#define WDS_MODE_STATELESS                      1
#define WDS_MODE_DUAL_ROLE                      2


/* Mesh Settings */
#define MESH_STANDALONE                         0
#define MESH_PORTAL                             1


/* PPE */
#define PPE_OID_PPEENABLE                       0xa1000000
#define PPE_OID_PPEACTIVITY                     0xa1000001
#define PPE_OID_IDLPENABLE                      0xa1000002
#define PPE_OID_WDSPRIVACY                      0xa1000003
#define PPE_OID_IREPENABLE                      0xa1000004
#define PPE_OID_WDSMODE                         0xa1000005
#define PPE_OID_MESHSETTING                     0xa1000006


/*
    Customer-defined objects
 */

/* Customer-Defined Objects */
#define CUSTOM_OID_FIRST                        0xa2000000
#define CUSTOM_OID_LAST                         0xa200ffff


/*
    IM WiFi Objects
 */

/* PDM Peer Events */
#define PDM_PEER_EVENT_ADDED                    0
#define PDM_PEER_EVENT_UPDATED                  1
#define PDM_PEER_EVENT_REMOVED                  2


/* RSC Status */
#define RSC_STATUS_SUCCESS                      0
#define RSC_STATUS_UNSPEC                       1
#define RSC_STATUS_BAD_KEY                      2
#define RSC_STATUS_DENIED                       3
#define RSC_STATUS_NO_RESPONSE                  4


typedef struct obj_imwifipeerkey
{
    obj_addrkey peer;
    uint8_t key[32];
} obj_imwifipeerkey;

typedef struct obj_pdmdata
{
    uint16_t frequency;
    uint16_t mtu;
    uint16_t period;
    uint16_t window;
#ifdef HAVE_DATA_MEMBER
    uint8_t data[1];
#endif 
} obj_pdmdata;

typedef struct obj_pdmpeerdata
{
    uint8_t index;
    uint8_t event;
    uint8_t pad[2];
    obj_addrkey peer;
    obj_pdmdata pdm;
} obj_pdmpeerdata;

typedef struct obj_rscrequest
{
    obj_addrkey peer;
    uint16_t id;
#ifdef HAVE_DATA_MEMBER
    uint8_t data[1];
#endif 
} obj_rscrequest;

typedef struct obj_rscresponse
{
    obj_addrkey peer;
    uint16_t id;
    uint16_t status;
} obj_rscresponse;

/* IM WiFi Objects */
#define IMWIFI_OID_KEY                          0xa3000000
#define IMWIFI_OID_PEERKEY                      0xa3000001
#define IMWIFI_OID_PDMDATA                      0xa3000010
#define IMWIFI_OID_PDMDBSIZE                    0xa3000011
#define IMWIFI_OID_PDMPEERDATA                  0xa3000012
#define IMWIFI_OID_RSCPEERACCEPT                0xa3000020
#define IMWIFI_OID_RSCREQUEST                   0xa3000021
#define IMWIFI_OID_RSCRESPONSE                  0xa3000022


/*
    Dual Role WDS Objects
 */

typedef struct obj_drlink
{
    obj_addrkey peer;
    uint32_t link_uptime;
    uint8_t role;
    uint8_t pad0[3];
} obj_drlink;

/* Dual Role Objects */
#define WDS_OID_DRSSID                          0xa4000000
#define WDS_OID_DRBSSID                         0xa4000001
#define WDS_OID_DRPRIVINVOKED                   0xa4000002
#define WDS_OID_DRAUTHALG                       0xa4000003
#define WDS_OID_DRLINKS                         0xa4000004

/*
    LMAC Objects
 */

/* NV Status Flags */
#define NV_FLAG_BUSY                            0x0001


typedef struct obj_nvstatus
{
    uint16_t flags;
    uint8_t comphi;
    uint8_t complo;
} obj_nvstatus;



/* LMAC */
#define LMAC_OID_GPIOBANK                       0x80000005
#define LMAC_OID_GPIOWM                         0x80000006
#define LMAC_OID_GPIODATA                       0x80000007
#define LMAC_OID_GPIOSTATUS                     0x80000008
#define LMAC_OID_GPIODDR                        0x80000009
#define LMAC_OID_BBREGNR                        0x8000000b
#define LMAC_OID_BBREGDATA                      0x8000000c
#define LMAC_OID_PROFILE                        0x8000000d

/* Non Volatile */
#define LMAC_OID_NVID                           0x81000000
#define LMAC_OID_NVOFFSET                       0x81000001
#define LMAC_OID_NVSIZE                         0x81000002
#define LMAC_OID_NVDATA                         0x81000003
#define LMAC_OID_NVSTATUS                       0x81000004

/* MTUM objects */
#define LMAC_MTUM_MODE                          0xff020010
#define LMAC_MTUM_TIMEOUT                       0xff020011
#define LMAC_MTUM_CMD                           0xff020012
#define LMAC_MTUM_MODE_TX_BURST                 0xff020016
#define LMAC_MTUM_IQCAL                         0xff020017
#define LMAC_MTUM_CHANNEL                       0xff020020
#define LMAC_MTUM_RATE                          0xff020021
#define LMAC_MTUM_PREAMBLE                      0xff020022
#define LMAC_MTUM_INTERVAL                      0xff020023
#define LMAC_MTUM_LENGTH                        0xff020024
#define LMAC_MTUM_PATTERN                       0xff020025
#define LMAC_MTUM_MODULATION                    0xff020026
#define LMAC_MTUM_SCRAMBLING                    0xff020027
#define LMAC_MTUM_FILTERTYPE                    0xff020028
#define LMAC_MTUM_ANTENNA_RX                    0xff020029
#define LMAC_MTUM_ANTENNA_TX                    0xff02002a
#define LMAC_MTUM_POWERLOOP                     0xff02002b
#define LMAC_MTUM_BBREGVALUE                    0xff020030
#define LMAC_MTUM_GPIOVALUE                     0xff020031
#define LMAC_MTUM_DETECTORVALUE                 0xff020032
#define LMAC_MTUM_RSSIVALUE                     0xff020033
#define LMAC_MTUM_SQVALUE                       0xff020034
#define LMAC_MTUM_SYNTH                         0xff020035
#define LMAC_MTUM_RCPI                          0xff020036
#define LMAC_MTUM_DETECTORMAX                   0xff020037
#define LMAC_MTUM_DETECTORGAIN                  0xff020038
#define LMAC_MTUM_BURST_DETECTOR                0xff020039
#define LMAC_MTUM_RAW_RSSI                      0xff02003A
#define LMAC_MTUM_BBREGNR                       0xff020040
#define LMAC_MTUM_GPIOMASK                      0xff020041
#define LMAC_MTUM_POWER                         0xff020043
#define LMAC_MTUM_SYNTHNR                       0xff020044
#define LMAC_MTUM_GPIOBANK                      0xff020045
#define LMAC_MTUM_GPIODDR                       0xff020046
#define LMAC_MTUM_TXDONE                        0xff020070
#define LMAC_MTUM_TXDUMPED                      0xff020071
#define LMAC_MTUM_RXSUCCESS                     0xff020072
#define LMAC_MTUM_RXFAILED                      0xff020073
#define LMAC_MTUM_RXABORTED                     0xff020074
#define LMAC_MTUM_RXABORTEDPHY                  0xff020075
#define LMAC_MTUM_RXFAILEDPRIV                  0xff020076

/* MTUM modes definition */
#define TM_IDLE          0
#define TM_BURNIN        1
#define TM_PSM           2
#define TM_CONT_RX       3
#define TM_CONT_TX       4
#define TM_PROM_RX       5
#define TM_PROM_TX       6
#define TM_REPEAT_TX     7
#define TM_PROM_RXTX     8
#define TM_BURST_CONT_TX 9

/* TX burst related structs and lengths */
#define MAX_NR_BURSTS 16 /* This is a firmware limitation */
typedef struct obj_burstctx
{
	uint32_t mtum_mode;    /* value must be TM_BURST_CONT_TX */
	uint16_t nr_bursts;      /* number of bursts */
	uint16_t cnt;          /* value is ignored, only used by LMAC */
	uint16_t width;        /* width of each burst [usec] should be >=80u */
	uint16_t spacing;      /* space between bursts [usec] */
	uint16_t powers[MAX_NR_BURSTS];   /* power for each burst */
	
          /* Unit should be same as open loop test.
	     powers[0] is 1st burst, powers[1] is 2nd and so on.
	     The values for unused bursts are ignored.*/
} obj_burstctx;
#define MODE_TX_BURST_BUF_LEN   (sizeof(struct obj_burstctx)) /* should be 44 */

typedef struct obj_burstdetector
{
    uint16_t values[MAX_NR_BURSTS];
} obj_burst_detector;
#define TX_BURST_DETECTOR_LEN   (sizeof(struct obj_burstdetector))

struct obj_iqcal
{
    uint16_t reg_val[6];
};
#define IQCAL_DATA_LEN   (sizeof(struct obj_iqcal))

/* MTUM commands */
#define CMD_NONE                0
#define CMD_DEBUG_MODE1         1
#define CMD_DEBUG_MODE2         2
#define CMD_DEBUG_MODE3         3
#define CMD_DEBUG_MODE4         4
#define CMD_DEBUG_MODE5         5
#define CMD_DEBUG_MODE6         6
#define CMD_DEBUG_MODE7         7
#define CMD_DEBUG_MODE8         8
#define CMD_FLASH_ERASE         9
#define CMD_RESET_COUNTERS      10
#define CMD_RESET               11
#define CMD_ABORT               12
#define CMD_INVALIDATE          13
#define CMD_RADIO_CONFIG0       14
#define CMD_RADIO_CONFIG1       15
#define CMD_RADIO_CONFIG2       16
#define CMD_RADIO_CONFIG3       17
#define CMD_RADIO_CONFIG4       18
#define CMD_RADIO_CONFIG5       19
#define CMD_RADIO_CONFIG6       20
#define CMD_RADIO_CONFIG7       21
#define CMD_IQ_CAL_ONESHOT      22
#define CMD_IQ_CAL_MODE0        23
#define CMD_IQ_CAL_MODE1        24
#define CMD_IQ_CAL_MODE2        25
#define CMD_IQ_CAL_MODE3        26
#define CMD_VCO_CAL_ONESHOT     27
#define CMD_ANTSEL_MODE0        28
#define CMD_ANTSEL_MODE1        29
#define CMD_HSSI_UNLOCK         30

/* Phaser ref. clock definitions */
#define CMD_REF_CLOCK_40_0      40
#define CMD_REF_CLOCK_38_4      41
#define CMD_REF_CLOCK_26_0      42
#define CMD_REF_CLOCK_19_2      43

/* RESERVED VALUES:
#define CMD_REF_CLOCK_RESERVED01    44
#define CMD_REF_CLOCK_RESERVED02    45
#define CMD_REF_CLOCK_RESERVED03    46
#define CMD_REF_CLOCK_RESERVED04    47
#define CMD_REF_CLOCK_RESERVED05    48
#define CMD_REF_CLOCK_RESERVED06    49
#define CMD_REF_CLOCK_RESERVED07    50
#define CMD_REF_CLOCK_RESERVED08    51
#define CMD_REF_CLOCK_RESERVED09    52
#define CMD_REF_CLOCK_RESERVED10    53
#define CMD_REF_CLOCK_RESERVED11    54
#define CMD_REF_CLOCK_RESERVED12    55
#define CMD_REF_CLOCK_RESERVED13    56
#define CMD_REF_CLOCK_RESERVED14    57
#define CMD_REF_CLOCK_RESERVED15    58
#define CMD_REF_CLOCK_RESERVED16    59
*/


/* Testserver rates definition */
#define TEST_WLAN_RATE_1M                        0x0D
#define TEST_WLAN_RATE_2M                        0x0E
#define TEST_WLAN_RATE_5_5M_CCK                  0x0F
#define TEST_WLAN_RATE_5_5M_PBCC                 0x10
#define TEST_WLAN_RATE_11M_CCK                   0x11
#define TEST_WLAN_RATE_11M_PBCC                  0x12
#define TEST_WLAN_RATE_22M_PBCC                  0x13
#define TEST_WLAN_RATE_6M                        0x25
#define TEST_WLAN_RATE_9M                        0x26
#define TEST_WLAN_RATE_12M                       0x27
#define TEST_WLAN_RATE_18M                       0x28
#define TEST_WLAN_RATE_24M                       0x29
#define TEST_WLAN_RATE_36M                       0x2A
#define TEST_WLAN_RATE_48M                       0x2B
#define TEST_WLAN_RATE_54M                       0x2C


#endif /* __smoid_h__ */
