/*
 * This file is part of cx3110x
 *
 * OMAP SPI wrapper for Conexant Softmac driver.
 *
 * Copyright (C) 2004, 2005, 2006 Nokia Corporation
 *
 * Contact: Kalle Valo <Kalle.Valo@nokia.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * version 2 as published by the Free Software Foundation. 
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */


#ifndef _SM_DRV_SPI_IO_H
#define _SM_DRV_SPI_IO_H

#include <linux/spi/spi.h>

int cx3110x_request_irq(irqreturn_t (*handler)(int, void *),
			  const char * devname, void *dev_id);
void cx3110x_free_irq(void *dev_id);
void cx3110x_disable_irq(struct net_device *dev);

int cx3110x_spi_start(struct net_device *dev);
void cx3110x_spi_stop(struct net_device *dev);

int cx3110x_probe(struct spi_device *spi);
int cx3110x_remove(struct spi_device *spi);

int cx3110x_spi_read(struct net_device * dev, unsigned long address,
		     unsigned char * buffer, unsigned int length);
int cx3110x_spi_write(struct net_device * dev, unsigned long address,
		      unsigned char * buffer, unsigned int length);
int cx3110x_spi_dma_read(struct net_device *dev, unsigned long address,
			 void * buffer, unsigned int length);
int cx3110x_spi_dma_write(struct net_device *dev, unsigned long address,
			  void * buffer, unsigned int length);

void cx3110x_dump_register(struct net_device * dev);

#define sm_spi_read(dev, addr, data, len) \
	cx3110x_spi_read(dev, (addr), (data), (len))  
#define sm_spi_write(dev, addr, data, len) \
	cx3110x_spi_write(dev, (addr), (data), (len))

#define sm_spi_dma_read(dev, addr, data, len) \
	cx3110x_spi_dma_read(dev, (addr), (data), (len))
#define sm_spi_dma_write(dev, addr, data, len) \
	cx3110x_spi_dma_write(dev, (addr), (data), (len))

#endif
