#include <stdio.h>
#include <assert.h>
#include "../include/cst.h"

#define TESTFS_DIR  "/tmp/testfs"
#define TESTFS_FILE "/tmp/test.fs"
#define CERT_DBFILE  TESTFS_DIR  "/certs.db"

#define array_length( x )   (sizeof( x ) / sizeof( x[0] ))
#define die( str... )          ({ fprintf( stderr, ##str ); exit( 1 ); })

#define TS_ASSERT( x )                ({ if ( !x ){ test_failed++; printf( "%s:%d: Error: Assertion failed: %s\n", __FILE__, __LINE__, #x );} })
#define TS_ASSERT_EQUALS( x, y )      ({ if ( x != y  ){ test_failed++; printf( "%s:%d: Error: Assertion failed: %s == %s (%d != %d \n", __FILE__, __LINE__, #x, #y, x, y );} })

static int test_failed=0;

void exec_cmdset( char** cmds, int count )
{
	int i;
	char *cmd;
	
	for( i = 0; i< count; ++i ) {
		cmd = cmds[i];
		
		//printf( "cmd: %s\n", cmd );
		system( cmd );
	}
}

static void test_setUp()
{
	char* cmds[] = {
		"dd if=/dev/zero of=" TESTFS_FILE " count=100 bs=1024 &>/dev/null",
		"echo y | /sbin/mke2fs " TESTFS_FILE " &>/dev/null",
		"mkdir " TESTFS_DIR " &>/dev/null",
		"echo 'enter sudo password for mount:'; sudo mount -o loop " TESTFS_FILE " " TESTFS_DIR,
	};

	exec_cmdset( cmds, array_length( cmds ) );
}

static void test_tearDown()
{
	char* cmds[] = {
		"echo 'enter sudo password for umount:'; sudo umount " TESTFS_DIR,
		"rm " TESTFS_FILE,
		"rmdir " TESTFS_DIR,
	};
	exec_cmdset( cmds, array_length( cmds ) );
}

static void test_test1()
{
	int i;
	int nospc=0;
	CST * cst = CST_open_file( CERT_DBFILE, 0, NULL);
	for( i=1; i < 100; ++i ) {
		char pemfile[256];
		int rc;

		sprintf( pemfile, "./files/ca_root/%d.pem", i );
		//printf( "%d ", i );
		
		rc = try_import_cert( cst, pemfile );
		if ( i <= 55 ) {
			TS_ASSERT_EQUALS( CST_ERROR_OK, rc );
		}
		else {
			TS_ASSERT_EQUALS( CST_ERROR_NOSPC, rc );
		}

		if ( rc == CST_ERROR_NOSPC ) {
			--i;
			nospc++;
		}

		if ( nospc > 5 ) break;
	}
	CST_free( cst );
}

int main()
{
	test_setUp();

	test_test1();
	
	test_tearDown();
	
	return( test_failed );
}

int try_import_cert(CST * st, const char *filename)
{
	int rc;
    FILE *fp;

	fp = fopen(filename, "r");
	if ( !fp ) die( "file not found: %s", filename );

	rc = CST_import_cert_f(st, fp, NULL, 0);
    fclose(fp);
    
    return( rc );
}
