/* Certificate Management library
 * 
 * Copyright (C) 2005 Nokia. All rights reserved.
 * Author: Ed Bartosh <Eduard.Bartosh@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License version 2.1 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/**
    @file cst_key_idx.c

    Certificate Management Library

    Key functions (search)
*/

#include "cst_t.h"
#include "cst.h"
#include <glib.h>
#include <openssl/evp.h>

static GSList * slist_to_slist_UID(GSList * list, const t_bool pub)
{
    if(list)
    {
        GSList * res = NULL;
        GSList * i;
        KEY * k;
        
        for (i = list; i != NULL; i = i->next)
        {
            k = (KEY *) i->data;
            if (k->pub == pub)
            {
                g_assert(k->uid);
                res = g_slist_append(res, SEQNUM_TO_POINTER(k->uid));
            }
        }

        return res;
    }
    return NULL;
}

GSList * cst_key_search_by_name(CST * st, X509_NAME * name,
                                  const t_bool pub)
{
    GSList *list = NULL;
    if (st && name)
    {
        CST_LOCK_BEGIN(LOCK_SH);    
            list = slist_to_slist_UID((GSList *) g_tree_lookup(st->keys, name), pub);
        CST_LOCK_END;
    }
    else
    {
        CST_error(CST_ERROR_PARAM_INCORRECT);
    }
    return list;
}
