/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the EAL package.
 *
 * The Initial Developer of the Original Code is Nokia Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2005
 * the Initial Developer. All Rights Reserved.
 *
 * Contact: Leonid Zolotarev <leonid.zolotarev@nokia.com>
 *
 * ***** END LICENSE BLOCK ***** */

#include "gweb.h"

static void
g_web_base_init (gpointer g_class)
{
	static gboolean initialized = FALSE;

	if (!initialized) {
		/* create interface signals here. */
		initialized = TRUE;
	}
}

GType
g_web_get_type (void)
{
    static GType type = 0;
    if (type == 0) {
        static const GTypeInfo info = {
            sizeof (GWebIface),
            g_web_base_init,   /* base_init */
            NULL,   /* base_finalize */
            NULL,   /* class_init */
            NULL,   /* class_finalize */
            NULL,   /* class_data */
            0,
            0,      /* n_preallocs */
            NULL    /* instance_init */
        };
        type = g_type_register_static (G_TYPE_INTERFACE, "GWeb", &info, 0);
    }
    return type;
}

void
g_web_destroy (GWeb *self)
{
	G_WEB_GET_CLASS (self)->destroy (self);
}

GWebEngine*
g_web_new_web_engine_window (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->new_web_engine_window (self);
}

GWebEngine*
g_web_new_web_engine_window_with_context (GWeb *self, gpointer context, gboolean leave_tracks, gboolean without_history)
{
	return G_WEB_GET_CLASS (self)->new_web_engine_window_with_context (self, context, leave_tracks, without_history);
}

gboolean
g_web_set_pref (GWeb *self, gpointer type, const gchar* name, gpointer value)
{
	return G_WEB_GET_CLASS (self)->web_set_pref (self, type, name, value);
}

gboolean
g_web_get_pref (GWeb *self, gpointer type, const gchar* name, gpointer value)
{
	return G_WEB_GET_CLASS (self)->web_get_pref (self, type, name, value);
}

gboolean
g_web_set_glist_select_item(GWeb *self, gint select)
{
	return G_WEB_GET_CLASS (self)->web_set_glist_select_item (self, select);
}

gboolean
g_web_get_glist_item(GWeb *self, guint index, gchar **username)
{
	return G_WEB_GET_CLASS (self)->web_get_glist_item (self, index, username);
}

GWebTransferItem*
g_web_new_web_transfer_item (GWeb *self, const gchar* url, const gchar* filename)
{
	return G_WEB_GET_CLASS (self)->new_web_transfer_item (self, url, filename);
}

GWebTransferItem*
g_web_initialize_web_transfer_item (GWeb *self, GObject *web_transfer_item)
{
	return G_WEB_GET_CLASS (self)->initialize_web_transfer_item (self, web_transfer_item);
}

GWebTransferItemList*
g_web_get_web_transfer_item_list (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_web_transfer_item_list (self);
}

GWebStatus
g_web_set_home_page (GWeb *self, const gchar* home_page)
{
	return G_WEB_GET_CLASS (self)->set_home_page (self, home_page);
}

gchar*
g_web_get_home_page (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_home_page (self);
}

GWebStatus
g_web_set_language (GWeb *self, const gchar* language)
{
	return G_WEB_GET_CLASS (self)->set_language (self, language);
}

gchar*
g_web_get_language (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_language (self);
}

void
g_web_reset_cache_history_length (GWeb *self)
{
	G_WEB_GET_CLASS (self)->reset_cache_history_length (self);
}

gint
g_web_get_maximum_cache_size (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_maximum_cache_size (self);
}

GWebStatus
g_web_set_default_home_page (GWeb *self, const gchar* default_page)
{
	return G_WEB_GET_CLASS (self)->set_default_home_page (self, default_page);
}

gchar*
g_web_get_default_home_page (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_default_home_page (self);
}

gboolean
g_web_home_page_set (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->home_page_set (self);
}

void
g_web_set_frame_borders_enabled (GWeb *self, gboolean enabled)
{
	G_WEB_GET_CLASS (self)->set_frame_borders_enabled (self, enabled);
}

gboolean
g_web_get_frame_borders_enabled (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_frame_borders_enabled (self);
}

GWebStatus
g_web_set_location_completion_suffixes (GWeb *self, const gchar* suffixes)
{
	return G_WEB_GET_CLASS (self)->set_location_completion_suffixes (self, suffixes);
}

gchar*
g_web_get_location_completion_suffixes (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_location_completion_suffixes (self);
}

GWebStatus
g_web_set_plugins_enabled (GWeb *self, gboolean enabled)
{
	return G_WEB_GET_CLASS (self)->set_plugins_enabled (self, enabled);
}

GWebStatus
g_web_set_oom_cb (GWeb *self, GFunc func)
{
	return G_WEB_GET_CLASS (self)->set_oom_cb (self, func);
}


GWebStatus
g_web_set_ssl2_support (GWeb *self, gboolean enabled)
{
	return G_WEB_GET_CLASS (self)->set_ssl2_support (self, enabled);
}

gboolean
g_web_get_ssl2_support (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_ssl2_support (self);
}

gboolean
g_web_get_plugins_enabled (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_plugins_enabled (self);
}

GWebStatus
g_web_set_js_enabled (GWeb *self, gboolean enabled)
{
	return G_WEB_GET_CLASS (self)->set_js_enabled (self, enabled);
}

gboolean
g_web_get_js_enabled (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_js_enabled (self);
}

void
g_web_set_memory_cache (GWeb *self, GMemoryCache acceptance)
{
	G_WEB_GET_CLASS (self)->set_memory_cache (self, acceptance);
}

GMemoryCache
g_web_get_memory_cache (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_memory_cache (self);
}

GWebStatus
g_web_set_cache_size (GWeb *self, gint size)
{
	return G_WEB_GET_CLASS (self)->set_cache_size (self, size);
}

gint
g_web_get_cache_size (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_cache_size (self);
}

GWebStatus
g_web_set_browse_offline (GWeb *self, gboolean offline)
{
	return G_WEB_GET_CLASS (self)->set_browse_offline (self, offline);
}

gboolean
g_web_get_browse_offline (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_browse_offline (self);
}

GWebStatus
g_web_set_automatic_redirection_enabled (GWeb *self, gboolean enabled)
{
	return G_WEB_GET_CLASS (self)->set_automatic_redirection_enabled (self, enabled);
}

gboolean
g_web_get_automatic_redirection_enabled (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_automatic_redirection_enabled (self);
}

GWebStatus
g_web_set_load_images (GWeb *self, GWebEngineImagePolicy level)
{
	return G_WEB_GET_CLASS (self)->set_load_images (self, level);
}

GWebEngineImagePolicy
g_web_get_load_images (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_load_images (self);
}

void
g_web_disconnect (GWeb *self)
{
	G_WEB_GET_CLASS (self)->disconnect (self);
}

GWebStatus
g_web_clear_cache (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->clear_cache (self);
}


GWebPluginList*
g_web_get_plugins_list (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_plugins_list (self);
}

GWebHistoryList*
g_web_get_history_list (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_history_list (self);
}

GWebStatus
g_web_set_new_window_loads (GWeb *self, gboolean loads)
{
	return G_WEB_GET_CLASS (self)->set_new_window_loads (self, loads);
}

gboolean
g_web_get_new_window_loads (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_new_window_loads (self);
}

void
g_web_set_cookie_acceptance (GWeb *self, GCookieAcceptance acceptance)
{
	G_WEB_GET_CLASS (self)->set_cookie_acceptance (self, acceptance);
}

GCookieAcceptance
g_web_get_cookie_acceptance (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_cookie_acceptance (self);
}

void
g_web_set_popup_acceptance (GWeb *self, GPopupAcceptance acceptance)
{
	G_WEB_GET_CLASS (self)->set_popup_acceptance (self, acceptance);
}

GPopupAcceptance
g_web_get_popup_acceptance (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_popup_acceptance (self);
}

GWebStatus
g_web_suspend (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->suspend (self);
}

gboolean
g_web_suspended (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->suspended (self);
}

void
g_web_resume (GWeb *self)
{
	G_WEB_GET_CLASS (self)->resume (self);
}

void
g_web_set_ua_string (GWeb *self, gchar *ua_string)
{
	G_WEB_GET_CLASS (self)->set_ua_string (self, ua_string);
}

GWebStatus
g_web_set_user_agent_id (GWeb *self, gint ua_id)
{
	return G_WEB_GET_CLASS (self)->set_user_agent_id (self, ua_id);
}

gint
g_web_get_user_agent_id (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_user_agent_id (self);
}

void
g_web_enable_url_loading (GWeb *self, gboolean enable)
{
	G_WEB_GET_CLASS (self)->enable_url_loading (self, enable);
}

void
g_web_free_memory (GWeb *self, gboolean progressive)
{
	G_WEB_GET_CLASS (self)->free_memory (self, progressive);
}


GWebStatus
g_web_store_transfers (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->store_transfers (self);
}

GWebStatus
g_web_restore_transfers (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->restore_transfers (self);
}

GWebStatus
g_web_delete_all_cookies (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->delete_all_cookies (self);
}

GWebStatus
g_web_confirm_cookie (GWeb *self, gpointer context, gboolean accept, GWebCookieAction action)
{
	return G_WEB_GET_CLASS (self)->confirm_cookie (self, context, accept, action);
}

GObject*
g_web_get_global (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_global (self);
}

GWebCertificateMessage
g_web_get_certificate_enum_message (GWeb *self, GObject *context)
{
	return G_WEB_GET_CLASS (self)->get_certificate_enum_message (self, context);
}

GWebCertificateReaction
g_web_perform_crtificate_context_action (GWeb *self,
                                                                   GObject *context,
                                                                   GWebCertificateAction action,
                                                                   GObject *cert)
{
	return G_WEB_GET_CLASS (self)->perform_crtificate_context_action (self, context, action, cert);
}

GWebStatus
g_web_get_certificate_context_iter (GWeb *self, GObject* context, GObject **iterator)
{
	return G_WEB_GET_CLASS (self)->get_certificate_context_iter (self, context, iterator);
}

GObject*
g_web_get_certificate_iter (GWeb *self, GObject** iterator)
{
	return G_WEB_GET_CLASS (self)->get_certificate_iter (self, iterator);
}

void
g_web_certificate_free (GWeb *self, GObject* cert)
{
	G_WEB_GET_CLASS (self)->certificate_free (self, cert);
}

void
g_web_certificate_iter_free (GWeb *self, GObject* iterator)
{
	G_WEB_GET_CLASS (self)->certificate_iter_free (self, iterator);
}

void
g_web_notify_plugins (GWeb *self, gint event)
{
	G_WEB_GET_CLASS (self)->notify_plugins (self, event);
}

void
g_web_notify_service (GWeb *self, const gchar *service_name, gpointer *context, const gchar *topic, gchar *data)
{
	G_WEB_GET_CLASS (self)->notify_service (self, service_name, context, topic, data);
}

gint
g_web_username_matchinfo_get_matches (GWeb *self, GObject *info)
{
	return G_WEB_GET_CLASS (self)->username_matchinfo_get_matches(self, info);
}

GWebStatus
g_web_username_matchinfo_get_username (GWeb *self, GObject* info, gint index, gchar** username)
{
	return G_WEB_GET_CLASS (self)->username_matchinfo_get_username (self, info, index, username);
}

void
g_web_username_matchinfo_delete (GWeb *self, GObject* info, gint index)
{
	return G_WEB_GET_CLASS (self)->username_matchinfo_delete (self, info, index);
}

GWebPasswordManager*
g_web_get_password_manager (GWeb *self, const gchar* server, gint index)
{
	return G_WEB_GET_CLASS (self)->get_password_manager (self, server, index);
}

GWebStatus
g_web_store_personal_data(GWeb *self, const gchar* server, const gchar* username, const gchar* password)
{
               return G_WEB_GET_CLASS (self)->store_personal_data (self, server, username, password);
}

GWebStatus
g_web_delete_personal_data(GWeb *self, const gchar* server, const gchar* username)
{
               return G_WEB_GET_CLASS (self)->delete_personal_data (self, server, username);
}

GWebStatus
g_web_set_remember_password (GWeb *self, gboolean rpassword)
{
	return G_WEB_GET_CLASS (self)->set_remember_password (self, rpassword);
}

gboolean
g_web_get_remember_password (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_remember_password (self);
}

GWebStatus
g_web_set_remember_password_for_forms (GWeb *self, gboolean rpassword)
{
	return G_WEB_GET_CLASS (self)->set_remember_password_for_forms (self, rpassword);
}

gboolean
g_web_get_remember_password_for_forms (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->get_remember_password_for_forms (self);
}

GWebStatus
g_web_clear_passwords (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->clear_passwords (self);
}

GWebStatus
g_web_clear_all_history (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->clear_all_history (self);
}

void
g_web_clear_personal_data (GWeb *self)
{
	G_WEB_GET_CLASS (self)->clear_personal_data (self);
}

GWebStatus
g_web_set_plugin_enabled (GWeb *self, gchar *name, gboolean enabled)
{
	return G_WEB_GET_CLASS (self)->set_plugin_enabled (self, name, enabled);
}

gboolean
g_web_get_plugin_enabled (GWeb *self,  gchar *name)
{
	return G_WEB_GET_CLASS (self)->get_plugin_enabled (self, name);
}

GWebStatus
g_web_set_plugin_ignore_filepath (GWeb *self)
{
	return G_WEB_GET_CLASS (self)->set_plugin_ignore_filepath (self);
}
